/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.oauth.authcode;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import org.junit.Before;
import org.junit.Test;
import org.mule.test.module.extension.oauth.BaseOAuthExtensionTestCase;

public class OAuthQueryParamParameterExtensionTestCase
extends BaseOAuthExtensionTestCase {
    protected String[] getConfigFiles() {
        return new String[]{"auth-code-oauth-extension-with-parameter-static-config.xml", "oauth-extension-flows.xml"};
    }

    @Before
    public void setOwnerId() throws Exception {
        this.ownerId = this.getCustomOwnerId();
    }

    @Test
    public void aliasedOAuthParameter() throws Exception {
        this.simulateDanceStart();
        this.wireMock.verify(WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/authorize")).withQueryParam("with_alias", WireMock.equalTo((String)"withAlias")));
    }

    @Test
    public void defaultPlacementParameter() throws Exception {
        this.simulateDanceStart();
        this.wireMock.verify(WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/authorize")).withQueryParam("defaultPlacement", WireMock.equalTo((String)"defaultPlacement")));
    }

    @Test
    public void explicitPlacementParameter() throws Exception {
        this.simulateDanceStart();
        this.wireMock.verify(WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/authorize")).withQueryParam("queryParam", WireMock.equalTo((String)"queryParam")));
    }

    @Test
    public void customHeaderAndBodyParams() throws Exception {
        this.simulateCallback(this.callbackPort.getNumber());
        this.wireMock.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/token")).withHeader("header", WireMock.equalTo((String)"header")).withRequestBody((ContentPattern)WireMock.containing((String)"bodyParameter=body")));
    }
}

