/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.oauth.authcode;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import io.qameta.allure.Issue;
import jakarta.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.notification.ExceptionNotificationListener;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.NotificationListenerRegistry;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.construct.Flow;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.tck.probe.PollingProber;
import org.mule.test.module.extension.oauth.BaseOAuthExtensionTestCase;

public class OAuthSourceRefreshExtensionTestCase
extends BaseOAuthExtensionTestCase {
    private static List<CoreEvent> EVENTS;
    private static final int PROBE_TIMEOUT = 5000;
    private static final int PROBE_FREQUENCY = 500;
    @Inject
    protected NotificationListenerRegistry notificationListenerRegistry;
    private Flow flow;

    protected String[] getConfigFiles() {
        return new String[]{"auth-code-oauth-extension-static-config.xml", "sources-oauth-extension-flows.xml"};
    }

    @Before
    public void clearEvents() {
        EVENTS = new ArrayList<CoreEvent>();
    }

    @Before
    public void setOwnerId() throws Exception {
        this.ownerId = this.getCustomOwnerId();
    }

    protected void doTearDown() throws Exception {
        if (this.flow != null) {
            this.flow.stop();
        }
        super.doTearDown();
    }

    @Test
    public void refreshTokenOnPollingSource() throws Exception {
        this.simulateCallback();
        WireMock.reset();
        this.stubTokenUrl(this.accessTokenContent("rbBQLgJXBEYo83K4Fqs4gu6vpCobc2ya-refreshed"));
        this.startFlow("pollingSource");
        PollingProber.check((long)5000L, (long)500L, () -> EVENTS.size() > 0);
        this.wireMock.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/token")));
    }

    @Test
    public void refreshTokenOnSource() throws Exception {
        this.simulateCallback();
        WireMock.reset();
        this.stubTokenUrl(this.accessTokenContent("rbBQLgJXBEYo83K4Fqs4gu6vpCobc2ya-refreshed"));
        this.startFlow("source");
        PollingProber.check((long)5000L, (long)500L, () -> EVENTS.size() > 0);
        this.wireMock.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/token")));
    }

    @Test
    @Issue(value="W-13628406")
    public void refreshTokenFailsOnSource() throws Exception {
        this.assertRefreshTokenOnSource("source");
    }

    @Test
    @Issue(value="W-13628406")
    public void refreshTokenFailsOnPollingSource() throws Exception {
        this.assertRefreshTokenOnSource("pollingSource");
    }

    private void assertRefreshTokenOnSource(String flowName) throws Exception {
        this.simulateCallback();
        WireMock.reset();
        this.wireMock.stubFor(WireMock.post((UrlPattern)WireMock.urlMatching((String)"/token")).willReturn(WireMock.aResponse().withStatus(HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode()).withBody("no token for you!")));
        Latch latch = new Latch();
        ExceptionNotificationListener listener = notification -> {
            if (notification.getException().getMessage().contains("Refresh token workflow was attempted but failed")) {
                latch.release();
            }
        };
        this.notificationListenerRegistry.registerListener((NotificationListener)listener);
        this.startFlow(flowName);
        latch.await(5000L, TimeUnit.MILLISECONDS);
        WireMock.reset();
        this.simulateCallback();
        this.stubTokenUrl(this.accessTokenContent("rbBQLgJXBEYo83K4Fqs4gu6vpCobc2ya-refreshed"));
        PollingProber.check((long)5000L, (long)500L, () -> EVENTS.size() > 0);
        this.wireMock.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/token")));
    }

    protected void startFlow(String flowName) throws Exception {
        this.flow = (Flow)this.getFlowConstruct(flowName);
        this.flow.start();
    }

    public static class Collector
    implements Processor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public CoreEvent process(CoreEvent event) throws MuleException {
            List<CoreEvent> list = EVENTS;
            synchronized (list) {
                EVENTS.add(event);
                return event;
            }
        }
    }
}

