/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.oauth;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.HttpService;
import org.mule.service.http.TestHttpClient;
import org.mule.test.module.extension.oauth.BaseOAuthExtensionTestCase;
import org.mule.test.oauth.TestOAuthConnection;
import org.mule.test.oauth.TestOAuthConnectionState;

public class OAuthHandlerObjectStoreTestCase
extends BaseOAuthExtensionTestCase {
    @ClassRule
    public static final TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public TestHttpClient httpClient = new TestHttpClient.Builder((HttpService)this.getService(HttpService.class)).build();

    protected void doSetUp() throws Exception {
        super.doSetUp();
        this.wireMock.stubFor(WireMock.post((UrlPattern)WireMock.urlPathMatching((String)"/token")).willReturn(WireMock.aResponse().withStatus(HttpConstants.HttpStatus.OK.getStatusCode()).withBody(this.accessTokenContent()).withHeader("Content-Type", new String[]{"application/json"})));
    }

    protected String[] getConfigFiles() {
        return new String[]{"oauthHandlerWithObjectStoreFlows.xml"};
    }

    @Test
    @Issue(value="W-11493901")
    @Description(value="verifiy object store is always created")
    public void verifyObjectStoreCreationDuringOAuth() throws Exception {
        TestOAuthConnectionState connection = ((TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue()).getState();
        ObjectStore os = this.getObjectStore("customStore");
        MatcherAssert.assertThat((Object)os, (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)connection.getConnectionDetails(), (Matcher)CoreMatchers.notNullValue());
    }
}

