/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.oauth.clientcredentials;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import jakarta.inject.Inject;
import java.util.Map;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Before;
import org.junit.Test;
import org.mule.oauth.client.api.state.ResourceOwnerOAuthContext;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsState;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.test.module.extension.oauth.BaseOAuthExtensionTestCase;
import org.mule.test.oauth.TestOAuthConnection;
import org.mule.test.oauth.TestOAuthConnectionState;

public abstract class AbstractClientCredentialsExternalServerTestCase
extends BaseOAuthExtensionTestCase {
    private LazyValue<ObjectStore> objectStore = new LazyValue(() -> muleContext.getObjectStoreManager().getObjectStore("customStore"));
    @Inject
    private ExtensionsClient extensionsClient;

    protected void doSetUp() throws Exception {
        super.doSetUp();
        ((ObjectStore)this.objectStore.get()).clear();
        this.wireMock.stubFor(WireMock.post((UrlPattern)WireMock.urlPathMatching((String)"/token")).willReturn(WireMock.aResponse().withStatus(HttpConstants.HttpStatus.OK.getStatusCode()).withBody(this.accessTokenContent()).withHeader("Content-Type", new String[]{"application/json"})));
    }

    public boolean addToolingObjectsToRegistry() {
        return true;
    }

    @Before
    public void setOwnerId() throws Exception {
        this.ownerId = this.getCustomOwnerId();
    }

    @Test
    public void authenticate() throws Exception {
        TestOAuthConnectionState connection = ((TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue()).getState();
        this.assertConnectionState(connection);
        this.assertOAuthStateStored("customStore", "default");
    }

    @Test
    public void unauthorize() throws Exception {
        this.authenticate();
        this.flowRunner("unauthorize").run();
        ObjectStore objectStore = this.getObjectStore("customStore");
        MatcherAssert.assertThat((Object)objectStore.retrieveAll().size(), (Matcher)CoreMatchers.is((Object)0));
        String refreshedToken = this.configureRefreshResponse();
        TestOAuthConnectionState connection = ((TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue()).getState();
        MatcherAssert.assertThat((Object)connection.getState().getAccessToken(), (Matcher)CoreMatchers.equalTo((Object)refreshedToken));
        this.assertRefreshToken(refreshedToken);
    }

    @Test
    public void refreshToken() throws Exception {
        this.authenticate();
        this.wireMock.resetAll();
        String refreshedToken = this.configureRefreshResponse();
        this.flowRunner("refreshToken").run();
        this.assertRefreshToken(refreshedToken);
    }

    @Test
    public void refreshTokenThroughExtensionClient() throws Exception {
        this.authenticate();
        this.wireMock.resetAll();
        String refreshedToken = this.configureRefreshResponse();
        this.extensionsClient.execute("Test OAuth Extension", "tokenExpired", params -> params.withConfigRef("oauth")).get();
        this.assertRefreshToken(refreshedToken);
    }

    @Test
    public void refreshTokenAsync() throws Exception {
        this.authenticate();
        this.wireMock.resetAll();
        String refreshedToken = this.configureRefreshResponse();
        this.flowRunner("refreshTokenAsync").run();
        this.assertRefreshToken(refreshedToken);
    }

    private String configureRefreshResponse() {
        String refreshedToken = "rbBQLgJXBEYo83K4Fqs4gu6vpCobc2ya-refreshed";
        this.wireMock.stubFor(WireMock.post((UrlPattern)WireMock.urlPathMatching((String)"/token")).willReturn(WireMock.aResponse().withStatus(HttpConstants.HttpStatus.OK.getStatusCode()).withBody(this.accessTokenContent(refreshedToken)).withHeader("Content-Type", new String[]{"application/json"})));
        return refreshedToken;
    }

    private void assertRefreshToken(String refreshedToken) throws Exception {
        this.wireMock.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/token")));
        Map entries = ((ObjectStore)this.objectStore.get()).retrieveAll();
        MatcherAssert.assertThat((Object)entries.size(), (Matcher)CoreMatchers.is((Object)1));
        ResourceOwnerOAuthContext context = (ResourceOwnerOAuthContext)entries.values().toArray()[0];
        MatcherAssert.assertThat((Object)context.getAccessToken(), (Matcher)CoreMatchers.equalTo((Object)refreshedToken));
    }

    @Override
    protected void assertAuthCodeState(TestOAuthConnectionState connection) {
        ClientCredentialsState state = (ClientCredentialsState)connection.getState();
        MatcherAssert.assertThat((Object)state.getAccessToken(), (Matcher)CoreMatchers.is((Object)"rbBQLgJXBEYo83K4Fqs4gu6vpCobc2ya"));
        MatcherAssert.assertThat((Object)((String)state.getExpiresIn().get()), (Matcher)CoreMatchers.is((Object)"3897"));
    }
}

