/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.oauth.ocs;

import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.extension.api.runtime.parameter.Literal;
import org.mule.test.module.extension.oauth.ocs.PlatformManagedOAuthConfigurationTestCase;
import org.mule.test.oauth.ConnectionProperties;
import org.mule.test.oauth.ConnectionType;
import org.mule.test.oauth.TestOAuthConnection;
import org.mule.test.oauth.TestOAuthConnectionState;
import org.mule.test.values.extension.MyPojo;

@Issue(value="W-10867511")
public class PlatformManagedOAuthConfigurationParametersTestCase
extends PlatformManagedOAuthConfigurationTestCase {
    private static final String EXTERNAL_POJO_PARAMETER_NAME_IN_POJO = "importedPojo";
    private static final String EXTERNAL_POJO_PARAMETER_NAME = "externalPojo";
    private static final String EXTERNAL_POJO_ID_FIELD_NAME = "pojoId";
    private static final String EXTERNAL_POJO_ID_FIELD_VALUE = "thePojoId";
    private static final String EXTERNAL_POJO_NAME_FIELD_NAME = "pojoName";
    private static final String EXTERNAL_POJO_NAME_FIELD_VALUE = "thePojoName";
    private static final String EXTERNAL_POJO_NUMBER_FIELD_NAME = "pojoNumber";
    private static final String EXTERNAL_POJO_NUMBER_FIELD_VALUE = "1234";
    private static final String EXTERNAL_POJO_BOOLEAN_FIELD_NAME = "pojoBoolean";
    private static final String EXTERNAL_POJO_BOOLEAN_FIELD_VALUE = "true";
    private static final MyPojo EXTERNAL_POJO_VALUE = new MyPojo("thePojoId", "thePojoName", Integer.valueOf("1234").intValue(), Boolean.valueOf("true").booleanValue());
    private static final String SECURITY_LEVEL_PARAMETER_NAME = "securityLevel";
    private static final String SECURITY_LEVEL_PARAMETER_VALUE = "100";
    private static final Integer SECURITY_LEVEL_PARAMETER_INT_VALUE = 100;
    private static final String COMPLEX_PARAMETER_NAME = "connectionProperties";
    private static final String COMPLEX_PARAMETER_NAME_IN_SHOWINDSL_PARAMETER_GROUP = "profileConnectionProperties";
    private static final String COMPLEX_PARAMETER_NAME_IN_NON_DEFAULT_PARAMETER_GROUP = "anotherConnectionProperties";
    private static final String CONNECTION_DESCRIPTION_FIELD_NAME = "connectionDescription";
    private static final String CONNECTION_DESCRIPTION_FIELD_VALUE = "This is the connection description";
    private static final String CONNECTION_TYPE_FIELD_NAME = "connectionType";
    private static final String CONNECTION_TYPE_FIELD_VALUE = "DUO";
    private static final String PROFILE_LEVEL_PARAMETER_NAME = "profileLevel";
    private static final String PROFILE_LEVEL_PARAMETER_VALUE = "25";
    private static final String DETAILS_PRIORITY_PARAMETER_NAME = "detailsPriority";
    private static final String DETAILS_PRIORITY_PARAMETER_VALUE = "55";
    private static final String OAUTH_CONNECTION_TYPE_PARAMETER_NAME = "oauthConnectionType";
    private static final String OAUTH_CONNECTION_TYPE_PARAMETER_VALUE = "HYPER";
    private static final String FIRST_SOME_NUMBER = "1";
    private static final String SECOND_SOME_NUMBER = "2";
    private static final String THIRD_SOME_NUMBER = "3";
    private static final String SOME_NUMBERS_PARAMETER_NAME = "someConnectionNumbers";
    private static final String CONNECTION_PROPERTIES_MAP_PARAMETER_NAME = "someMapOfConnectionProperties";
    private static final String MAP_FIRST_KEY = "first";
    private static final String MAP_SECOND_KEY = "second";
    private static final List<String> SOME_NUMBERS_PARAMETER_VALUE = Arrays.asList("1", "2", "3");
    private static final String SOME_CONNECTION_PROPERTIES_PARAMETER_NAME = "someOauthConnectionProperties";
    private static final ConnectionType OAUTH_CONNECTION_TYPE_PARAMETER_ENUM_VALUE = ConnectionType.HYPER;
    private static final ConnectionType CONNECTION_TYPE_FIELD_ENUM_VALUE = ConnectionType.DUO;
    private static final ZonedDateTime ZONED_DATE_TIME_VALUE = ZonedDateTime.ofInstant(Instant.ofEpochMilli(1619535600000L), ZoneId.of("-03:00"));
    private static final ConnectionProperties CONNECTION_PROPERTIES = new ConnectionProperties("This is the connection description", CONNECTION_TYPE_FIELD_ENUM_VALUE, (Literal)new Literal<String>(){

        public Optional<String> getLiteralValue() {
            return Optional.of(PlatformManagedOAuthConfigurationParametersTestCase.LITERAL_FIELD_IN_POJO_VALUE);
        }

        public Class<String> getType() {
            return null;
        }
    }, ZONED_DATE_TIME_VALUE, EXTERNAL_POJO_VALUE);
    private static final String ZONED_DATE_TIME_FIELD_VALUE = "2021-04-27T12:00:00-03:00";
    private static final String ZONED_DATE_TIME_FIELD_NAME = "connectionTime";
    private static final String LITERAL_STRING_PARAMETER_IN_PG_VALUE = "literal1";
    private static final String LITERAL_STRING_PARAMETER_VALUE = "#[expression.in.literal]";
    private static final String PARAMETER_RESOLVER_STRING_PARAMETER_VALUE = "paramResolver1";
    private static final String TYPED_VALUE_INTEGER_PARAMETER_VALUE = "33";
    private static final String LITERAL_FIELD_IN_POJO_VALUE = "someLiteralValue";
    private static final String LITERAL_STRING_PARAMETER_IN_PG_NAME = "profileDescription";
    private static final String LITERAL_STRING_PARAMETER_NAME = "literalSecurityDescription";
    private static final String PARAMETER_RESOLVER_STRING_PARAMETER_NAME = "resolverConnectionDisplayName";
    private static final String TYPED_VALUE_INTEGER_PARAMETER_NAME = "typedSecurityLevel";
    private static final String LITERAL_FIELD_IN_POJO_NAME = "connectionPropertyGrade";
    private static final String STACKED_POJO_PARAMETER = "stackedTypePojoParameter";
    private static final String STACKED_ARRAY_PARAMETER = "stackedTypeArrayParameters";
    private static final String STACKED_MAP_PARAMETER = "stackedTypeMapParameter";

    @Override
    protected Map<String, Object> getDescriptorParameters() {
        Map<String, Object> descriptorParameters = super.getDescriptorParameters();
        HashMap<String, Object> complexParameterMap = new HashMap<String, Object>();
        ArrayList<HashMap<String, Object>> someConnectionPropertiesValue = new ArrayList<HashMap<String, Object>>();
        HashMap<String, HashMap<String, Object>> someMapOfConnectionPropertiesValue = new HashMap<String, HashMap<String, Object>>();
        HashMap<String, String> externalPojo = new HashMap<String, String>();
        HashMap<String, String> mapOfIntegers = new HashMap<String, String>();
        mapOfIntegers.put(MAP_FIRST_KEY, FIRST_SOME_NUMBER);
        mapOfIntegers.put(MAP_SECOND_KEY, SECOND_SOME_NUMBER);
        externalPojo.put(EXTERNAL_POJO_BOOLEAN_FIELD_NAME, EXTERNAL_POJO_BOOLEAN_FIELD_VALUE);
        externalPojo.put(EXTERNAL_POJO_NUMBER_FIELD_NAME, EXTERNAL_POJO_NUMBER_FIELD_VALUE);
        externalPojo.put(EXTERNAL_POJO_ID_FIELD_NAME, EXTERNAL_POJO_ID_FIELD_VALUE);
        externalPojo.put(EXTERNAL_POJO_NAME_FIELD_NAME, EXTERNAL_POJO_NAME_FIELD_VALUE);
        complexParameterMap.put(CONNECTION_DESCRIPTION_FIELD_NAME, CONNECTION_DESCRIPTION_FIELD_VALUE);
        complexParameterMap.put(CONNECTION_TYPE_FIELD_NAME, CONNECTION_TYPE_FIELD_VALUE);
        complexParameterMap.put(LITERAL_FIELD_IN_POJO_NAME, LITERAL_FIELD_IN_POJO_VALUE);
        complexParameterMap.put(ZONED_DATE_TIME_FIELD_NAME, ZONED_DATE_TIME_FIELD_VALUE);
        complexParameterMap.put(EXTERNAL_POJO_PARAMETER_NAME_IN_POJO, externalPojo);
        someConnectionPropertiesValue.add(complexParameterMap);
        someConnectionPropertiesValue.add(complexParameterMap);
        someMapOfConnectionPropertiesValue.put(MAP_FIRST_KEY, complexParameterMap);
        someMapOfConnectionPropertiesValue.put(MAP_SECOND_KEY, complexParameterMap);
        descriptorParameters.put(CONNECTION_PROPERTIES_MAP_PARAMETER_NAME, someMapOfConnectionPropertiesValue);
        descriptorParameters.put(SOME_CONNECTION_PROPERTIES_PARAMETER_NAME, someConnectionPropertiesValue);
        descriptorParameters.put(COMPLEX_PARAMETER_NAME, complexParameterMap);
        descriptorParameters.put(COMPLEX_PARAMETER_NAME_IN_SHOWINDSL_PARAMETER_GROUP, complexParameterMap);
        descriptorParameters.put(COMPLEX_PARAMETER_NAME_IN_NON_DEFAULT_PARAMETER_GROUP, complexParameterMap);
        descriptorParameters.put(PROFILE_LEVEL_PARAMETER_NAME, PROFILE_LEVEL_PARAMETER_VALUE);
        descriptorParameters.put(DETAILS_PRIORITY_PARAMETER_NAME, DETAILS_PRIORITY_PARAMETER_VALUE);
        descriptorParameters.put(SECURITY_LEVEL_PARAMETER_NAME, SECURITY_LEVEL_PARAMETER_VALUE);
        descriptorParameters.put(OAUTH_CONNECTION_TYPE_PARAMETER_NAME, OAUTH_CONNECTION_TYPE_PARAMETER_VALUE);
        descriptorParameters.put(SOME_NUMBERS_PARAMETER_NAME, SOME_NUMBERS_PARAMETER_VALUE);
        descriptorParameters.put(LITERAL_STRING_PARAMETER_NAME, LITERAL_STRING_PARAMETER_VALUE);
        descriptorParameters.put(LITERAL_STRING_PARAMETER_IN_PG_NAME, LITERAL_STRING_PARAMETER_IN_PG_VALUE);
        descriptorParameters.put(PARAMETER_RESOLVER_STRING_PARAMETER_NAME, PARAMETER_RESOLVER_STRING_PARAMETER_VALUE);
        descriptorParameters.put(TYPED_VALUE_INTEGER_PARAMETER_NAME, TYPED_VALUE_INTEGER_PARAMETER_VALUE);
        descriptorParameters.put(ZONED_DATE_TIME_FIELD_NAME, ZONED_DATE_TIME_FIELD_VALUE);
        descriptorParameters.put(EXTERNAL_POJO_PARAMETER_NAME, externalPojo);
        descriptorParameters.put(STACKED_POJO_PARAMETER, externalPojo);
        descriptorParameters.put(STACKED_ARRAY_PARAMETER, SOME_NUMBERS_PARAMETER_VALUE);
        descriptorParameters.put(STACKED_MAP_PARAMETER, mapOfIntegers);
        return descriptorParameters;
    }

    @Test
    @Description(value="Validates that the PlatformManagedConnectionDescriptor can describe parameters of complex types.")
    public void complexParameter() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        TestOAuthConnectionState connectionState = connection.getState();
        MatcherAssert.assertThat((Object)connectionState.getConnectionProperties(), (Matcher)CoreMatchers.is((Object)CONNECTION_PROPERTIES));
    }

    @Test
    @Description(value="Validates that the PlatformManagedConnectionDescriptor can describe parameters of complex types that belongs to a parameter group that is shownInDsl.")
    public void complexParameterInShowInDslParameterGroup() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        TestOAuthConnectionState connectionState = connection.getState();
        MatcherAssert.assertThat((Object)connectionState.getConnectionProfile().getProfileConnectionProperties(), (Matcher)CoreMatchers.is((Object)CONNECTION_PROPERTIES));
    }

    @Test
    @Description(value="Validates that the PlatformManagedConnectionDescriptor can describe parameters of simple types that belongs to a parameter group that is shownInDsl")
    public void simpleParameterInShowInDslParameterGroup() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        TestOAuthConnectionState connectionState = connection.getState();
        MatcherAssert.assertThat((Object)connectionState.getConnectionProfile().getProfileLevel(), (Matcher)CoreMatchers.is((Object)Integer.valueOf(PROFILE_LEVEL_PARAMETER_VALUE)));
    }

    @Test
    @Description(value="Validates that the PlatformManagedConnectionDescriptor can describe parameters of complex types that belongs to the default parameter group.")
    public void complexParameterInNonShowDslInNonDefaultParameterGroup() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        TestOAuthConnectionState connectionState = connection.getState();
        MatcherAssert.assertThat((Object)connectionState.getConnectionDetails().getAnotherConnectionProperties(), (Matcher)CoreMatchers.is((Object)CONNECTION_PROPERTIES));
    }

    @Test
    @Description(value="Validates that the PlatformManagedConnectionDescriptor can describe simple parameters that belongs to a non-default parameter group that is not shownInDsl.")
    public void simpleParameterInNonShowInDslNonDefaultParameterGroup() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        TestOAuthConnectionState connectionState = connection.getState();
        MatcherAssert.assertThat((Object)connectionState.getConnectionDetails().getDetailsPriority(), (Matcher)CoreMatchers.is((Object)Integer.valueOf(DETAILS_PRIORITY_PARAMETER_VALUE)));
    }

    @Test
    @Description(value="Validates that the PlatformManagedConnectionDescriptor can describe enum parameters.")
    public void enumParameter() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        TestOAuthConnectionState connectionState = connection.getState();
        MatcherAssert.assertThat((Object)connectionState.getOauthConnectionType(), (Matcher)CoreMatchers.is((Object)OAUTH_CONNECTION_TYPE_PARAMETER_ENUM_VALUE));
    }

    @Test
    @Description(value="Validates that the PlatformManagedConnectionDescriptor can describe integer parameters that needs to be transformed from String.")
    public void integerParameterAsString() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        TestOAuthConnectionState connectionState = connection.getState();
        MatcherAssert.assertThat((Object)connectionState.getSecurityLevel(), (Matcher)CoreMatchers.is((Object)SECURITY_LEVEL_PARAMETER_INT_VALUE));
    }

    @Test
    @Description(value="Validates that the PlatformManagedConnectionDescriptor can describe a parameter whose time is List<Integer>.")
    public void arrayOfIntegerParameter() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        TestOAuthConnectionState connectionState = connection.getState();
        List someConnectionNumbers = connectionState.getSomeConnectionNumbers();
        MatcherAssert.assertThat((Object)someConnectionNumbers, (Matcher)Matchers.hasSize((int)SOME_NUMBERS_PARAMETER_VALUE.size()));
        MatcherAssert.assertThat((Object)someConnectionNumbers, (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{Integer.valueOf(FIRST_SOME_NUMBER), Integer.valueOf(SECOND_SOME_NUMBER), Integer.valueOf(THIRD_SOME_NUMBER)}));
    }

    @Test
    @Description(value="Validates that the PlatformManagedConnectionDescriptor can describe a parameter whose type is a list of a complex type.")
    public void arrayOfComplexTypeParameter() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        TestOAuthConnectionState connectionState = connection.getState();
        List someOauthConnectionProperties = connectionState.getSomeOauthConnectionProperties();
        MatcherAssert.assertThat((Object)someOauthConnectionProperties, (Matcher)Matchers.hasSize((int)2));
        someOauthConnectionProperties.forEach(someOauthConnectionProperty -> MatcherAssert.assertThat((Object)someOauthConnectionProperty, (Matcher)CoreMatchers.is((Object)CONNECTION_PROPERTIES)));
    }

    @Test
    @Description(value="Validates that the PlatformManagedConnectionDescriptor can describe a parameter whose type is a map with a complex value.")
    public void mapOfComplexValueTypeParameter() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        TestOAuthConnectionState connectionState = connection.getState();
        Map someOauthMapConnectionProperties = connectionState.getSomeMapOfConnectionProperties();
        MatcherAssert.assertThat(someOauthMapConnectionProperties.entrySet(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((ConnectionProperties)someOauthMapConnectionProperties.get(MAP_FIRST_KEY)), (Matcher)CoreMatchers.is((Object)CONNECTION_PROPERTIES));
        MatcherAssert.assertThat((Object)((ConnectionProperties)someOauthMapConnectionProperties.get(MAP_SECOND_KEY)), (Matcher)CoreMatchers.is((Object)CONNECTION_PROPERTIES));
    }

    @Test
    @Description(value="Validates that the PlatformManagedConnectionDescriptor can describe a parameter whose type is a Literal.")
    public void literalTypeParameter() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        TestOAuthConnectionState connectionState = connection.getState();
        MatcherAssert.assertThat((Object)((String)connectionState.getLiteralSecurityDescription().getLiteralValue().get()), (Matcher)CoreMatchers.is((Object)LITERAL_STRING_PARAMETER_VALUE));
    }

    @Test
    @Description(value="Validates that the PlatformManagedConnectionDescriptor can describe a parameter whose type is a TypedValue.")
    public void typedValueTypeParameter() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        TestOAuthConnectionState connectionState = connection.getState();
        MatcherAssert.assertThat((Object)((Integer)connectionState.getTypedSecurityLevel().getValue()), (Matcher)CoreMatchers.is((Object)Integer.valueOf(TYPED_VALUE_INTEGER_PARAMETER_VALUE)));
    }

    @Test
    @Description(value="Validates that the PlatformManagedConnectionDescriptor can describe a parameter whose type is a ParameterResolver.")
    public void parameterResolverTypeParameter() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        TestOAuthConnectionState connectionState = connection.getState();
        MatcherAssert.assertThat((Object)((String)connectionState.getResolverConnectionDisplayName().resolve()), (Matcher)CoreMatchers.is((Object)PARAMETER_RESOLVER_STRING_PARAMETER_VALUE));
    }

    @Test
    @Description(value="Validates that the PlatformManagedConnectionDescriptor can describe a parameter of Literal type inside a showInDsl parameter group.")
    public void literalTypeParameterInParameterGroupShowInDsl() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        TestOAuthConnectionState connectionState = connection.getState();
        MatcherAssert.assertThat((Object)((String)connectionState.getConnectionProfile().getProfileDescription().getLiteralValue().get()), (Matcher)CoreMatchers.is((Object)LITERAL_STRING_PARAMETER_IN_PG_VALUE));
    }

    @Test
    @Description(value="Validates that the PlatformManagedConnectionDescriptor can describe a field of Literal type inside a complex parameter.")
    public void literalTypeParameterInPojo() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        TestOAuthConnectionState connectionState = connection.getState();
        MatcherAssert.assertThat((Object)((String)connectionState.getConnectionDetails().getAnotherConnectionProperties().getConnectionPropertyGrade().getLiteralValue().get()), (Matcher)CoreMatchers.is((Object)LITERAL_FIELD_IN_POJO_VALUE));
    }

    @Test
    @Description(value="Validates that the PlatformManagedConnectionDescriptor handles a complex parameter that injects a mule dependency.")
    public void complexParameterHasInjectedDependency() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        TestOAuthConnectionState connectionState = connection.getState();
        MatcherAssert.assertThat((Object)connectionState.getConnectionProperties().getExtensionManager(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    @Description(value="Validates that the PlatformManagedConnectionDescriptor handles a map parameter with complex values that inject a mule dependency.")
    public void complexParameterInMapValueHasInjectedDependency() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        TestOAuthConnectionState connectionState = connection.getState();
        MatcherAssert.assertThat((Object)((ConnectionProperties)connectionState.getSomeMapOfConnectionProperties().get(MAP_FIRST_KEY)).getExtensionManager(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    @Description(value="Validates that the PlatformManagedConnectionDescriptor handles a list parameter with complex items that inject a mule dependency.")
    public void complexParameterInListHasInjectedDependency() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        TestOAuthConnectionState connectionState = connection.getState();
        MatcherAssert.assertThat((Object)((ConnectionProperties)connectionState.getSomeOauthConnectionProperties().get(0)).getExtensionManager(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    @Description(value="Validates that the PlatformManagedConnectionDescriptor handles a map parameter of complex type that inject a mule dependency and belongs to a showInDsl parameter group.")
    public void complexParameterInShowInDslParameterGroupHasInjectedDependency() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        TestOAuthConnectionState connectionState = connection.getState();
        MatcherAssert.assertThat((Object)connectionState.getConnectionProfile().getProfileConnectionProperties().getExtensionManager(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
    }

    @Test
    @Description(value="Validates that the PlatformManagedConnectionDescriptor handles a complex parameter with a Date type field.")
    public void complexParameterWithDateField() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        TestOAuthConnectionState connectionState = connection.getState();
        MatcherAssert.assertThat((Object)connectionState.getConnectionProperties().getConnectionTime(), (Matcher)CoreMatchers.is((Object)ZONED_DATE_TIME_VALUE));
    }

    @Test
    @Description(value="Validates that the PlatformManagedConnectionDescriptor handles a list parameter whose items are of complex type with a Date type field.")
    public void listParameterOfComplexTypeWithDateField() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        TestOAuthConnectionState connectionState = connection.getState();
        MatcherAssert.assertThat((Object)((ConnectionProperties)connectionState.getSomeOauthConnectionProperties().get(0)).getConnectionTime(), (Matcher)CoreMatchers.is((Object)ZONED_DATE_TIME_VALUE));
    }

    @Test
    @Description(value="Validates that the PlatformManagedConnectionDescriptor handles a Date type parameter")
    public void parameterOfDateType() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        TestOAuthConnectionState connectionState = connection.getState();
        MatcherAssert.assertThat((Object)connectionState.getConnectionTime(), (Matcher)CoreMatchers.is((Object)ZONED_DATE_TIME_VALUE));
    }

    @Test
    @Description(value="Validates that the PlatformManagedConnectionDescriptor handles a parameter of a type that belongs to another extension.")
    public void externalTypeParameter() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        TestOAuthConnectionState connectionState = connection.getState();
        MatcherAssert.assertThat((Object)connectionState.getExternalPojo(), (Matcher)CoreMatchers.is((Object)EXTERNAL_POJO_VALUE));
    }

    @Test
    @Description(value="Validates that the PlatformManagedConnectionDescriptor handles a complex parameter parameter with a field of a type that belongs to another extension.")
    public void externalTypeInsidePojoParameter() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        TestOAuthConnectionState connectionState = connection.getState();
        MatcherAssert.assertThat((Object)connectionState.getConnectionProperties().getImportedPojo(), (Matcher)CoreMatchers.is((Object)EXTERNAL_POJO_VALUE));
    }

    @Test
    @Description(value="Validates that the PlatformManagedConnectionDescriptor can describe a parameter whose type is a custom pojo wrapped in a TypedValue wrapped in a ParameterResolver.")
    public void complexTypeInATypedValueInAParameterResolver() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        TestOAuthConnectionState connectionState = connection.getState();
        MatcherAssert.assertThat((Object)((MyPojo)((TypedValue)connectionState.getStackedTypePojoParameter().resolve()).getValue()), (Matcher)CoreMatchers.is((Object)EXTERNAL_POJO_VALUE));
    }

    @Test
    @Description(value="Validates that the PlatformManagedConnectionDescriptor can describe a parameter whose type is an arrylist wrapped in a TypedValue wrapped in a ParameterResolver.")
    public void listInATypedValueInAParameterResolver() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        TestOAuthConnectionState connectionState = connection.getState();
        MatcherAssert.assertThat((Object)((List)((TypedValue)connectionState.getStackedTypeArrayParameters().resolve()).getValue()), (Matcher)Matchers.hasSize((int)SOME_NUMBERS_PARAMETER_VALUE.size()));
        MatcherAssert.assertThat((Object)((List)((TypedValue)connectionState.getStackedTypeArrayParameters().resolve()).getValue()), (Matcher)Matchers.containsInAnyOrder((Object[])new Integer[]{Integer.valueOf(FIRST_SOME_NUMBER), Integer.valueOf(SECOND_SOME_NUMBER), Integer.valueOf(THIRD_SOME_NUMBER)}));
    }

    @Test
    @Description(value="Validates that the PlatformManagedConnectionDescriptor can describe a parameter whose type is a map wrapped in a TypedValue wrapped in a ParameterResolver.")
    public void mapInATypedValueInAParameterResolver() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        TestOAuthConnectionState connectionState = connection.getState();
        Map mapParameter = (Map)((TypedValue)connectionState.getStackedTypeMapParameter().resolve()).getValue();
        MatcherAssert.assertThat(mapParameter.values(), (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)((Integer)mapParameter.get(MAP_FIRST_KEY)), (Matcher)CoreMatchers.is((Object)Integer.valueOf(FIRST_SOME_NUMBER)));
        MatcherAssert.assertThat((Object)((Integer)mapParameter.get(MAP_SECOND_KEY)), (Matcher)CoreMatchers.is((Object)Integer.valueOf(SECOND_SOME_NUMBER)));
    }
}

