/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.oauth.authcode;

import java.io.IOException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.module.extension.oauth.BaseOAuthExtensionTestCase;
import org.mule.test.oauth.TestOAuthConnection;
import org.mule.test.oauth.TestOAuthConnectionState;

public class MultiConfigOAuthExtensionTestCase
extends BaseOAuthExtensionTestCase {
    @Rule
    public DynamicPort otherCallbackPort = new DynamicPort("otherCallbackPort");

    protected String getConfigFile() {
        return "multi-config-owner-oauth-extension-config.xml";
    }

    @Before
    public void setOwnerId() throws Exception {
        this.ownerId = "default";
    }

    @Test
    public void authorizeAndStartDancingBaby() throws Exception {
        this.startDance(this.callbackPort.getNumber());
        this.simulateDanceStart(this.otherCallbackPort.getNumber());
        this.verifyAuthUrlRequest(this.otherCallbackPort.getNumber());
    }

    @Test
    public void receiveAccessTokenAndUserConnection() throws Exception {
        this.simulateCallback();
        TestOAuthConnectionState connection = ((TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue()).getState();
        this.assertConnectionState(connection);
        this.assertOAuthStateStored("_defaultPersistentObjectStore", this.ownerId);
        this.getObjectStore("_defaultPersistentObjectStore").clear();
        this.simulateCallback(this.otherCallbackPort.getNumber());
        TestOAuthConnectionState otherConnection = ((TestOAuthConnection)this.flowRunner("getOtherConnection").run().getMessage().getPayload().getValue()).getState();
        this.assertConnectionState(otherConnection);
        this.assertOAuthStateStored("_defaultPersistentObjectStore", this.ownerId);
    }

    @Test
    public void unauthorize() throws Exception {
        this.startDance(this.callbackPort.getNumber());
        this.getConnection(this.callbackPort.getNumber(), "getConnection");
        this.flowRunner("unauthorize").run();
        ObjectStore objectStore = this.getObjectStore("_defaultPersistentObjectStore");
        Assert.assertThat((Object)objectStore.retrieveAll().size(), (Matcher)CoreMatchers.is((Object)0));
        this.startDance(this.otherCallbackPort.getNumber());
        this.getConnection(this.otherCallbackPort.getNumber(), "getOtherConnection");
        this.flowRunner("unauthorizeOther").run();
        Assert.assertThat((Object)objectStore.retrieveAll().size(), (Matcher)CoreMatchers.is((Object)0));
    }

    private void getConnection(int port, String flowName) throws Exception {
        this.simulateCallback(port);
        TestOAuthConnectionState connection = ((TestOAuthConnection)this.flowRunner(flowName).run().getMessage().getPayload().getValue()).getState();
        this.assertConnectionState(connection);
        this.assertOAuthStateStored("_defaultPersistentObjectStore", this.ownerId);
    }

    private void startDance(int port) throws IOException {
        this.simulateDanceStart(port);
        this.verifyAuthUrlRequest(port);
    }
}

