/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.oauth.ocs;

import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeState;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsState;
import org.mule.test.module.extension.oauth.ocs.PlatformManagedOAuthConfigurationTestCase;
import org.mule.test.oauth.TestOAuthConnection;

public class PlatformManagedOAuthSuccessfulTestCase
extends PlatformManagedOAuthConfigurationTestCase {
    private static final String EMPTY_STRING = "";
    private static final String CONFIG_NAME = "oauth-platform";

    @Test
    public void accessTokenRetrieval() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)connection.getState().getState().getAccessToken(), (Matcher)Matchers.is((Object)"accessTokenTest"));
    }

    @Test
    public void correctOAuthStateInjected() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        if (this.usesAuthorizationCodeProvider) {
            MatcherAssert.assertThat((Object)connection.getState().getState(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(AuthorizationCodeState.class)));
        } else {
            MatcherAssert.assertThat((Object)connection.getState().getState(), (Matcher)Matchers.is((Matcher)Matchers.instanceOf(ClientCredentialsState.class)));
        }
    }

    @Test
    public void noRefreshTokenIsRetrieved() throws Exception {
        if (this.usesAuthorizationCodeProvider) {
            TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
            MatcherAssert.assertThat((Object)((AuthorizationCodeState)connection.getState().getState()).getRefreshToken(), (Matcher)Matchers.is(Optional.empty()));
        }
    }

    @Test
    public void tokenAndAccessUrlsAreNotDisclosed() throws Exception {
        if (this.usesAuthorizationCodeProvider) {
            TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
            MatcherAssert.assertThat((Object)((AuthorizationCodeState)connection.getState().getState()).getAccessTokenUrl(), (Matcher)Matchers.is((Object)EMPTY_STRING));
            MatcherAssert.assertThat((Object)((AuthorizationCodeState)connection.getState().getState()).getAuthorizationUrl(), (Matcher)Matchers.is((Object)EMPTY_STRING));
        }
    }

    @Test
    public void callbackParametersAreSettedCorrectly() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)connection.getState().getInstanceId(), (Matcher)Matchers.is((Object)"instanceIdTest"));
        MatcherAssert.assertThat((Object)connection.getState().getUserId(), (Matcher)Matchers.is((Object)"userIdTest"));
    }

    @Test
    public void expiredInIsRetrieved() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)((String)connection.getState().getState().getExpiresIn().get()), (Matcher)Matchers.is((Object)"expiresInTest"));
    }

    @Test
    public void parametersAreInjectedCorrectly() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)connection.getState().getApiVersion(), (Matcher)Matchers.is((Object)API_VERSION_TEST));
        MatcherAssert.assertThat((Object)connection.getState().isPrompt(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void configurationNameIsInjectedCorrectly() throws Exception {
        TestOAuthConnection connection = (TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue();
        MatcherAssert.assertThat((Object)connection.getState().getConfigName(), (Matcher)Matchers.is((Object)CONFIG_NAME));
    }
}

