/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.oauth.authcode;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Issues;
import io.qameta.allure.Story;
import jakarta.inject.Inject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.Location;
import org.mule.runtime.config.api.LazyComponentInitializer;
import org.mule.test.module.extension.oauth.BaseOAuthExtensionTestCase;

@Feature(value="Configuration component locator")
@Story(value="Search configuration")
public class LazyInitConfigurationComponentLocatorTestCase
extends BaseOAuthExtensionTestCase {
    @Inject
    private LazyComponentInitializer lazyComponentInitializer;

    protected String[] getConfigFiles() {
        return new String[]{"auth-code-oauth-extension-config.xml", "oauth-extension-flows.xml"};
    }

    public boolean enableLazyInit() {
        return true;
    }

    public boolean disableXmlValidations() {
        return true;
    }

    @Description(value="Lazy init should not create components until an operation is done")
    @Test
    public void lazyInitCalculatesLocations() {
        List allLocations = this.locator.findAllLocations().stream().map(ComponentLocation::getLocation).collect(Collectors.toList());
        MatcherAssert.assertThat((String)allLocations.toString(), allLocations, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"listenerConfig", "listenerConfig/connection", "oauth", "oauth/connection", "oauth/connection/1/0", "oauth/connection/1/2", "oauth/connection/3", "oauth/connection/1/1", "oauth/connection/2", "oauth/connection/0/0", "oauth/connection/0/1", "oauth/connection/4/0", "getConnection", "getConnection/processors/0", "beforeFlow", "beforeFlow/processors/0", "afterFlow", "afterFlow/processors/0", "afterFlow/processors/1", "refreshToken", "refreshToken/processors/0", "refreshTokenAsync", "refreshTokenAsync/processors/0", "unauthorize", "unauthorize/processors/0", "pagedOperationFailsAtFirstPage", "pagedOperationFailsAtFirstPage/processors/0", "pagedOperationFailsAtThirdPage", "pagedOperationFailsAtThirdPage/processors/0", "pagedOperationFailsAtThirdPage/processors/1", "pagedOperationFailsAtThirdPage/processors/2", "pagedOperationFailsAtThirdPage/processors/2/processors/0", "metadata", "metadata/processors/0", "anotherMetadata", "anotherMetadata/processors/0", "entitiesMetadata", "entitiesMetadata/processors/0", "values", "values/processors/0", "sampleData", "sampleData/processors/0"}));
        MatcherAssert.assertThat((Object)this.locator.find(Location.builder().globalName("oauth").build()), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)this.locator.find(Location.builder().globalName("listenerConfig").build()), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)this.locator.find(Location.builder().globalName("beforeFlow").build()), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)this.locator.find(Location.builder().globalName("afterFlow").build()), (Matcher)Matchers.is(Optional.empty()));
        MatcherAssert.assertThat((Object)this.locator.find(Location.builder().globalName("unauthorize").build()), (Matcher)Matchers.is(Optional.empty()));
    }

    @Test
    @Issues(value={@Issue(value="MULE-18513"), @Issue(value="MULE-18528")})
    public void oauthAuthCodeCallbackInitializesHttpListener() {
        this.lazyComponentInitializer.initializeComponent(Location.builder().globalName("oauth").build());
        MatcherAssert.assertThat((Object)this.locator.find(Location.builder().globalName("oauth").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        MatcherAssert.assertThat((Object)this.locator.find(Location.builder().globalName("listenerConfig").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        MatcherAssert.assertThat((Object)this.locator.find(Location.builder().globalName("beforeFlow").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        MatcherAssert.assertThat((Object)this.locator.find(Location.builder().globalName("afterFlow").build()), (Matcher)Matchers.is((Matcher)Matchers.not(Optional.empty())));
        MatcherAssert.assertThat((Object)this.locator.find(Location.builder().globalName("unauthorize").build()), (Matcher)Matchers.is(Optional.empty()));
    }
}

