/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.oauth.authcode;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.module.extension.oauth.BaseOAuthExtensionTestCase;

public class OAuthExtensionWithCredentialsPlacementTestCase
extends BaseOAuthExtensionTestCase {
    @Rule
    public DynamicPort otherCallbackPort = new DynamicPort("otherCallbackPort");

    protected String[] getConfigFiles() {
        return new String[]{"auth-code-oauth-extension-with-credentials-placement-config.xml", "oauth-extension-flows.xml"};
    }

    @Before
    public void setOwnerId() {
        this.ownerId = this.getCustomOwnerId();
    }

    @Test
    public void testCredentialsPlacementInHeaderForTokenRequest() {
        this.simulateCallback(this.callbackPort.getNumber());
        this.wireMock.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/token")).withHeader("Authorization", WireMock.equalTo((String)this.toBasicAuthorizationHeader("ndli93xdws2qoe6ms1d389vl6bxquv3e", "yL692Az1cNhfk1VhTzyx4jOjjMKBrO9T"))).withRequestBody((ContentPattern)WireMock.notMatching((String)".*client_id.*")).withRequestBody((ContentPattern)WireMock.notMatching((String)".*client_secret.*")));
    }

    @Test
    public void testCredentialsPlacementInHeaderForRefreshTokenRequest() throws Exception {
        this.simulateCallback(this.callbackPort.getNumber());
        WireMock.reset();
        this.stubRefreshToken();
        ((FlowRunner)this.flowRunner("refreshToken").withVariable("ownerId", (Object)this.getCustomOwnerId())).run();
        this.wireMock.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/token")).withHeader("Authorization", WireMock.equalTo((String)this.toBasicAuthorizationHeader("ndli93xdws2qoe6ms1d389vl6bxquv3e", "yL692Az1cNhfk1VhTzyx4jOjjMKBrO9T"))).withRequestBody((ContentPattern)WireMock.notMatching((String)".*client_id.*")).withRequestBody((ContentPattern)WireMock.notMatching((String)".*client_secret.*")).withRequestBody((ContentPattern)WireMock.containing((String)"cry825cyCs2O0j7tRXXVS4AXNu7hsO5wbWjcBoFFcJePy5zZwuQEevIp6hsUaywp")));
    }

    @Test
    public void testCredentialsPlacementDefaultsToBodyForTokenRequest() {
        this.simulateCallback(this.otherCallbackPort.getNumber());
        this.wireMock.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/token")).withoutHeader("Authorization").withRequestBody((ContentPattern)WireMock.matching((String)".*client_id.*")).withRequestBody((ContentPattern)WireMock.matching((String)".*client_secret.*")));
    }

    @Test
    public void testCredentialsPlacementDefaultsToBodyForRefreshTokenRequest() throws Exception {
        this.simulateCallback(this.otherCallbackPort.getNumber());
        WireMock.reset();
        this.stubRefreshToken();
        ((FlowRunner)this.flowRunner("refreshOtherToken").withVariable("ownerId", (Object)this.getCustomOwnerId())).run();
        this.wireMock.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/token")).withoutHeader("Authorization").withRequestBody((ContentPattern)WireMock.matching((String)".*client_id.*")).withRequestBody((ContentPattern)WireMock.matching((String)".*client_secret.*")).withRequestBody((ContentPattern)WireMock.containing((String)"cry825cyCs2O0j7tRXXVS4AXNu7hsO5wbWjcBoFFcJePy5zZwuQEevIp6hsUaywp")));
    }
}

