/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.oauth.ocs;

import io.qameta.allure.Feature;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mule.oauth.client.api.state.DancerState;
import org.mule.oauth.client.api.state.ResourceOwnerOAuthContext;
import org.mule.runtime.api.el.MuleExpressionLanguage;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationBuilder;
import org.mule.runtime.core.api.config.builders.AbstractConfigurationBuilder;
import org.mule.runtime.oauth.api.OAuthService;
import org.mule.runtime.oauth.api.PlatformManagedConnectionDescriptor;
import org.mule.runtime.oauth.api.PlatformManagedOAuthDancer;
import org.mule.runtime.oauth.api.builder.OAuthPlatformManagedDancerBuilder;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.module.extension.oauth.BaseOAuthExtensionTestCase;
import org.mule.test.runner.RunnerDelegateTo;

@Feature(value="OCS Support")
@RunnerDelegateTo(value=Parameterized.class)
public abstract class PlatformManagedOAuthTestCase
extends BaseOAuthExtensionTestCase {
    protected static final String TEST_ACCESS_TOKEN = "accessTokenTest";
    protected static final String EXPIRES_IN_TEST = "expiresInTest";
    protected static final String USER_ID_PARAMETER_NAME = "userId";
    protected static final String USER_ID_TEST = "userIdTest";
    protected static final String INSTANCE_ID_TEST = "instanceIdTest";
    protected static final String INSTANCE_ID_PARAMETER_NAME = "instanceId";
    protected static final String DISPLAY_PARAMETER_NAME = "display";
    protected static final String DISPLAY_TEST = "displayTestValue";
    protected static final String API_VERSION_PARAMETER_NAME = "apiVersion";
    protected static final String PROMPT_PARAMETER_NAME = "prompt";
    protected static final boolean PROMPT_TEST = false;
    protected static final Double API_VERSION_TEST = 5.3;
    @ClassRule
    public static SystemProperty enableOcs = new SystemProperty("ocs.enabled", "true");
    @ClassRule
    public static SystemProperty disableCacheComponentBuildingDefinitionRegistry = new SystemProperty("mule..functionalTest.cacheComponentBuildingDefinitionRegistry.disableOverride", "true");
    protected OAuthPlatformManagedDancerBuilder mockPlatformManagedDancerBuilder = (OAuthPlatformManagedDancerBuilder)Mockito.mock(OAuthPlatformManagedDancerBuilder.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    protected PlatformManagedOAuthDancer mockPlatformDancer = (PlatformManagedOAuthDancer)Mockito.mock(PlatformManagedOAuthDancer.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
    protected OAuthService mockOAuthService = (OAuthService)Mockito.mock(OAuthService.class);
    protected PlatformManagedConnectionDescriptor mockPlatformManagedConnectionDescriptor = (PlatformManagedConnectionDescriptor)Mockito.mock(PlatformManagedConnectionDescriptor.class);
    @Parameterized.Parameter(value=0)
    public String name;
    @Parameterized.Parameter(value=1)
    public String configFile;
    @Parameterized.Parameter(value=2)
    public boolean usesAuthorizationCodeProvider;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"Client Credentials configuration", "ocs/client-credentials-platform-managed-config.xml", false}, {"Authorization Code configuration", "ocs/authorization-code-platform-managed-config.xml", true}, {"Resolved configuration", "ocs/resolved-platform-managed-config.xml", true});
    }

    protected String[] getConfigFiles() {
        return new String[]{this.configFile, "ocs/platform-managed-flows.xml"};
    }

    protected void addBuilders(List<ConfigurationBuilder> builders) {
        super.addBuilders(builders);
        Mockito.when((Object)this.mockOAuthService.platformManagedOAuthDancerBuilder((LockFactory)ArgumentMatchers.any(), (Map)ArgumentMatchers.any(), (MuleExpressionLanguage)ArgumentMatchers.any())).thenReturn((Object)this.mockPlatformManagedDancerBuilder);
        Mockito.when((Object)((PlatformManagedOAuthDancer)this.mockPlatformManagedDancerBuilder.build())).thenReturn((Object)this.mockPlatformDancer);
        builders.add((ConfigurationBuilder)new AbstractConfigurationBuilder(){

            protected void doConfigure(MuleContext muleContext) throws Exception {
                muleContext.getCustomizationService().overrideDefaultServiceImpl("OAUTH service - OAuthService", (Object)PlatformManagedOAuthTestCase.this.mockOAuthService);
            }
        });
    }

    protected boolean isDisposeContextPerClass() {
        return false;
    }

    @Before
    public void doSetUpBeforeMuleContextCreation() throws Exception {
        CompletableFuture connectionDescriptorCompletableFuture = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        Mockito.when((Object)this.mockPlatformDancer.getConnectionDescriptor()).thenReturn((Object)connectionDescriptorCompletableFuture);
        Mockito.when((Object)((PlatformManagedConnectionDescriptor)connectionDescriptorCompletableFuture.get())).thenReturn((Object)this.mockPlatformManagedConnectionDescriptor);
        Mockito.when((Object)this.mockPlatformManagedConnectionDescriptor.getParameters()).thenReturn(this.getDescriptorParameters());
        CompletableFuture accessTokenCompletableFuture = (CompletableFuture)Mockito.mock(CompletableFuture.class);
        Mockito.when((Object)this.mockPlatformDancer.accessToken()).thenReturn((Object)accessTokenCompletableFuture);
        Mockito.when((Object)((String)accessTokenCompletableFuture.get())).thenReturn((Object)this.getAccessToken());
        ResourceOwnerOAuthContext resourceOwnerOAuthContext = (ResourceOwnerOAuthContext)Mockito.mock(ResourceOwnerOAuthContext.class);
        Mockito.when((Object)this.mockPlatformDancer.getContext()).thenReturn((Object)resourceOwnerOAuthContext);
        Mockito.when((Object)resourceOwnerOAuthContext.getAccessToken()).thenReturn((Object)this.getAccessToken());
        Mockito.when((Object)resourceOwnerOAuthContext.getDancerState()).thenReturn((Object)this.getDancerState());
        Mockito.when((Object)resourceOwnerOAuthContext.getExpiresIn()).thenReturn((Object)this.getExpiresIn());
        Mockito.when((Object)resourceOwnerOAuthContext.getTokenResponseParameters()).thenReturn(this.getTokenResponseParameters());
    }

    protected Map<String, Object> getDescriptorParameters() {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(DISPLAY_PARAMETER_NAME, DISPLAY_TEST);
        parameters.put(API_VERSION_PARAMETER_NAME, API_VERSION_TEST);
        parameters.put(PROMPT_PARAMETER_NAME, false);
        return parameters;
    }

    protected String getAccessToken() {
        return TEST_ACCESS_TOKEN;
    }

    protected DancerState getDancerState() {
        return DancerState.HAS_TOKEN;
    }

    protected String getExpiresIn() {
        return EXPIRES_IN_TEST;
    }

    protected Map<String, Object> getTokenResponseParameters() {
        HashMap<String, Object> tokenResponseParameters = new HashMap<String, Object>();
        tokenResponseParameters.put(USER_ID_PARAMETER_NAME, USER_ID_TEST);
        tokenResponseParameters.put(INSTANCE_ID_PARAMETER_NAME, INSTANCE_ID_TEST);
        return tokenResponseParameters;
    }

    protected boolean mustRegenerateExtensionModels() {
        return true;
    }
}

