/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.oauth;

import com.github.tomakehurst.wiremock.client.MappingBuilder;
import com.github.tomakehurst.wiremock.client.ResponseDefinitionBuilder;
import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.rules.ExpectedException;
import org.mule.oauth.client.api.state.ResourceOwnerOAuthContext;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.extension.api.connectivity.oauth.AuthorizationCodeState;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.runtime.http.api.utils.HttpEncoderDecoderUtils;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.tck.probe.PollingProber;
import org.mule.test.module.extension.AbstractExtensionFunctionalTestCase;
import org.mule.test.oauth.TestOAuthConnectionState;

public abstract class BaseOAuthExtensionTestCase
extends AbstractExtensionFunctionalTestCase {
    protected static final int REQUEST_TIMEOUT = 10000;
    protected static final String LOCAL_AUTH_PATH = "dance";
    protected static final String CALLBACK_PATH = "callback";
    protected static final String OWNER_ID_VARIABLE_NAME = "ownerId";
    protected static final String DEFAULT_OWNER_ID = "default";
    protected static final String TOKEN_PATH = "token";
    protected static final String STATE = "myState";
    protected static final String AUTHORIZE_PATH = "authorize";
    protected static final String USER_ID = "35";
    protected static final String INSTANCE_ID = "staging";
    protected static final String SCOPES = "this, that, those";
    protected static final String CONSUMER_KEY = "ndli93xdws2qoe6ms1d389vl6bxquv3e";
    protected static final String CONSUMER_SECRET = "yL692Az1cNhfk1VhTzyx4jOjjMKBrO9T";
    protected static final String ACCESS_TOKEN = "rbBQLgJXBEYo83K4Fqs4gu6vpCobc2ya";
    protected static final String REFRESH_TOKEN = "cry825cyCs2O0j7tRXXVS4AXNu7hsO5wbWjcBoFFcJePy5zZwuQEevIp6hsUaywp";
    protected static final String EXPIRES_IN = "3897";
    protected static final String STATE_PARAMETER = "state";
    protected static final String CODE_PARAMETER = "code";
    protected static final String CUSTOM_STORE_NAME = "customStore";
    protected static final String REDIRECT_URI = "redirect_uri";
    @Rule
    public SystemProperty consumerKey = new SystemProperty("consumerKey", "ndli93xdws2qoe6ms1d389vl6bxquv3e");
    @Rule
    public SystemProperty consumerSecret = new SystemProperty("consumerSecret", "yL692Az1cNhfk1VhTzyx4jOjjMKBrO9T");
    @Rule
    public SystemProperty localAuthPath = new SystemProperty("localAuthPath", "dance");
    @Rule
    public SystemProperty scope = new SystemProperty("scopes", "this, that, those");
    @Rule
    public DynamicPort callbackPort = new DynamicPort("callbackPort");
    @Rule
    public SystemProperty callbackPath = new SystemProperty("callbackPath", "callback");
    @Rule
    public DynamicPort oauthServerPort = new DynamicPort("oauthServerPort");
    @Rule
    public SystemProperty oauthProvider = new SystemProperty("callbackPath", "callback");
    @Rule
    public WireMockRule wireMock = new WireMockRule((Options)this.wireMockTestConfig(), false);
    @Rule
    public ExpectedException expectedException = ExpectedException.none();
    protected String authUrl = this.toUrl("authorize", this.oauthServerPort.getNumber());
    @Rule
    public SystemProperty authorizationUrl = new SystemProperty("authorizationUrl", this.authUrl);
    protected String tokenUrl = this.toUrl("token", this.oauthServerPort.getNumber());
    @Rule
    public SystemProperty accessTokenUrl = new SystemProperty("accessTokenUrl", this.tokenUrl);
    protected String ownerId;

    protected WireMockConfiguration wireMockTestConfig() {
        return WireMockConfiguration.wireMockConfig().bindAddress("127.0.0.1").port(this.oauthServerPort.getNumber());
    }

    protected String toUrl(String path, int port) {
        return this.toUrl(path, port, this.httpsTest());
    }

    protected boolean httpsTest() {
        return false;
    }

    protected String toUrl(String path, int port, boolean usesHttps) {
        return String.format("http%s://127.0.0.1:%d/%s", usesHttps ? "s" : "", port, path);
    }

    protected void assertOAuthStateStored(String objectStoreName, String expectedValue) throws Exception {
        Map entries = this.getObjectStore(objectStoreName).retrieveAll();
        Assert.assertThat((Object)entries.size(), (Matcher)CoreMatchers.is((Object)1));
        ResourceOwnerOAuthContext context = (ResourceOwnerOAuthContext)entries.values().toArray()[0];
        Assert.assertThat((Object)context.getResourceOwnerId(), (Matcher)CoreMatchers.is((Object)expectedValue));
    }

    protected ObjectStore getObjectStore(String objectStoreName) {
        ObjectStore objectStore = muleContext.getObjectStoreManager().getObjectStore(objectStoreName);
        Assert.assertThat((Object)objectStore, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        return objectStore;
    }

    protected void simulateDanceStart() throws IOException {
        this.simulateDanceStart(this.callbackPort.getNumber());
    }

    protected void simulateDanceStart(int port) throws IOException {
        this.wireMock.stubFor(WireMock.get((UrlPattern)WireMock.urlMatching((String)"/dance.*")).willReturn(WireMock.aResponse().withStatus(HttpConstants.HttpStatus.OK.getStatusCode())));
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (this.ownerId != null) {
            queryParams.put("resourceOwnerId", this.ownerId);
        }
        queryParams.put(STATE_PARAMETER, STATE);
        String localAuthUrl = this.toUrl(LOCAL_AUTH_PATH, port);
        Request.Get((String)(localAuthUrl + "?" + HttpEncoderDecoderUtils.encodeQueryString(queryParams))).addHeader("Connection", "close").connectTimeout(10000).socketTimeout(10000).execute();
    }

    protected void simulateCallback() {
        this.simulateCallback(this.callbackPort.getNumber());
    }

    protected void simulateCallback(String ownerId, String accessToken) {
        this.simulateCallback(this.callbackPort.getNumber(), ownerId, this.accessTokenContent(accessToken));
    }

    protected void simulateCallback(int port) {
        this.simulateCallback(port, this.ownerId, this.accessTokenContent());
    }

    protected void simulateCallback(int port, String ownerId, String accessTokenContent) {
        String authCode = "chu chu ua, chu chu ua";
        HashMap<String, String> queryParams = new HashMap<String, String>();
        if (ownerId != null) {
            queryParams.put(STATE_PARAMETER, String.format("%s:resourceOwnerId=%s", STATE, ownerId));
        }
        queryParams.put(CODE_PARAMETER, "chu chu ua, chu chu ua");
        this.stubTokenUrl(accessTokenContent);
        PollingProber.check((long)10000L, (long)500L, () -> {
            Response response = Request.Get((String)(this.toUrl(CALLBACK_PATH, port, false) + "?" + HttpEncoderDecoderUtils.encodeQueryString((Map)queryParams))).addHeader("Connection", "close").connectTimeout(10000).socketTimeout(10000).execute();
            Assert.assertThat((Object)response.returnResponse().getStatusLine().getStatusCode(), (Matcher)CoreMatchers.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
            return true;
        });
    }

    protected void stubTokenUrl(String responseContent) {
        this.wireMock.stubFor(WireMock.post((UrlPattern)WireMock.urlMatching((String)"/token")).willReturn(this.buildResponseContent(responseContent)));
    }

    protected ResponseDefinitionBuilder buildResponseContent(String responseContent) {
        return WireMock.aResponse().withStatus(HttpConstants.HttpStatus.OK.getStatusCode()).withBody(responseContent).withHeader("Content-Type", new String[]{"application/json"});
    }

    protected String accessTokenContent() {
        return this.accessTokenContent(ACCESS_TOKEN);
    }

    protected String accessTokenContent(String accessToken) {
        return "{\"access_token\":\"" + accessToken + "\",\"expires_in\":3897,\"refresh_token\":\"cry825cyCs2O0j7tRXXVS4AXNu7hsO5wbWjcBoFFcJePy5zZwuQEevIp6hsUaywp\",\"id\":\"35\",\"instance_url\":\"staging\"}";
    }

    protected void verifyAuthUrlRequest() {
        this.verifyAuthUrlRequest(this.callbackPort.getNumber());
    }

    protected void verifyAuthUrlRequest(int port) {
        this.verifyAuthUrlRequest(port, SCOPES);
    }

    protected void verifyAuthUrlRequest(int port, String scopes) {
        if (scopes != null) {
            this.wireMock.verify(WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/authorize")).withQueryParam(REDIRECT_URI, WireMock.equalTo((String)this.toUrl(CALLBACK_PATH, port))).withQueryParam("client_id", WireMock.equalTo((String)CONSUMER_KEY)).withQueryParam(STATE_PARAMETER, WireMock.containing((String)STATE)).withQueryParam("scope", WireMock.equalTo((String)scopes)));
        } else {
            this.wireMock.verify(WireMock.getRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/authorize")).withQueryParam(REDIRECT_URI, WireMock.equalTo((String)this.toUrl(CALLBACK_PATH, port))).withQueryParam("client_id", WireMock.equalTo((String)CONSUMER_KEY)).withQueryParam(STATE_PARAMETER, WireMock.containing((String)STATE)));
        }
    }

    protected void assertConnectionState(TestOAuthConnectionState connection) {
        this.assertConnectionProperties(connection);
        this.assertAuthCodeState(connection);
    }

    protected String getRefreshTokenResponse() {
        return this.accessTokenContent("rbBQLgJXBEYo83K4Fqs4gu6vpCobc2ya-refreshed");
    }

    protected void assertAuthCodeState(TestOAuthConnectionState connection) {
        AuthorizationCodeState state = (AuthorizationCodeState)connection.getState();
        Assert.assertThat((Object)state.getAccessToken(), (Matcher)CoreMatchers.is((Object)ACCESS_TOKEN));
        Assert.assertThat((Object)((String)state.getExpiresIn().get()), (Matcher)CoreMatchers.is((Object)EXPIRES_IN));
        Assert.assertThat((Object)((String)state.getRefreshToken().get()), (Matcher)CoreMatchers.is((Object)REFRESH_TOKEN));
        Assert.assertThat((Object)((String)state.getState().get()), (Matcher)CoreMatchers.is((Object)STATE));
        Assert.assertThat((Object)state.getResourceOwnerId(), (Matcher)CoreMatchers.is((Object)this.ownerId));
    }

    protected void assertConnectionProperties(TestOAuthConnectionState connection) {
        Assert.assertThat((Object)connection, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()));
        Assert.assertThat((Object)connection.getApiVersion(), (Matcher)CoreMatchers.is((Object)34.0));
        Assert.assertThat((Object)connection.getDisplay(), (Matcher)CoreMatchers.is((Object)"PAGE"));
        Assert.assertThat((Object)connection.isPrompt(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)connection.isImmediate(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)connection.getInstanceId(), (Matcher)CoreMatchers.is((Object)INSTANCE_ID));
        Assert.assertThat((Object)connection.getUserId(), (Matcher)CoreMatchers.is((Object)USER_ID));
    }

    protected void stubRefreshedTokenAlreadyExpired() {
        this.wireMock.resetAll();
        this.wireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlMatching((String)"/token")).inScenario("refreshTokenWasAlreadyExpired").whenScenarioStateIs("Started").willReturn(this.buildResponseContent(this.accessTokenContent(ACCESS_TOKEN))).willSetStateTo("refresh"));
        this.wireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlMatching((String)"/token")).inScenario("refreshTokenWasAlreadyExpired").whenScenarioStateIs("refresh").willReturn(this.buildResponseContent(this.getRefreshTokenResponse())));
    }

    protected void stubRefreshedTokenAlreadyExpiredOnce() {
        this.wireMock.resetAll();
        this.wireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlMatching((String)"/token")).inScenario("refreshTokenWasAlreadyExpiredTwice").whenScenarioStateIs("Started").willReturn(this.buildResponseContent(this.accessTokenContent(ACCESS_TOKEN))).willSetStateTo("refresh"));
        this.wireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlMatching((String)"/token")).inScenario("refreshTokenWasAlreadyExpiredTwice").whenScenarioStateIs("refresh").willReturn(this.buildResponseContent(this.getRefreshTokenResponse())));
    }

    protected void stubRefreshedTokenAlreadyExpiredTwice() {
        this.wireMock.resetAll();
        this.wireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlMatching((String)"/token")).inScenario("refreshTokenWasAlreadyExpiredTwice").whenScenarioStateIs("Started").willReturn(this.buildResponseContent(this.accessTokenContent(ACCESS_TOKEN))).willSetStateTo("2"));
        this.wireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlMatching((String)"/token")).inScenario("refreshTokenWasAlreadyExpiredTwice").whenScenarioStateIs("2").willReturn(this.buildResponseContent(this.accessTokenContent(ACCESS_TOKEN))).willSetStateTo("refresh"));
        this.wireMock.stubFor((MappingBuilder)WireMock.post((UrlPattern)WireMock.urlMatching((String)"/token")).inScenario("refreshTokenWasAlreadyExpiredTwice").whenScenarioStateIs("refresh").willReturn(this.buildResponseContent(this.getRefreshTokenResponse())));
    }

    protected void stubRefreshToken() {
        this.stubTokenUrl(this.accessTokenContent("rbBQLgJXBEYo83K4Fqs4gu6vpCobc2ya-refreshed"));
    }

    protected void stubRefreshToken(String refreshedToken) {
        this.stubTokenUrl(this.accessTokenContent(refreshedToken));
    }

    protected String getCustomOwnerId() {
        return "MG";
    }

    protected void verifyTokenRefreshedTwice() {
        this.wireMock.verify(2, WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/token")));
    }

    protected void expectExpiredTokenException() {
        this.expectedException.expectMessage(this.getExpirationMessageSubstring());
    }

    protected String getExpirationMessageSubstring() {
        return "Access Token expired for resource owner id";
    }

    protected String toBasicAuthorizationHeader(String clientId, String clientSecret) {
        return "Basic " + Base64.encodeBase64String((byte[])String.format("%s:%s", clientId, clientSecret).getBytes());
    }
}

