/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.oauth.authcode;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import io.qameta.allure.Description;
import io.qameta.allure.Issue;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Test;
import org.mule.functional.api.flow.FlowRunner;
import org.mule.test.module.extension.oauth.BaseOAuthExtensionTestCase;
import org.mule.test.oauth.TestOAuthConnection;
import org.mule.test.oauth.TestOAuthConnectionState;

public class MultipleOwnersTestCase
extends BaseOAuthExtensionTestCase {
    protected String[] getConfigFiles() {
        return new String[]{"auth-code-oauth-extension-config.xml", "oauth-extension-flows.xml"};
    }

    @Test
    @Issue(value="MULE-20019")
    @Description(value="Tests that only the credentials of the corresponding resource owner are updated during authorization, token refresh and token invalidation")
    public void multipleResourceOwners() throws Exception {
        ResourceOwnerData firstOwner = new ResourceOwnerData("firstOwnerId", "1stOwnerAccessToken");
        ResourceOwnerData secondOwner = new ResourceOwnerData("secondOwnerId", "2ndOwnerAccessToken");
        this.simulateCallback(firstOwner.id, firstOwner.accessToken);
        TestOAuthConnectionState firstOwnerConnection = this.getConnection(firstOwner.id);
        Assert.assertThat((Object)firstOwnerConnection.getState().getAccessToken(), (Matcher)CoreMatchers.is((Object)firstOwner.accessToken));
        this.simulateCallback(secondOwner.id, secondOwner.accessToken);
        TestOAuthConnectionState secondOwnerConnection = this.getConnection(secondOwner.id);
        Assert.assertThat((Object)firstOwnerConnection.getState().getAccessToken(), (Matcher)CoreMatchers.is((Object)firstOwner.accessToken));
        Assert.assertThat((Object)secondOwnerConnection.getState().getAccessToken(), (Matcher)CoreMatchers.is((Object)secondOwner.accessToken));
        WireMock.reset();
        this.stubRefreshToken(firstOwner.refreshToken);
        ((FlowRunner)this.flowRunner("refreshToken").withVariable("ownerId", (Object)firstOwner.id)).run();
        this.wireMock.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/token")));
        Assert.assertThat((Object)firstOwnerConnection.getState().getAccessToken(), (Matcher)CoreMatchers.is((Object)firstOwner.refreshToken));
        Assert.assertThat((Object)secondOwnerConnection.getState().getAccessToken(), (Matcher)CoreMatchers.is((Object)secondOwner.accessToken));
        ((FlowRunner)this.flowRunner("unauthorize").withVariable("ownerId", (Object)firstOwner.id)).run();
        try {
            firstOwnerConnection.getState().getAccessToken();
            Assert.fail((String)"Expected access token to be invalidated");
        }
        catch (Exception e) {
            Assert.assertThat((Object)e.getClass().getName(), (Matcher)Matchers.containsString((String)"TokenInvalidatedException"));
        }
        Assert.assertThat((Object)secondOwnerConnection.getState().getAccessToken(), (Matcher)CoreMatchers.is((Object)secondOwner.accessToken));
    }

    private TestOAuthConnectionState getConnection(String resourceOwnerId) throws Exception {
        return ((TestOAuthConnection)((FlowRunner)this.flowRunner("getConnection").withVariable("ownerId", (Object)resourceOwnerId)).run().getMessage().getPayload().getValue()).getState();
    }

    private static class ResourceOwnerData {
        public String id;
        public String accessToken;
        public String refreshToken;

        ResourceOwnerData(String id, String accessToken) {
            this.id = id;
            this.accessToken = accessToken;
            this.refreshToken = accessToken + "-refreshed";
        }
    }
}

