/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.module.extension.oauth.clientcredentials;

import com.github.tomakehurst.wiremock.client.WireMock;
import com.github.tomakehurst.wiremock.matching.ContentPattern;
import com.github.tomakehurst.wiremock.matching.UrlPattern;
import io.qameta.allure.Issue;
import java.util.Map;
import javax.inject.Inject;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;
import org.mule.oauth.client.api.state.ResourceOwnerOAuthContext;
import org.mule.runtime.api.store.ObjectStore;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.connectivity.oauth.ClientCredentialsState;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.test.module.extension.oauth.BaseOAuthExtensionTestCase;
import org.mule.test.oauth.TestOAuthConnection;
import org.mule.test.oauth.TestOAuthConnectionState;

public class OAuthClientCredentialsExtensionTestCase
extends BaseOAuthExtensionTestCase {
    private LazyValue<ObjectStore> objectStore = new LazyValue(() -> muleContext.getObjectStoreManager().getObjectStore("customStore"));
    @Inject
    private ExtensionsClient extensionsClient;

    protected String[] getConfigFiles() {
        return new String[]{"client-credentials-oauth-extension-config.xml", "client-credentials-flows.xml"};
    }

    protected void doSetUp() throws Exception {
        super.doSetUp();
        ((ObjectStore)this.objectStore.get()).clear();
        this.wireMock.stubFor(WireMock.post((UrlPattern)WireMock.urlPathMatching((String)"/token")).willReturn(WireMock.aResponse().withStatus(HttpConstants.HttpStatus.OK.getStatusCode()).withBody(this.accessTokenContent()).withHeader("Content-Type", new String[]{"application/json"})));
    }

    @Test
    public void authenticate() throws Exception {
        TestOAuthConnectionState connection = ((TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue()).getState();
        this.assertConnectionState(connection);
        this.assertOAuthStateStored("customStore", "default");
    }

    @Test
    public void refreshToken() throws Exception {
        this.authenticate();
        WireMock.reset();
        String refreshedToken = this.configureRefreshResponse();
        this.flowRunner("refreshToken").run();
        this.assertRefreshToken(refreshedToken);
    }

    @Test
    @Issue(value="W-19248279")
    public void refreshTokenThroughExtensionClient() throws Exception {
        this.authenticate();
        WireMock.reset();
        String refreshedToken = this.configureRefreshResponse();
        this.extensionsClient.execute("Test OAuth Extension", "tokenExpired", params -> params.withConfigRef("oauth")).get();
        this.assertRefreshToken(refreshedToken);
    }

    @Test
    public void refreshTokenAsync() throws Exception {
        this.authenticate();
        WireMock.reset();
        String refreshedToken = this.configureRefreshResponse();
        this.flowRunner("refreshTokenAsync").run();
        this.assertRefreshToken(refreshedToken);
    }

    private void assertRefreshToken(String refreshedToken) throws Exception {
        this.wireMock.verify(WireMock.postRequestedFor((UrlPattern)WireMock.urlPathEqualTo((String)"/token")));
        Map entries = ((ObjectStore)this.objectStore.get()).retrieveAll();
        Assert.assertThat((Object)entries.size(), (Matcher)CoreMatchers.is((Object)1));
        ResourceOwnerOAuthContext context = (ResourceOwnerOAuthContext)entries.values().toArray()[0];
        Assert.assertThat((Object)context.getAccessToken(), (Matcher)CoreMatchers.equalTo((Object)refreshedToken));
    }

    private String configureRefreshResponse() {
        String refreshedToken = "rbBQLgJXBEYo83K4Fqs4gu6vpCobc2ya-refreshed";
        this.wireMock.stubFor(WireMock.post((UrlPattern)WireMock.urlPathMatching((String)"/token")).willReturn(WireMock.aResponse().withStatus(HttpConstants.HttpStatus.OK.getStatusCode()).withBody(this.accessTokenContent(refreshedToken)).withHeader("Content-Type", new String[]{"application/json"})));
        return refreshedToken;
    }

    @Test
    public void unauthorize() throws Exception {
        this.authenticate();
        this.flowRunner("unauthorize").run();
        ObjectStore objectStore = this.getObjectStore("customStore");
        Assert.assertThat((Object)objectStore.retrieveAll().size(), (Matcher)CoreMatchers.is((Object)0));
        String refreshedToken = this.configureRefreshResponse();
        TestOAuthConnectionState connection = ((TestOAuthConnection)this.flowRunner("getConnection").run().getMessage().getPayload().getValue()).getState();
        Assert.assertThat((Object)connection.getState().getAccessToken(), (Matcher)CoreMatchers.equalTo((Object)refreshedToken));
        this.assertRefreshToken(refreshedToken);
    }

    @Override
    protected void assertAuthCodeState(TestOAuthConnectionState connection) {
        ClientCredentialsState state = (ClientCredentialsState)connection.getState();
        Assert.assertThat((Object)state.getAccessToken(), (Matcher)CoreMatchers.is((Object)"rbBQLgJXBEYo83K4Fqs4gu6vpCobc2ya"));
        Assert.assertThat((Object)((String)state.getExpiresIn().get()), (Matcher)CoreMatchers.is((Object)"3897"));
    }

    @Test
    public void authenticateWithCustomParameters() throws Exception {
        WireMock.reset();
        this.wireMock.stubFor(WireMock.post((UrlPattern)WireMock.urlPathMatching((String)"/token")).withHeader("foo", WireMock.equalTo((String)"bar")).withHeader("foo", WireMock.equalTo((String)"manchu")).withQueryParam("immediate", WireMock.equalTo((String)"true")).withQueryParam("prompt", WireMock.equalTo((String)"false")).withHeader("knownCustomHeader", WireMock.equalTo((String)"myHeader")).withRequestBody((ContentPattern)WireMock.containing((String)"bodyParameter=body")).willReturn(WireMock.aResponse().withStatus(HttpConstants.HttpStatus.OK.getStatusCode()).withBody(this.accessTokenContent()).withHeader("Content-Type", new String[]{"application/json"})));
        TestOAuthConnectionState connection = ((TestOAuthConnection)this.flowRunner("getConnectionWithCustomParameters").run().getMessage().getPayload().getValue()).getState();
        this.assertConnectionState(connection);
        this.assertOAuthStateStored("customStore", "default");
    }
}

