/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.petstore.extension;

import java.util.List;
import java.util.concurrent.CountDownLatch;
import org.mule.runtime.core.api.Event;
import org.mule.runtime.core.util.concurrent.Latch;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.UseConfig;
import org.mule.test.petstore.extension.ExclusiveCashier;
import org.mule.test.petstore.extension.ExclusivePetBreeder;
import org.mule.test.petstore.extension.Pet;
import org.mule.test.petstore.extension.PetCage;
import org.mule.test.petstore.extension.PetStoreClient;
import org.mule.test.petstore.extension.PetStoreConnector;

public class PetStoreOperations {
    public List<String> getPets(@Connection PetStoreClient client, @UseConfig PetStoreConnector config, String ownerName) {
        return client.getPets(ownerName, config);
    }

    public PetStoreClient getClient(@Connection PetStoreClient client) {
        return client;
    }

    public ExclusivePetBreeder getBreeder(@ParameterGroup(value="Exclusive") ExclusivePetBreeder breeder) {
        return breeder;
    }

    public ExclusiveCashier getCashier(@ParameterGroup(value="Exclusive") ExclusiveCashier cashier) {
        return cashier;
    }

    public List<Pet> getForbiddenPets(List<Pet> forbiddenPets) {
        return forbiddenPets;
    }

    public PetStoreClient getClientOnLatch(@Connection PetStoreClient client, Event event) throws Exception {
        CountDownLatch countDownLatch = (CountDownLatch)event.getVariable("testLatch").getValue();
        if (countDownLatch != null) {
            countDownLatch.countDown();
        }
        Latch latch = (Latch)event.getVariable("connectionLatch").getValue();
        latch.await();
        return client;
    }

    public PetCage getCage(@UseConfig PetStoreConnector config) {
        return config.getCage();
    }
}

