/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.petstore.extension;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.api.security.SecurityProviderNotFoundException;
import org.mule.runtime.api.security.UnknownAuthenticationTypeException;
import org.mule.runtime.api.streaming.exception.StreamingBufferSizeExceededException;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;
import org.mule.runtime.extension.api.security.AuthenticationHandler;
import org.mule.test.petstore.extension.Aquarium;
import org.mule.test.petstore.extension.ExclusiveCashier;
import org.mule.test.petstore.extension.ExclusivePetBreeder;
import org.mule.test.petstore.extension.Pet;
import org.mule.test.petstore.extension.PetCage;
import org.mule.test.petstore.extension.PetStoreClient;
import org.mule.test.petstore.extension.PetStoreConnector;
import org.mule.test.petstore.extension.PetStoreCustomErrorProvider;
import org.mule.test.petstore.extension.PetStoreDeal;
import org.mule.test.petstore.extension.PetstoreErrorTypeDefinition;
import org.mule.test.petstore.extension.PhoneNumber;

public class PetStoreOperations {
    public static boolean shouldFailWithConnectionException;
    public static AtomicInteger operationExecutionCounter;

    public List<String> getPets(@Connection PetStoreClient client, @Config PetStoreConnector config, String ownerName, @Optional InputStream ownerSignature) {
        if (ownerSignature != null) {
            ownerName = ownerName + IOUtils.toString((InputStream)ownerSignature);
        }
        return client.getPets(ownerName, config);
    }

    @MediaType(value="text/plain")
    public InputStream getStreamedSignature(String signature) {
        return new ByteArrayInputStream(signature.getBytes());
    }

    public List<String> getPetsWithIntermitentConnectionProblemAndClosingStream(@Connection PetStoreClient client, @Config PetStoreConnector config, String ownerName, @Optional InputStream ownerSignature) throws IOException {
        operationExecutionCounter.incrementAndGet();
        if (ownerSignature != null) {
            ownerName = ownerName + IOUtils.toString((InputStream)ownerSignature);
        }
        boolean bl = shouldFailWithConnectionException = !shouldFailWithConnectionException;
        if (!shouldFailWithConnectionException) {
            ownerSignature.close();
            throw new RuntimeException((Throwable)new ConnectionException("kaboom"));
        }
        return client.getPets(ownerName, config);
    }

    @Throws(value={PetStoreCustomErrorProvider.class})
    @MediaType(value="text/plain")
    public String failsToReadStream(@Connection PetStoreClient connection, @Optional String content) throws MuleException {
        try {
            if (content == null) {
                throw new Exception("Null content cannot be processed");
            }
            throw new StreamingBufferSizeExceededException(1);
        }
        catch (Exception e) {
            throw new ModuleException((ErrorTypeDefinition)PetstoreErrorTypeDefinition.PET_ERROR, (Throwable)e);
        }
    }

    public PetStoreClient getClient(@Connection PetStoreClient client) {
        return client;
    }

    @MediaType(value="text/plain")
    public String getFishFromRiverStream(@Content InputStream river, @Optional InputStream pollutedStream) {
        StringBuilder builder = new StringBuilder();
        builder.append(IOUtils.toString((InputStream)river));
        if (pollutedStream != null) {
            builder.append(" ");
            builder.append(IOUtils.toString((InputStream)pollutedStream));
        }
        return builder.toString();
    }

    @MediaType(value="text/plain")
    public String describeSerializedAnimal(@ParameterDsl(allowReferences=false) Serializable animal) {
        if (animal instanceof byte[]) {
            return new String((byte[])animal);
        }
        return animal.toString();
    }

    @OutputResolver(output=CorrelationInfoOutputResolver.class)
    public CorrelationInfo getPetCorrelation(CorrelationInfo correlationInfo) {
        return correlationInfo;
    }

    public ExclusivePetBreeder getBreeder(@ParameterGroup(name="Exclusive") ExclusivePetBreeder breeder) {
        return breeder;
    }

    public ExclusiveCashier getCashier(@ParameterGroup(name="Exclusive") ExclusiveCashier cashier) {
        return cashier;
    }

    public Aquarium getAquarium(Aquarium aquarium) {
        return aquarium;
    }

    public PetStoreDeal getPetStoreDeal(PetStoreDeal petStoreDeal) {
        return petStoreDeal;
    }

    @MediaType(value="text/plain")
    public String getDefaultEncoding(boolean usePhoneNumber, @Optional PhoneNumber phoneNumber, @DefaultEncoding String encoding) {
        return usePhoneNumber ? phoneNumber.getCountryEncoding() : encoding;
    }

    public List<Pet> getForbiddenPets(List<Pet> forbiddenPets) {
        return forbiddenPets;
    }

    public PetStoreClient getClientOnLatch(@Connection PetStoreClient client, Object countDownLatch, Object latch) throws Exception {
        if (countDownLatch != null) {
            ((CountDownLatch)countDownLatch).countDown();
        }
        ((Latch)latch).await();
        return client;
    }

    public PetCage getCage(@Config PetStoreConnector config) {
        return config.getCage();
    }

    public PetStoreConnector getConfig(@Config PetStoreConnector config) {
        return config;
    }

    public void setSecureCage(@Optional @NullSafe List<String> providers, String user, String pass, AuthenticationHandler authHandler) throws SecurityException, SecurityProviderNotFoundException, UnknownAuthenticationTypeException {
        authHandler.setAuthentication(providers, authHandler.createAuthentication(authHandler.createCredentialsBuilder().withUsername(user).withPassword(pass.toCharArray()).build()));
    }

    public void makePhoneCall(PhoneNumber phoneNumber) {
    }

    @MediaType(value="*/*")
    public Character spellObject(Character character) {
        return character;
    }

    @MediaType(value="*/*")
    public char spellBuiltIn(char character) {
        return character;
    }

    @MediaType(value="*/*")
    public Class spellClass(Class clazz) {
        return clazz;
    }

    static {
        operationExecutionCounter = new AtomicInteger(0);
    }

    public static class CorrelationInfoOutputResolver
    implements OutputTypeResolver<CorrelationInfo> {
        public MetadataType getOutputType(MetadataContext context, CorrelationInfo key) {
            return context.getTypeLoader().load(CorrelationInfo.class);
        }

        public String getCategoryName() {
            return "correlationInfo";
        }
    }
}

