/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.petstore.extension;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.annotation.OnException;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.error.MuleErrors;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.exception.ExceptionHandler;
import org.mule.runtime.extension.api.runtime.streaming.PagingProvider;
import org.mule.test.petstore.extension.PetStoreClient;
import org.mule.test.petstore.extension.PetStoreCustomErrorProvider;
import org.mule.test.petstore.extension.PetStoreOperations;
import org.mule.test.petstore.extension.PetstoreErrorTypeDefinition;
import org.mule.test.petstore.extension.error.ErrorAction;

public class PetStoreOperationsWithFailures
extends PetStoreOperations {
    public static final String CONNECTION_FAIL = "Connection fail";
    private static List<Thread> connectionThreads = new ArrayList<Thread>();

    public static List<Thread> getConnectionThreads() {
        return Collections.unmodifiableList(connectionThreads);
    }

    public static void resetConnectionThreads() {
        connectionThreads.clear();
    }

    public Integer failConnection(@Connection PetStoreClient client) throws ConnectionException {
        connectionThreads.add(Thread.currentThread());
        throw new ConnectionException(CONNECTION_FAIL);
    }

    public Integer failOperationWithException(@Connection PetStoreClient client) throws Exception {
        connectionThreads.add(Thread.currentThread());
        throw new Exception(CONNECTION_FAIL);
    }

    public Integer failOperationWithThrowable(@Connection PetStoreClient client) throws Throwable {
        connectionThreads.add(Thread.currentThread());
        throw new Throwable(CONNECTION_FAIL);
    }

    @Throws(value={PetStoreCustomErrorProvider.class})
    public PagingProvider<PetStoreClient, Integer> failPagedOperation(final int failOnPage, @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="false") boolean stickyConnections, final @org.mule.runtime.extension.api.annotation.param.Optional(defaultValue="true") boolean throwConnectivity) {
        return new AbstractPetStorePagingProvider(stickyConnections){
            private int index;
            private List<Integer> returnValue;
            {
                super(useStickyConnections);
                this.index = 0;
                this.returnValue = Collections.singletonList(1);
            }

            public List<Integer> getPage(PetStoreClient petStoreClient) {
                if (this.index == failOnPage) {
                    connectionThreads.add(Thread.currentThread());
                    if (throwConnectivity) {
                        throw new ModuleException((ErrorTypeDefinition)MuleErrors.CONNECTIVITY, (Throwable)new ConnectionException(PetStoreOperationsWithFailures.CONNECTION_FAIL));
                    }
                    throw new ModuleException((ErrorTypeDefinition)PetstoreErrorTypeDefinition.PET_ERROR, (Throwable)new RuntimeException("Some Error"));
                }
                ++this.index;
                return this.returnValue;
            }
        };
    }

    @Throws(value={PetStoreCustomErrorProvider.class})
    @OnException(value=PetStoreErrorHandler.class)
    public PagingProvider<PetStoreClient, Integer> failPagedOperationWithErrorHandler(final ErrorAction errorAction) {
        return new AbstractPetStorePagingProvider(false){

            public List<Integer> getPage(PetStoreClient petStoreClient) {
                throw new PetStoreException(errorAction);
            }
        };
    }

    private static class PetStoreException
    extends RuntimeException {
        private ErrorAction errorAction;

        private PetStoreException(ErrorAction errorAction) {
            this.errorAction = errorAction;
        }

        public Exception getException() {
            switch (this.errorAction) {
                case CONNECTIVITY: {
                    return new ConnectionException((Throwable)this);
                }
                case RUNTIME: {
                    return new RuntimeException(this);
                }
            }
            return new ModuleException((ErrorTypeDefinition)PetstoreErrorTypeDefinition.PET_ERROR, (Throwable)this);
        }
    }

    public static class PetStoreErrorHandler
    extends ExceptionHandler {
        public Exception enrichException(Exception e) {
            if (e instanceof PetStoreException) {
                return ((PetStoreException)e).getException();
            }
            return e;
        }
    }

    private abstract class AbstractPetStorePagingProvider
    implements PagingProvider<PetStoreClient, Integer> {
        private boolean useStickyConnections;

        public AbstractPetStorePagingProvider(boolean useStickyConnections) {
            this.useStickyConnections = useStickyConnections;
        }

        public Optional<Integer> getTotalResults(PetStoreClient petStoreClient) {
            return Optional.empty();
        }

        public void close(PetStoreClient petStoreClient) throws MuleException {
        }

        public boolean useStickyConnections() {
            return this.useStickyConnections;
        }
    }
}

