/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.petstore.extension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import javax.inject.Inject;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.extension.api.annotation.Expression;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.execution.OnTerminate;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.mule.runtime.extension.api.runtime.source.SourceCallbackContext;
import org.mule.test.petstore.extension.PetAdoptionPolling;
import org.mule.test.petstore.extension.PollingSourceMetadataResolver;

@MetadataScope(outputResolver=PollingSourceMetadataResolver.class)
@MediaType(value="text/plain")
public class PetAdoptionSchedulerInParamSource
extends Source<String, Void> {
    public static final List<String> ALL_PETS = Arrays.asList("Grumpy Cat", "Colonel Meow", "Silvester", "Lil bub", "Macri", "Pappo");
    public static int ADOPTED_PET_COUNT;
    public static int FAILED_ADOPTION_COUNT;
    public static int COMPLETED_POLLS;
    public static int REJECTED_ADOPTIONS;
    public static int STARTED_POLLS;
    protected List<String> pets;
    @Parameter
    @Expression(value=ExpressionSupport.NOT_SUPPORTED)
    @Optional
    private PetAdoptionPolling polling;
    @Inject
    private SchedulerService schedulerService;
    private Scheduler executor;
    private ScheduledFuture<?> scheduled;

    public void onStart(SourceCallback<String, Void> sourceCallback) throws MuleException {
        this.pets = new ArrayList<String>(ALL_PETS);
        this.resetCounters();
        this.executor = this.polling.createExecutor("adoption", this.schedulerService);
        this.scheduled = this.polling.getSchedulingStrategy().schedule(this.executor, () -> this.poll(sourceCallback));
    }

    public void onStop() {
        this.scheduled.cancel(false);
        this.executor.stop();
        this.pets.clear();
        this.resetCounters();
    }

    @OnSuccess
    public synchronized void onSuccess() {
        ++ADOPTED_PET_COUNT;
    }

    @OnError
    public synchronized void onError() {
        ++FAILED_ADOPTION_COUNT;
    }

    @OnTerminate
    public synchronized void onTerminate() {
        ++COMPLETED_POLLS;
    }

    public void poll(SourceCallback<String, Void> sourceCallback) {
        ++STARTED_POLLS;
        this.pets.stream().map(p -> Result.builder().output(p).build()).forEach(arg_0 -> sourceCallback.handle(arg_0));
    }

    public void onRejectedItem(Result<String, Void> result, SourceCallbackContext context) {
        ++REJECTED_ADOPTIONS;
    }

    private synchronized void resetCounters() {
        STARTED_POLLS = 0;
        REJECTED_ADOPTIONS = 0;
        COMPLETED_POLLS = 0;
        FAILED_ADOPTION_COUNT = 0;
        ADOPTED_PET_COUNT = 0;
    }
}

