/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.petstore.extension;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Named;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.config.Feature;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.metadata.MetadataContext;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.api.security.SecurityProviderNotFoundException;
import org.mule.runtime.api.security.UnknownAuthenticationTypeException;
import org.mule.runtime.api.streaming.exception.StreamingBufferSizeExceededException;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.core.api.config.FeatureFlaggingRegistry;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.annotation.dsl.xml.ParameterDsl;
import org.mule.runtime.extension.api.annotation.error.Throws;
import org.mule.runtime.extension.api.annotation.metadata.OutputResolver;
import org.mule.runtime.extension.api.annotation.param.Config;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.Content;
import org.mule.runtime.extension.api.annotation.param.DefaultEncoding;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.NullSafe;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.ParameterGroup;
import org.mule.runtime.extension.api.annotation.param.stereotype.AllowedStereotypes;
import org.mule.runtime.extension.api.error.ErrorTypeDefinition;
import org.mule.runtime.extension.api.exception.ModuleException;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.parameter.CorrelationInfo;
import org.mule.runtime.extension.api.runtime.process.CompletionCallback;
import org.mule.runtime.extension.api.runtime.route.Chain;
import org.mule.runtime.extension.api.security.AuthenticationHandler;
import org.mule.runtime.extension.api.stereotype.ValidatorStereotype;
import org.mule.sdk.api.annotation.param.RuntimeVersion;
import org.mule.test.petstore.extension.Aquarium;
import org.mule.test.petstore.extension.ExclusiveCashier;
import org.mule.test.petstore.extension.ExclusivePetBreeder;
import org.mule.test.petstore.extension.Pet;
import org.mule.test.petstore.extension.PetCage;
import org.mule.test.petstore.extension.PetOwner;
import org.mule.test.petstore.extension.PetStoreClient;
import org.mule.test.petstore.extension.PetStoreConnector;
import org.mule.test.petstore.extension.PetStoreCustomErrorProvider;
import org.mule.test.petstore.extension.PetStoreDeal;
import org.mule.test.petstore.extension.PetStoreFeatures;
import org.mule.test.petstore.extension.PetstoreErrorTypeDefinition;
import org.mule.test.petstore.extension.PhoneNumber;

public class PetStoreOperations {
    public static boolean shouldFailWithConnectionException;
    public static AtomicInteger operationExecutionCounter;
    @RuntimeVersion
    MuleVersion muleVersion;
    @Inject
    @Named(value="core.featureFlaggingService")
    private FeatureFlaggingService ffService;

    public Long getConnectionAge(@Connection PetStoreClient client, @Config PetStoreConnector config) {
        return System.currentTimeMillis() - client.getTimeOfCreation();
    }

    @MediaType(value="*/*")
    public void scopeWithMuleStereotype(@AllowedStereotypes(value={ValidatorStereotype.class}) Chain validators, CompletionCallback<String, String> completionCallback) {
        completionCallback.success(Result.builder().output((Object)"Ok").attributes((Object)"Attributes").build());
    }

    @MediaType(value="text/plain")
    public String echoWithSignature(String message) {
        return message + " echoed by Petstore";
    }

    @MediaType(value="text/plain")
    public String featureFlaggedEchoMuleContext(String message) {
        if (this.ffService.isEnabled((Feature)PetStoreFeatures.LEGACY_FEATURE_ONE)) {
            return String.format("%s [old way]", message);
        }
        return message;
    }

    @MediaType(value="text/plain")
    public String featureFlaggedEchoFeatureContext(String message) {
        if (this.ffService.isEnabled((Feature)PetStoreFeatures.LEGACY_FEATURE_TWO)) {
            return String.format("%s [old way]", message);
        }
        return message;
    }

    @MediaType(value="text/plain")
    public Boolean isSplitterExceptionHandled() {
        return this.ffService.isEnabled((Feature)MuleRuntimeFeature.HANDLE_SPLITTER_EXCEPTION);
    }

    public List<String> getPets(@Connection PetStoreClient client, @Config PetStoreConnector config, String ownerName, @Optional InputStream ownerSignature) {
        if (ownerSignature != null) {
            ownerName = ownerName + IOUtils.toString((InputStream)ownerSignature);
        }
        return client.getPets(ownerName, config);
    }

    public List<String> getPetsWithParameterGroup(@Connection PetStoreClient client, @Config PetStoreConnector config, @ParameterGroup(name="Owner") PetOwner owner) {
        return this.getPets(client, config, owner.getName(), owner.getSignature());
    }

    public List<String> getPetsWithParameterGroupShowDsl(@Connection PetStoreClient client, @Config PetStoreConnector config, @ParameterGroup(name="Owner", showInDsl=true) PetOwner owner) {
        if (owner.getAddress() != null) {
            IOUtils.toString((InputStream)((InputStream)owner.getAddress().getValue()));
        }
        if (owner.getOwnershipCertificate() != null) {
            IOUtils.toString((InputStream)owner.getOwnershipCertificate());
        }
        return this.getPets(client, config, owner.getName(), owner.getSignature());
    }

    public List<String> getPetsWithTypedInputStreamParameter(@Connection PetStoreClient client, @Config PetStoreConnector config, String owner, TypedValue<InputStream> signature) {
        return this.getPets(client, config, owner, (InputStream)signature.getValue());
    }

    @MediaType(value="text/plain")
    public InputStream getStreamedSignature(String signature) {
        return new ByteArrayInputStream(signature.getBytes());
    }

    @MediaType(value="text/plain")
    public InputStream getStreamedSignatureWithError(@Connection PetStoreClient petStoreClient, String signature) {
        throw new IllegalStateException("The operation failed!");
    }

    public List<String> getPetsWithIntermitentConnectionProblemAndClosingStreamInParameterGroup(@Connection PetStoreClient client, @Config PetStoreConnector config, @ParameterGroup(name="Owner") PetOwner owner) throws IOException {
        return this.getPetsWithIntermitentConnectionProblemAndClosingStream(client, config, owner.getName(), owner.getSignature());
    }

    public List<String> getPetsWithIntermitentConnectionProblemAndClosingStreamInParameterGroupShownInDsl(@Connection PetStoreClient client, @Config PetStoreConnector config, @ParameterGroup(name="Owner", showInDsl=true) PetOwner owner) throws IOException {
        return this.getPetsWithIntermitentConnectionProblemAndClosingStream(client, config, owner.getName(), owner.getSignature());
    }

    public List<String> getPetsWithIntermitentConnectionProblemAndClosingTypedValueStream(@Connection PetStoreClient client, @Config PetStoreConnector config, String ownerName, @Optional TypedValue<InputStream> ownerSignature) throws IOException {
        return this.getPetsWithIntermitentConnectionProblemAndClosingStream(client, config, ownerName, (InputStream)ownerSignature.getValue());
    }

    public List<String> getPetsWithIntermitentConnectionProblemAndClosingStream(@Connection PetStoreClient client, @Config PetStoreConnector config, String ownerName, @Optional InputStream ownerSignature) throws IOException {
        operationExecutionCounter.incrementAndGet();
        if (ownerSignature != null) {
            ownerName = ownerName + IOUtils.toString((InputStream)ownerSignature);
        }
        boolean bl = shouldFailWithConnectionException = !shouldFailWithConnectionException;
        if (!shouldFailWithConnectionException) {
            ownerSignature.close();
            throw new RuntimeException((Throwable)new ConnectionException("kaboom"));
        }
        return client.getPets(ownerName, config);
    }

    @Throws(value={PetStoreCustomErrorProvider.class})
    @MediaType(value="text/plain")
    public String failsToReadStream(@Connection PetStoreClient connection, @Optional String content) throws MuleException {
        try {
            if (content == null) {
                throw new Exception("Null content cannot be processed");
            }
            throw new StreamingBufferSizeExceededException(1);
        }
        catch (Exception e) {
            throw new ModuleException((ErrorTypeDefinition)PetstoreErrorTypeDefinition.PET_ERROR, (Throwable)e);
        }
    }

    public PetStoreClient getClient(@Connection PetStoreClient client) {
        return client;
    }

    @MediaType(value="text/plain")
    public String getFishFromRiverStream(@Content InputStream river, @Optional InputStream pollutedStream) {
        StringBuilder builder = new StringBuilder();
        builder.append(IOUtils.toString((InputStream)river));
        if (pollutedStream != null) {
            builder.append(" ");
            builder.append(IOUtils.toString((InputStream)pollutedStream));
        }
        return builder.toString();
    }

    @MediaType(value="text/plain")
    public String describeSerializedAnimal(@ParameterDsl(allowReferences=false) Serializable animal) {
        if (animal instanceof byte[]) {
            return new String((byte[])animal);
        }
        return animal.toString();
    }

    @OutputResolver(output=CorrelationInfoOutputResolver.class)
    public CorrelationInfo getPetCorrelation(CorrelationInfo correlationInfo) {
        return correlationInfo;
    }

    public ExclusivePetBreeder getBreeder(@ParameterGroup(name="Exclusive") ExclusivePetBreeder breeder) {
        return breeder;
    }

    public ExclusiveCashier getCashier(@ParameterGroup(name="Exclusive") ExclusiveCashier cashier) {
        return cashier;
    }

    public Aquarium getAquarium(Aquarium aquarium) {
        return aquarium;
    }

    public PetStoreDeal getPetStoreDeal(PetStoreDeal petStoreDeal) {
        return petStoreDeal;
    }

    @MediaType(value="text/plain")
    public String getDefaultEncoding(boolean usePhoneNumber, @Optional PhoneNumber phoneNumber, @DefaultEncoding String encoding) {
        return usePhoneNumber ? phoneNumber.getCountryEncoding() : encoding;
    }

    public List<Pet> getForbiddenPets(List<Pet> forbiddenPets) {
        return forbiddenPets;
    }

    public PetStoreClient getClientOnLatch(@Connection PetStoreClient client, Object countDownLatch, Object latch) throws Exception {
        if (countDownLatch != null) {
            ((CountDownLatch)countDownLatch).countDown();
        }
        ((Latch)latch).await();
        return client;
    }

    public PetCage getCage(@Config PetStoreConnector config) {
        return config.getCage();
    }

    public PetStoreConnector getConfig(@Config PetStoreConnector config) {
        return config;
    }

    public void setSecureCage(@Optional @NullSafe List<String> providers, String user, String pass, AuthenticationHandler authHandler) throws SecurityException, SecurityProviderNotFoundException, UnknownAuthenticationTypeException {
        authHandler.setAuthentication(providers, authHandler.createAuthentication(authHandler.createCredentialsBuilder().withUsername(user).withPassword(pass.toCharArray()).build()));
    }

    public void makePhoneCall(PhoneNumber phoneNumber) {
    }

    @MediaType(value="*/*")
    public Character spellObject(Character character) {
        return character;
    }

    @MediaType(value="*/*")
    public char spellBuiltIn(char character) {
        return character;
    }

    @MediaType(value="*/*")
    public Class spellClass(Class clazz) {
        return clazz;
    }

    public MuleVersion getMuleVersion() {
        return this.muleVersion;
    }

    @MediaType(value="*/*")
    public String getStreamToString(InputStream stream) {
        return stream.toString();
    }

    static {
        operationExecutionCounter = new AtomicInteger(0);
        FeatureFlaggingRegistry.getInstance().registerFeature((Feature)PetStoreFeatures.LEGACY_FEATURE_ONE, c -> c.getConfiguration().getMinMuleVersion().isPresent() && !((MuleVersion)c.getConfiguration().getMinMuleVersion().get()).newerThan("4.2.2"));
        FeatureFlaggingRegistry.getInstance().registerFeatureFlag((Feature)PetStoreFeatures.LEGACY_FEATURE_TWO, featureContext -> featureContext.getArtifactMinMuleVersion().filter(muleVersion -> !muleVersion.newerThan("4.2.2")).isPresent());
    }

    public static class CorrelationInfoOutputResolver
    implements OutputTypeResolver<CorrelationInfo> {
        public MetadataType getOutputType(MetadataContext context, CorrelationInfo key) {
            return context.getTypeLoader().load(CorrelationInfo.class);
        }

        public String getCategoryName() {
            return "correlationInfo";
        }
    }
}

