/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.petstore.extension;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.extension.api.annotation.execution.OnError;
import org.mule.runtime.extension.api.annotation.execution.OnSuccess;
import org.mule.runtime.extension.api.annotation.execution.OnTerminate;
import org.mule.runtime.extension.api.annotation.metadata.MetadataScope;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Optional;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.sdk.api.runtime.operation.Result;
import org.mule.sdk.api.runtime.source.PollContext;
import org.mule.sdk.api.runtime.source.PollingSource;
import org.mule.sdk.api.runtime.source.SourceCallbackContext;
import org.mule.test.petstore.extension.PollingSourceMetadataResolver;

@MetadataScope(outputResolver=PollingSourceMetadataResolver.class)
@MediaType(value="text/plain")
public class NumberPetAdoptionSource
extends PollingSource<String, Void> {
    public static final List<String> ALL_NUMBERS = Arrays.asList("50", "3", "20", "51", "90", "52");
    private static int timesPolled;
    private List<String> numbers;
    @Parameter
    @Optional(defaultValue="false")
    private boolean watermark;
    @Parameter
    @Optional(defaultValue="false")
    private boolean idempotent;

    protected void doStart() throws MuleException {
        this.numbers = new ArrayList<String>(ALL_NUMBERS);
        this.resetCounters();
    }

    protected void doStop() {
        this.numbers.clear();
        this.resetCounters();
    }

    @OnSuccess
    public void onSuccess() {
    }

    @OnError
    public void onError() {
    }

    @OnTerminate
    public void onTerminate() {
    }

    public void poll(PollContext<String, Void> pollContext) {
        pollContext.setWatermarkComparator(Comparator.naturalOrder());
        int amountOfNumbersToPoll = timesPolled == 0 ? 3 : this.numbers.size();
        this.numbers.subList(0, amountOfNumbersToPoll).stream().map(p -> Result.builder().output(p).build()).forEach(result -> pollContext.accept(item -> {
            item.setResult(result);
            if (this.idempotent) {
                item.setId((String)result.getOutput());
            }
            if (this.watermark) {
                item.setId((String)result.getOutput());
                item.setWatermark((Serializable)Integer.valueOf((String)result.getOutput()));
            }
        }));
        ++timesPolled;
    }

    public void onRejectedItem(Result<String, Void> result, SourceCallbackContext context) {
    }

    private void resetCounters() {
        timesPolled = 0;
    }
}

