/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.petstore.extension;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import org.mule.runtime.api.meta.MuleVersion;
import org.mule.runtime.api.tls.TlsContextFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.test.petstore.extension.PetStoreConnector;

public class PetStoreClient {
    private String username;
    private String password;
    private TlsContextFactory tlsContext;
    private String configName;
    private int disconnectCount;
    private Date openingDate;
    private List<Date> closedForHolidays;
    private Long timeOfCreation;
    private MuleVersion muleVersion;
    private List<LocalDateTime> discountDates;

    public PetStoreClient(String username, String password, TlsContextFactory tlsContextFactory, String configName, Date openingDate, List<Date> closedForHolidays, List<LocalDateTime> discountDates, MuleVersion muleVersion) {
        this.username = username;
        this.password = password;
        this.tlsContext = tlsContextFactory;
        this.configName = configName;
        this.openingDate = openingDate;
        this.closedForHolidays = closedForHolidays;
        this.discountDates = discountDates;
        this.timeOfCreation = System.currentTimeMillis();
        this.muleVersion = muleVersion;
    }

    public List<String> getPets(String ownerName, PetStoreConnector config) {
        Preconditions.checkArgument((boolean)ownerName.equals(this.username), (String)"config doesn't match");
        return config.getPets();
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public void disconnect() {
        ++this.disconnectCount;
    }

    public int getDisconnectCount() {
        return this.disconnectCount;
    }

    public boolean hasActiveConnection() {
        Preconditions.checkState((this.disconnectCount >= 0 ? 1 : 0) != 0, (String)"negative disconnectCount");
        return this.disconnectCount == 0;
    }

    public TlsContextFactory getTlsContext() {
        return this.tlsContext;
    }

    public String getConfigName() {
        return this.configName;
    }

    public Date getOpeningDate() {
        return this.openingDate;
    }

    public List<Date> getClosedForHolidays() {
        return this.closedForHolidays;
    }

    public List<LocalDateTime> getDiscountDates() {
        return this.discountDates;
    }

    public long getTimeOfCreation() {
        return this.timeOfCreation;
    }

    public MuleVersion getMuleVersion() {
        return this.muleVersion;
    }
}

