/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.test.extension.reconnection;

import javax.inject.Inject;
import org.mule.extension.test.extension.reconnection.ReconnectableConnection;
import org.mule.extension.test.extension.reconnection.ReconnectableConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;

@MediaType(value="text/plain")
public class ReconectionSource
extends Source<ReconnectableConnection, Void> {
    @Connection
    ConnectionProvider<ReconnectableConnection> connectionProvider;
    @Inject
    SchedulerService schedulerService;
    private Scheduler scheduler;

    public void onStart(SourceCallback<ReconnectableConnection, Void> sourceCallback) throws MuleException {
        try {
            ReconnectableConnection connection = (ReconnectableConnection)this.connectionProvider.connect();
            this.scheduler = this.schedulerService.ioScheduler();
            this.scheduler.execute(() -> {
                boolean shouldFinish = false;
                while (!shouldFinish) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        shouldFinish = true;
                    }
                    if (ReconnectableConnectionProvider.fail) {
                        sourceCallback.onConnectionException(new ConnectionException((Throwable)new RuntimeException(), (Object)connection));
                        shouldFinish = true;
                        continue;
                    }
                    sourceCallback.handle(Result.builder().output((Object)connection).build());
                }
            });
        }
        catch (Exception e) {
            sourceCallback.onConnectionException(new ConnectionException((Throwable)e));
        }
    }

    public void onStop() {
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
    }
}

