/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.test.extension.reconnection;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.mule.extension.test.extension.reconnection.ReconnectableConnection;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.sdk.api.runtime.operation.Result;
import org.mule.sdk.api.runtime.source.Source;
import org.mule.sdk.api.runtime.source.SourceCallback;

public class FallibleReconnectableSource
extends Source<Void, Void> {
    public static volatile boolean fail = false;
    public static volatile boolean simultaneouslyStartedSources = false;
    @Connection
    ConnectionProvider<ReconnectableConnection> connectionProvider;
    @Inject
    SchedulerService schedulerService;
    private Scheduler scheduler;
    private ScheduledFuture<?> scheduleWithFixedDelay;
    private static final AtomicInteger countStartedSources = new AtomicInteger(0);
    private static final Latch latch = new Latch();

    public void onStart(SourceCallback<Void, Void> sourceCallback) throws MuleException {
        if (countStartedSources.addAndGet(1) > 1) {
            simultaneouslyStartedSources = true;
        }
        try {
            this.doStart(sourceCallback);
        }
        finally {
            countStartedSources.addAndGet(-1);
        }
    }

    private void doStart(SourceCallback<Void, Void> sourceCallback) throws MuleException {
        if (fail) {
            this.await();
            fail = false;
            throw new RuntimeException("Fail starting source");
        }
        ReconnectableConnection connection = (ReconnectableConnection)this.connectionProvider.connect();
        this.scheduler = this.schedulerService.ioScheduler();
        this.scheduleWithFixedDelay = this.scheduler.scheduleWithFixedDelay(() -> {
            if (fail) {
                sourceCallback.onConnectionException(new ConnectionException((Throwable)new RuntimeException(), (Object)connection));
            } else {
                sourceCallback.handle(Result.builder().build());
            }
        }, 0L, 250L, TimeUnit.MILLISECONDS);
    }

    public void onStop() {
        if (this.scheduleWithFixedDelay != null) {
            this.scheduleWithFixedDelay.cancel(true);
        }
        if (this.scheduler != null) {
            this.scheduler.stop();
        }
    }

    private void await() {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void release() {
        latch.release();
    }
}

