/*
 * Decompiled with CFR 0.152.
 */
package org.mule.extension.test.extension.reconnection;

import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.inject.Inject;
import org.mule.extension.test.extension.reconnection.ReconnectableConnection;
import org.mule.extension.test.extension.reconnection.ReconnectableConnectionProvider;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.extension.api.annotation.param.Connection;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;

@MediaType(value="text/plain")
public class ReconectionSource
extends Source<ReconnectableConnection, Void> {
    @Connection
    ConnectionProvider<ReconnectableConnection> connectionProvider;
    @Inject
    SchedulerService schedulerService;
    private final AtomicReference<ScheduledFuture<?>> scheduleWithFixedDelay = new AtomicReference();
    private Scheduler scheduler;

    public void onStart(SourceCallback<ReconnectableConnection, Void> sourceCallback) throws MuleException {
        ReconnectableConnection connection = (ReconnectableConnection)this.connectionProvider.connect();
        this.scheduler = this.schedulerService.ioScheduler();
        this.scheduleWithFixedDelay.set(this.scheduler.scheduleWithFixedDelay(() -> {
            if (ReconnectableConnectionProvider.fail) {
                sourceCallback.onConnectionException(new ConnectionException((Throwable)new RuntimeException(), (Object)connection));
                this.scheduleWithFixedDelay.get().cancel(true);
            } else {
                sourceCallback.handle(Result.builder().output((Object)connection).build());
            }
        }, 0L, 1000L, TimeUnit.MILLISECONDS));
    }

    public void onStop() {
        if (this.scheduler != null) {
            this.scheduleWithFixedDelay.get().cancel(true);
            this.scheduler.stop();
        }
    }
}

