/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.test.rogue.extension.source;

import static java.util.concurrent.TimeUnit.SECONDS;

import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.sdk.api.runtime.operation.Result;
import org.mule.sdk.api.runtime.source.Source;
import org.mule.sdk.api.runtime.source.SourceCallback;
import org.mule.test.rogue.extension.RogueException;

import jakarta.inject.Inject;

/**
 * A source that fails when stopped.
 */
public class StopFailsSource extends Source<String, Object> {

  @Inject
  private SchedulerService schedulerService;

  @Override
  public void onStart(SourceCallback<String, Object> sourceCallback) throws MuleException {
    var scheduler = schedulerService.cpuLightScheduler();
    var sourceDispatchHandle = scheduler.scheduleAtFixedRate(() -> {
      try {
        System.out.println("NeverStoppingSource dispatching...");
        sourceCallback.handle(Result.<String, Object>builder().output("hello!").build());
        System.out.println("NeverStoppingSource dispatched");
      } catch (Throwable t) {
        t.printStackTrace();
      }
    }, 0, 1, SECONDS);
  }

  @Override
  public void onStop() {
    throw new RogueException("Source failure");
  }

}
