/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.test.rogue.extension;

import static org.mule.sdk.api.meta.JavaVersion.JAVA_17;
import static org.mule.sdk.api.meta.JavaVersion.JAVA_21;

import org.mule.sdk.api.annotation.Extension;
import org.mule.sdk.api.annotation.JavaVersionSupport;
import org.mule.sdk.api.annotation.Sources;
import org.mule.sdk.api.annotation.dsl.xml.Xml;
import org.mule.test.rogue.extension.source.NeverStoppingSource;
import org.mule.test.rogue.extension.source.StopFailsSource;
import org.mule.test.rogue.extension.source.StopHangsSource;

/**
 * A Mule extension for testing robustness and resiliency when dealing with misbehaving extensions.
 * <p>
 * <b>rogue</b> /rəʊɡ/ (adj): denoting a person or thing that behaves in an aberrant or unpredictable way, typically with
 * damaging or dangerous effects.
 */
@Extension(name = "rogue")
@JavaVersionSupport({JAVA_17, JAVA_21})
@Xml(prefix = "rogue")
@Sources({
    NeverStoppingSource.class,
    StopFailsSource.class,
    StopHangsSource.class
})
public class RogueExtension {

}
