/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.some.extension;

import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;
import org.mule.runtime.extension.api.annotation.param.MediaType;
import org.mule.runtime.extension.api.annotation.param.Parameter;
import org.mule.runtime.extension.api.runtime.operation.Result;
import org.mule.runtime.extension.api.runtime.source.Source;
import org.mule.runtime.extension.api.runtime.source.SourceCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@MediaType(value="text/plain")
public class SomeEmittingSource
extends Source<String, String>
implements Initialisable,
Disposable {
    private final Logger LOGGER = LoggerFactory.getLogger(SomeEmittingSource.class);
    @Inject
    private SchedulerService schedulerService;
    private static AtomicInteger emissions = new AtomicInteger(0);
    private Future<?> launchedEmitterFuture;
    @Parameter
    String message;
    @Parameter
    Integer times;
    private Scheduler emitterScheduler;

    public void onStart(SourceCallback<String, String> sourceCallback) {
        emissions.set(this.times);
        this.launchedEmitterFuture = this.emitterScheduler.submit(() -> {
            while (!Thread.currentThread().isInterrupted() && emissions.getAndDecrement() > 0) {
                this.LOGGER.info("Emitting an event through flow");
                sourceCallback.handle(Result.builder().output((Object)this.message).build());
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    this.LOGGER.error("Emitting thread was interrupted: ", (Throwable)e);
                }
            }
        });
    }

    public void onStop() {
        this.launchedEmitterFuture.cancel(true);
    }

    public void initialise() {
        this.emitterScheduler = this.schedulerService.customScheduler(SchedulerConfig.config().withName("Value emitting scheduler").withMaxConcurrentTasks(1));
    }

    public void dispose() {
        this.emitterScheduler.stop();
    }
}

