/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.extension.dsl;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.extensions.jms.api.connection.caching.NoCachingConfiguration;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterGroupElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.RouteElementDeclaration;
import org.mule.runtime.app.declaration.api.fluent.ArtifactDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConfigurationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConnectionElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConstructElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.OperationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.RouteElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.SourceElementDeclarer;
import org.mule.runtime.config.api.dsl.ArtifactDeclarationXmlSerializer;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.runtime.ExpirationPolicy;
import org.mule.test.extension.dsl.AbstractElementModelTestCase;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import org.mule.test.runner.RunnerDelegateTo;

@RunnerDelegateTo(value=Parameterized.class)
public class ArtifactDeclarationSerializerTestCase
extends AbstractElementModelTestCase {
    private String expectedAppXml;
    @Parameterized.Parameter(value=0)
    public String configFile;
    @Parameterized.Parameter(value=1)
    public ArtifactDeclaration applicationDeclaration;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"full-artifact-config-dsl-app.xml", ArtifactDeclarationSerializerTestCase.createFullArtifactDeclaration()}, {"multi-flow-dsl-app.xml", ArtifactDeclarationSerializerTestCase.createMultiFlowArtifactDeclaration()}, {"no-mule-components-dsl-app.xml", ArtifactDeclarationSerializerTestCase.createNoMuleComponentsArtifactDeclaration()});
    }

    @Before
    public void loadExpectedResult() throws IOException {
        this.expectedAppXml = IOUtils.getResourceAsString((String)this.configFile, ((Object)((Object)this)).getClass());
    }

    @Test
    public void serialize() throws Exception {
        String serializationResult = ArtifactDeclarationXmlSerializer.getDefault((DslResolvingContext)this.dslContext).serialize(this.applicationDeclaration);
        ExtensionsTestUtils.compareXML((String)this.expectedAppXml, (String)serializationResult);
    }

    @Test
    public void loadCustomConfigParameters() {
        InputStream configIs = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.configFile);
        ArtifactDeclarationXmlSerializer serializer = ArtifactDeclarationXmlSerializer.getDefault((DslResolvingContext)this.dslContext);
        ArtifactDeclaration artifact = serializer.deserialize(configIs);
        List<String> expectedCustomParams = Arrays.asList("xmlns", "xmlns:xsi", "xsi:schemaLocation");
        List customParameters = artifact.getCustomConfigurationParameters();
        expectedCustomParams.forEach(custom -> MatcherAssert.assertThat((String)("Missing parameter: " + custom), (Object)customParameters.stream().anyMatch(p -> p.getName().equals(custom)), (Matcher)Matchers.is((Object)true)));
    }

    @Test
    public void loadAndserialize() throws Exception {
        InputStream configIs = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.configFile);
        ArtifactDeclarationXmlSerializer serializer = ArtifactDeclarationXmlSerializer.getDefault((DslResolvingContext)this.dslContext);
        ArtifactDeclaration artifact = serializer.deserialize(configIs);
        String serializationResult = serializer.serialize(artifact);
        ExtensionsTestUtils.compareXML((String)this.expectedAppXml, (String)serializationResult);
    }

    protected String[] getConfigFiles() {
        return new String[0];
    }

    private static ArtifactDeclaration createMultiFlowArtifactDeclaration() {
        ElementDeclarer jms = ElementDeclarer.forExtension((String)"JMS");
        ElementDeclarer core = ElementDeclarer.forExtension((String)"mule");
        return (ArtifactDeclaration)ElementDeclarer.newArtifact().withGlobalElement((GlobalElementDeclaration)jms.newConfiguration("config").withRefName("config").withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)jms.newConnection("active-mq").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("cachingStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType(NoCachingConfiguration.class.getName()).build()).getDeclaration())).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("send-payload").withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)((OperationElementDeclarer)jms.newOperation("publish").withConfig("config")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("destination", "#[initialDestination]").getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Message").withParameter("body", "#[payload]").withParameter("properties", "#[{(initialProperty): propertyValue}]").getDeclaration())).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("bridge").withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)jms.newOperation("consume").withConfig("config")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("destination", "#[initialDestination]").withParameter("maximumWait", "1000").getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("foreach").withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)((OperationElementDeclarer)jms.newOperation("publish").withConfig("config")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("destination", "#[finalDestination]").getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Message").withParameter("jmsxProperties", "#[attributes.properties.jmsxProperties]").withParameter("body", "#[bridgePrefix ++ payload]").withParameter("properties", "#[attributes.properties.userProperties]").getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)core.newOperation("logger").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("message", "Message Sent").getDeclaration())).getDeclaration())).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("bridge-receiver").withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)jms.newOperation("consume").withConfig("config")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("destination", "#[finalDestination]").withParameter("maximumWait", "1000").getDeclaration())).getDeclaration())).getDeclaration()).getDeclaration();
    }

    private static ArtifactDeclaration createFullArtifactDeclaration() {
        ElementDeclarer core = ElementDeclarer.forExtension((String)"mule");
        ElementDeclarer db = ElementDeclarer.forExtension((String)"Database");
        ElementDeclarer http = ElementDeclarer.forExtension((String)"HTTP");
        ElementDeclarer sockets = ElementDeclarer.forExtension((String)"Sockets");
        ElementDeclarer wsc = ElementDeclarer.forExtension((String)"Web Service Consumer");
        ElementDeclarer file = ElementDeclarer.forExtension((String)"File");
        ElementDeclarer os = ElementDeclarer.forExtension((String)"ObjectStore");
        return (ArtifactDeclaration)((ArtifactDeclarer)ElementDeclarer.newArtifact().withCustomParameter("xmlns:doc", "http://www.mulesoft.org/schema/mule/documentation")).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)core.newConstruct("configuration").withParameterGroup(group -> group.withParameter("defaultErrorHandler-ref", "referableHandler"))).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)core.newConstruct("errorHandler").withRefName("referableHandler").withComponent((ComponentElementDeclaration)((RouteElementDeclarer)core.newRoute("onErrorContinue").withParameterGroup(group -> group.withParameter("type", "MULE:SOURCE_RESPONSE").withParameter("logException", "false").withParameter("enableNotifications", "false"))).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)core.newOperation("logger").withParameterGroup(group -> group.withParameter("level", "TRACE"))).getDeclaration()).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)os.newGlobalParameter("objectStore").withRefName("persistentStore").withValue(ElementDeclarer.newObjectValue().ofType("org.mule.extension.objectstore.api.TopLevelObjectStore").withParameter("entryTtl", "1").withParameter("entryTtlUnit", "HOURS").withParameter("maxEntries", "10").withParameter("persistent", "true").withParameter("expirationInterval", "2").withParameter("expirationIntervalUnit", "HOURS").withParameter("config-ref", "persistentConfig").build()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)os.newConfiguration("config").withRefName("persistentConfig").getDeclaration()).withGlobalElement((GlobalElementDeclaration)file.newConfiguration("config").withRefName("fileConfig").withConnection((ConnectionElementDeclaration)file.newConnection("connection").getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConfigurationElementDeclarer)wsc.newConfiguration("config").withRefName("wscConfig").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("expirationPolicy", (ParameterValue)ElementDeclarer.newObjectValue().ofType(ExpirationPolicy.class.getName()).withParameter("maxIdleTime", "1").withParameter("timeUnit", TimeUnit.MINUTES.name()).build()).getDeclaration())).withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)((ConnectionElementDeclarer)wsc.newConnection("connection").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("soapVersion", "SOAP11").withParameter("mtomEnabled", "false").getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Connection").withParameter("wsdlLocation", "http://www.webservicex.com/globalweather.asmx?WSDL").withParameter("address", "http://www.webservicex.com/globalweather.asmx").withParameter("service", "GlobalWeather").withParameter("port", "GlobalWeatherSoap").getDeclaration())).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)db.newConfiguration("config").withRefName("dbConfig").withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)((ConnectionElementDeclarer)db.newConnection("derby").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("poolingProfile", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("maxPoolSize", "10").build()).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Connection").withParameter("connectionProperties", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("first", "propertyOne").withParameter("second", "propertyTwo").build()).withParameter("reconnection", (ParameterValue)ElementDeclarer.newObjectValue().ofType("Reconnection").withParameter("failsDeployment", "true").withParameter("reconnectionStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("reconnect").withParameter("count", "1").withParameter("frequency", "0").build()).build()).withParameter("database", "target/muleEmbeddedDB").withParameter("create", "true").getDeclaration())).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConfigurationElementDeclarer)http.newConfiguration("listenerConfig").withRefName("httpListener").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("basePath", "/").getDeclaration())).withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)((ConnectionElementDeclarer)http.newConnection("listener").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("tlsContext", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("key-store", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("path", "ssltest-keystore.jks").withParameter("password", "changeit").withParameter("keyPassword", "changeit").build()).withParameter("trust-store", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("insecure", "true").build()).withParameter("revocation-check", (ParameterValue)ElementDeclarer.newObjectValue().ofType("standard-revocation-check").withParameter("onlyEndEntities", "true").build()).build()).getDeclaration())).withParameterGroup(group -> group.withName("Connection").withParameter("host", "localhost").withParameter("port", "49019").withParameter("protocol", "HTTPS"))).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)http.newConfiguration("requestConfig").withRefName("httpRequester").withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)((ConnectionElementDeclarer)http.newConnection("request").withParameterGroup(group -> group.withParameter("authentication", (ParameterValue)ElementDeclarer.newObjectValue().ofType("org.mule.extension.http.api.request.authentication.BasicAuthentication").withParameter("username", "user").withParameter("password", "pass").build()))).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Connection").withParameter("host", "localhost").withParameter("port", "49020").withParameter("clientSocketProperties", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("connectionTimeout", "1000").withParameter("keepAlive", "true").withParameter("receiveBufferSize", "1024").withParameter("sendBufferSize", "1024").withParameter("clientTimeout", "1000").withParameter("linger", "1000").build()).getDeclaration())).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("testFlow").withCustomParameter("doc:id", "docUUID")).withParameterGroup(group -> group.withParameter("initialState", "stopped"))).withComponent((ComponentElementDeclaration)((SourceElementDeclarer)((SourceElementDeclarer)((SourceElementDeclarer)((SourceElementDeclarer)((SourceElementDeclarer)http.newSource("listener").withConfig("httpListener")).withCustomParameter("doc:id", "docUUID")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("path", "testBuilder").withParameter("redeliveryPolicy", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("maxRedeliveryCount", "2").withParameter("useSecureHash", "true").build()).getDeclaration())).withParameterGroup(group -> group.withName("Connection").withParameter("reconnectionStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("reconnect").withParameter("count", "1").withParameter("frequency", "0").build()))).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Response").withParameter("headers", "<![CDATA[#[{{'content-type' : 'text/plain'}}]]]>").withParameter("body", "<![CDATA[#[\n                    %dw 2.0\n                    output application/json\n                    input payload application/xml\n                    var baseUrl=\"http://sample.cloudhub.io/api/v1.0/\"\n                    ---\n                    using (pageSize = payload.getItemsResponse.PageInfo.pageSize) {\n                         links: [\n                            {\n                                href: fullUrl,\n                                rel : \"self\"\n                            }\n                         ],\n                         collection: {\n                            size: pageSize,\n                            items: payload.getItemsResponse.*Item map {\n                                id: $.id,\n                                type: $.type,\n                                name: $.name\n                            }\n                         }\n                    }\n                ]]>").getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("choice").withRoute((RouteElementDeclaration)((RouteElementDeclarer)core.newRoute("when").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("expression", "#[true]").getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)db.newOperation("bulkInsert").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Query").withParameter("sql", "INSERT INTO PLANET(POSITION, NAME) VALUES (:position, :name)").withParameter("parameterTypes", (ParameterValue)ElementDeclarer.newListValue().withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("key", "name").withParameter("type", "VARCHAR").build()).withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("key", "position").withParameter("type", "INTEGER").build()).build()).getDeclaration())).getDeclaration()).getDeclaration())).withRoute((RouteElementDeclaration)core.newRoute("otherwise").withComponent((ComponentElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("foreach").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("collection", "#[myCollection]").getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)core.newOperation("logger").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("message", "#[payload]").getDeclaration())).getDeclaration())).getDeclaration()).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)db.newOperation("bulkInsert").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Query").withParameter("sql", "INSERT INTO PLANET(POSITION, NAME) VALUES (:position, :name)").withParameter("parameterTypes", (ParameterValue)ElementDeclarer.newListValue().withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("key", "name").withParameter("type", "VARCHAR").build()).withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("key", "position").withParameter("type", "INTEGER").build()).build()).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)((OperationElementDeclarer)http.newOperation("request").withConfig("httpRequester")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"URI Settings").withParameter("path", "/nested").getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("method", "POST").getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)db.newOperation("insert").withConfig("dbConfig")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Query").withParameter("sql", "INSERT INTO PLANET(POSITION, NAME, DESCRIPTION) VALUES (777, 'Pluto', :description)").withParameter("parameterTypes", (ParameterValue)ElementDeclarer.newListValue().withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("key", "description").withParameter("type", "CLOB").build()).build()).withParameter("inputParameters", "#[{{'description' : payload}}]").getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)sockets.newOperation("sendAndReceive").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("streamingStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("repeatable-in-memory-stream").withParameter("bufferSizeIncrement", "8").withParameter("bufferUnit", "KB").withParameter("initialBufferSize", "51").withParameter("maxBufferSize", "1000").build()).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Output").withParameter("target", "myVar").withParameter("targetValue", "#[message]").getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("try").withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)wsc.newOperation("consume").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("operation", "GetCitiesByCountry").getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Message").withParameter("attachments", "#[{}]").withParameter("headers", "#[{\"headers\": {con#headerIn: \"Header In Value\",con#headerInOut: \"Header In Out Value\"}]").withParameter("body", "#[payload]").getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("errorHandler").withComponent((ComponentElementDeclaration)((RouteElementDeclarer)core.newRoute("onErrorContinue").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("type", "MULE:ANY").getDeclaration())).withComponent((ComponentElementDeclaration)core.newOperation("logger").getDeclaration()).getDeclaration())).withComponent((ComponentElementDeclaration)((RouteElementDeclarer)core.newRoute("onErrorPropagate").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("type", "WSC:CONNECTIVITY").withParameter("when", "#[e.cause == null]").getDeclaration())).getDeclaration())).getDeclaration())).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("schedulerFlow").withComponent((ComponentElementDeclaration)((SourceElementDeclarer)core.newSource("scheduler").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("schedulingStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("org.mule.runtime.core.api.source.scheduler.FixedFrequencyScheduler").withParameter("frequency", "50").withParameter("startDelay", "20").withParameter("timeUnit", "SECONDS").build()).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)core.newOperation("logger").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("message", "#[payload]").getDeclaration())).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("cronSchedulerFlow").withComponent((ComponentElementDeclaration)((SourceElementDeclarer)core.newSource("scheduler").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("schedulingStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("org.mule.runtime.core.api.source.scheduler.CronScheduler").withParameter("expression", "0/1 * * * * ?").build()).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)core.newOperation("logger").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("message", "#[payload]").getDeclaration())).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("fileListenerToObjectStore").withComponent((ComponentElementDeclaration)((SourceElementDeclarer)file.newSource("listener").withConfig("fileConfig")).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)os.newOperation("store").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("key", "key").withParameter("failOnNullValue", "#[vars.failOnNullValue]").withParameter("objectStore", "persistentStore").withParameter("value", "#[payload]").getDeclaration())).getDeclaration())).getDeclaration()).getDeclaration();
    }

    private static Object createNoMuleComponentsArtifactDeclaration() {
        ElementDeclarer core = ElementDeclarer.forExtension((String)"mule");
        ElementDeclarer jms = ElementDeclarer.forExtension((String)"JMS");
        ElementDeclarer http = ElementDeclarer.forExtension((String)"HTTP");
        return ElementDeclarer.newArtifact().withGlobalElement((GlobalElementDeclaration)jms.newConfiguration("config").withRefName("config").withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)jms.newConnection("active-mq").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("cachingStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType(NoCachingConfiguration.class.getName()).build()).getDeclaration())).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)http.newConfiguration("requestConfig").withRefName("httpRequester").withConnection((ConnectionElementDeclaration)http.newConnection("request").getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("send-payload").withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)((OperationElementDeclarer)jms.newOperation("publish").withConfig("config")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("destination", "#[initialDestination]").getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Message").withParameter("body", "#[payload]").withParameter("properties", "#[{(initialProperty): propertyValue}]").getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)((OperationElementDeclarer)http.newOperation("request").withConfig("httpRequester")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"URI Settings").withParameter("path", "/nested").getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("method", "POST").getDeclaration())).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("bridge").withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)jms.newOperation("consume").withConfig("config")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("destination", "#[initialDestination]").withParameter("maximumWait", "1000").getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)http.newOperation("request").withConfig("httpRequester")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"URI Settings").withParameter("path", "/nested").getDeclaration())).getDeclaration())).getDeclaration()).getDeclaration();
    }
}

