/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.extension.dsl;

import java.io.IOException;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.config.api.dsl.model.DslElementModel;
import org.mule.runtime.config.api.dsl.model.XmlDslElementModelConverter;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.test.extension.dsl.AbstractElementModelTestCase;
import org.mule.test.module.extension.internal.util.ExtensionsTestUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConfigurationBasedDslElementModelSerializerTestCase
extends AbstractElementModelTestCase {
    public static final int SOCKETS_SEND_RECEIVE_PATH = 5;
    public static final int TRY_PATH = 6;
    public static final int WSC_CONSUME_PATH = 7;
    private Element flow;
    private String expectedAppXml;

    @Before
    public void createDocument() throws Exception {
        this.applicationModel = this.loadApplicationModel();
        this.createAppDocument();
        Element flow = this.doc.createElement("flow");
        flow.setAttribute("name", "testFlow");
        flow.setAttribute("initialState", "stopped");
        this.flow = flow;
    }

    @Before
    public void loadExpectedResult() throws IOException {
        this.expectedAppXml = IOUtils.getResourceAsString((String)this.getConfigFile(), ((Object)((Object)this)).getClass());
    }

    protected String getConfigFile() {
        return "component-config-app-declaration.xml";
    }

    @Test
    public void serialize() throws Exception {
        XmlDslElementModelConverter converter = XmlDslElementModelConverter.getDefault((Document)this.doc);
        this.doc.getDocumentElement().appendChild(converter.asXml(this.resolve(this.getAppElement(this.applicationModel, "dbConfig"))));
        this.doc.getDocumentElement().appendChild(converter.asXml(this.resolve(this.getAppElement(this.applicationModel, "httpListener"))));
        this.doc.getDocumentElement().appendChild(converter.asXml(this.resolve(this.getAppElement(this.applicationModel, "httpRequester"))));
        this.doc.getDocumentElement().appendChild(converter.asXml(this.resolve(this.getAppElement(this.applicationModel, "sockets-config"))));
        this.doc.getDocumentElement().appendChild(converter.asXml(this.resolve(this.getAppElement(this.applicationModel, "wsc-config"))));
        ComponentConfiguration componentsFlow = this.getAppElement(this.applicationModel, "testFlow");
        Element httpListenerSource = converter.asXml(this.resolve((ComponentConfiguration)componentsFlow.getNestedComponents().get(0)));
        this.addRedeliveryPolicy(componentsFlow, httpListenerSource);
        this.flow.appendChild(httpListenerSource);
        this.flow.appendChild(converter.asXml(this.resolve((ComponentConfiguration)componentsFlow.getNestedComponents().get(2))));
        this.flow.appendChild(converter.asXml(this.resolve((ComponentConfiguration)componentsFlow.getNestedComponents().get(3))));
        this.flow.appendChild(converter.asXml(this.resolve((ComponentConfiguration)componentsFlow.getNestedComponents().get(4))));
        this.flow.appendChild(converter.asXml(this.resolve((ComponentConfiguration)componentsFlow.getNestedComponents().get(5))));
        this.flow.appendChild(converter.asXml(this.resolve((ComponentConfiguration)componentsFlow.getNestedComponents().get(6))));
        DslElementModel resolve = this.resolve((ComponentConfiguration)componentsFlow.getNestedComponents().get(7));
        Element element = converter.asXml(resolve);
        this.flow.appendChild(element);
        this.doc.getDocumentElement().appendChild(this.flow);
        String serializationResult = this.write();
        ExtensionsTestUtils.compareXML((String)this.expectedAppXml, (String)serializationResult);
    }

    private void addRedeliveryPolicy(ComponentConfiguration componentsFlow, Element httpListenerSource) {
        ComponentConfiguration redeliveryPolicy = (ComponentConfiguration)componentsFlow.getNestedComponents().get(1);
        Element policyElement = this.doc.createElement("redelivery-policy");
        redeliveryPolicy.getParameters().forEach(policyElement::setAttribute);
        httpListenerSource.insertBefore(policyElement, httpListenerSource.getFirstChild());
    }
}

