/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.extension.dsl;

import java.util.List;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.config.api.dsl.model.DslElementModel;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.test.extension.dsl.AbstractElementModelTestCase;

public class ConfigurationBasedElementModelFactoryTestCase
extends AbstractElementModelTestCase {
    @Before
    public void initApp() throws Exception {
        this.applicationModel = this.loadApplicationModel();
    }

    protected String getConfigFile() {
        return "integration-multi-config-dsl-app.xml";
    }

    @Test
    public void defaultGroupResolution() throws Exception {
        ComponentConfiguration flow = this.getAppElement(this.applicationModel, "testFlow");
        DslElementModel overrideWscConsume = this.resolve((ComponentConfiguration)flow.getNestedComponents().get(6));
        DslElementModel defaultWscConsume = this.resolve((ComponentConfiguration)flow.getNestedComponents().get(7));
        this.assertElementName(overrideWscConsume, "consume");
        this.assertElementName(defaultWscConsume, "consume");
        this.assertAttributeIsPresent(overrideWscConsume, "operation");
        this.assertAttributeIsPresent(defaultWscConsume, "operation");
        MatcherAssert.assertThat((Object)overrideWscConsume.findElement("transportHeaders").isPresent(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)defaultWscConsume.findElement("transportHeaders").isPresent(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)defaultWscConsume.getContainedElements().size(), (Matcher)Is.is((Object)overrideWscConsume.getContainedElements().size()));
        MatcherAssert.assertThat((Object)overrideWscConsume.findElement("body").isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)defaultWscConsume.findElement("body").isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat(((DslElementModel)overrideWscConsume.findElement("body").get()).getValue().get(), (Matcher)Is.is((Object)"#['modified' ++ payload]"));
        MatcherAssert.assertThat(((DslElementModel)defaultWscConsume.findElement("body").get()).getValue().get(), (Matcher)Is.is((Object)"#[payload]"));
    }

    @Test
    public void defaultValueResolution() throws Exception {
        ComponentConfiguration config = this.getAppElement(this.applicationModel, "dbConfig");
        DslElementModel configElement = this.resolve(config);
        DslElementModel connectionElement = this.getChild(configElement, (ComponentConfiguration)config.getNestedComponents().get(0));
        this.assertElementName(connectionElement, "derby-connection");
        this.assertHasParameter((ParameterizedModel)connectionElement.getModel(), "database");
        this.assertAttributeIsPresent(connectionElement, "database");
        this.assertHasParameter((ParameterizedModel)connectionElement.getModel(), "create");
        this.assertAttributeIsPresent(connectionElement, "create");
        this.assertValue((DslElementModel)connectionElement.findElement("create").get(), "true");
        this.assertHasParameter((ParameterizedModel)connectionElement.getModel(), "subsubProtocol");
        this.assertAttributeIsPresent(connectionElement, "subsubProtocol");
        this.assertValue((DslElementModel)connectionElement.findElement("subsubProtocol").get(), "directory");
    }

    @Test
    public void resolveConnectionWithMapParams() throws Exception {
        ComponentConfiguration config = this.getAppElement(this.applicationModel, "dbConfig");
        DslElementModel configElement = this.resolve(config);
        this.assertElementName(configElement, "config");
        MatcherAssert.assertThat((Object)configElement.getConfiguration().isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat(configElement.getConfiguration().get(), (Matcher)Is.is((Matcher)Matchers.equalTo((Object)config)));
        MatcherAssert.assertThat((Object)configElement.getIdentifier().isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat(configElement.getIdentifier().get(), (Matcher)Is.is((Matcher)Matchers.equalTo((Object)config.getIdentifier())));
        MatcherAssert.assertThat((Object)configElement.findElement(this.newIdentifier("oracle-connection", "db")).isPresent(), (Matcher)Is.is((Object)false));
        ComponentConfiguration connection = (ComponentConfiguration)config.getNestedComponents().get(0);
        DslElementModel connectionElement = this.getChild(configElement, connection);
        this.assertElementName(connectionElement, "derby-connection");
        this.assertHasParameter((ParameterizedModel)connectionElement.getModel(), "database");
        this.assertAttributeIsPresent(connectionElement, "database");
        this.assertHasParameter((ParameterizedModel)connectionElement.getModel(), "create");
        this.assertAttributeIsPresent(connectionElement, "create");
        MatcherAssert.assertThat((Object)connectionElement.findElement(this.newIdentifier("connection-properties", "db")).isPresent(), (Matcher)Is.is((Object)true));
        ComponentConfiguration pooling = (ComponentConfiguration)connection.getNestedComponents().get(0);
        DslElementModel poolingElement = this.getChild(connectionElement, pooling);
        this.assertValue((DslElementModel)poolingElement.findElement("maxPoolSize").get(), "10");
        this.assertValue((DslElementModel)poolingElement.findElement("minPoolSize").get(), "0");
        ComponentConfiguration properties = (ComponentConfiguration)connection.getNestedComponents().get(1);
        DslElementModel propertiesElement = this.getChild(connectionElement, properties);
        MatcherAssert.assertThat((Object)propertiesElement.getContainedElements().size(), (Matcher)Is.is((Object)2));
        Optional firstKey = ((DslElementModel)propertiesElement.getContainedElements().get(0)).findElement("key");
        this.assertValue((DslElementModel)firstKey.get(), "first");
        Optional firstVal = ((DslElementModel)propertiesElement.getContainedElements().get(0)).findElement("value");
        this.assertValue((DslElementModel)firstVal.get(), "propertyOne");
        Optional secondKey = ((DslElementModel)propertiesElement.getContainedElements().get(1)).findElement("key");
        this.assertValue((DslElementModel)secondKey.get(), "second");
        Optional secondVal = ((DslElementModel)propertiesElement.getContainedElements().get(1)).findElement("value");
        this.assertValue((DslElementModel)secondVal.get(), "propertyTwo");
    }

    @Test
    public void resolveConnectionNoExtraParameters() throws Exception {
        ComponentConfiguration config = this.getAppElement(this.applicationModel, "dbConfig");
        ComponentConfiguration connection = (ComponentConfiguration)config.getNestedComponents().get(0);
        DslElementModel configElement = this.resolve(config);
        DslElementModel connectionElement = this.getChild(configElement, connection);
        this.assertHasParameter((ParameterizedModel)connectionElement.getModel(), "columnTypes");
        MatcherAssert.assertThat((Object)connectionElement.findElement("columnTypes").isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void resolutionFailsForNonTopLevelElement() throws Exception {
        ComponentConfiguration config = this.getAppElement(this.applicationModel, "dbConfig");
        ComponentConfiguration connection = (ComponentConfiguration)config.getNestedComponents().get(0);
        MatcherAssert.assertThat((Object)this.modelResolver.create(connection).isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void resolveInfrastructureParametersAsElements() throws Exception {
        ComponentConfiguration config = this.getAppElement(this.applicationModel, "httpListener");
        DslElementModel configElement = this.resolve(config);
        MatcherAssert.assertThat((Object)configElement.findElement("tlsContext").isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((DslElementModel)configElement.findElement("tlsContext").get()).getConfiguration().isPresent(), (Matcher)Is.is((Object)true));
        ComponentConfiguration listener = (ComponentConfiguration)this.getAppElement(this.applicationModel, "testFlow").getNestedComponents().get(0);
        DslElementModel listenerElement = this.resolve(listener);
        MatcherAssert.assertThat((Object)listenerElement.findElement("reconnectionStrategy").isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((DslElementModel)listenerElement.findElement("reconnectionStrategy").get()).getConfiguration().isPresent(), (Matcher)Is.is((Object)true));
    }

    @Test
    public void resolveConfigNoExtraContainedElements() throws Exception {
        ComponentConfiguration config = this.getAppElement(this.applicationModel, "httpListener");
        DslElementModel configElement = this.resolve(config);
        MatcherAssert.assertThat((Object)configElement.findElement(this.newIdentifier("request-connection", "http")).isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void resolveConfigWithParameters() throws Exception {
        ComponentConfiguration config = this.getAppElement(this.applicationModel, "httpListener");
        DslElementModel configElement = this.resolve(config);
        this.assertElementName(configElement, "listener-config");
        this.assertHasParameter((ParameterizedModel)configElement.getModel(), "basePath");
        this.assertAttributeIsPresent(configElement, "basePath");
        ComponentConfiguration connection = (ComponentConfiguration)config.getNestedComponents().get(0);
        DslElementModel connectionElement = this.getChild(configElement, connection);
        this.assertElementName(connectionElement, "listener-connection");
        this.assertAttributeIsPresent(connectionElement, "host");
        this.assertAttributeIsPresent(connectionElement, "port");
        MatcherAssert.assertThat((Object)configElement.findElement(this.newIdentifier("request-connection", "http")).isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void resolveConnectionWithSubtypes() throws Exception {
        ComponentConfiguration config = this.getAppElement(this.applicationModel, "httpRequester");
        DslElementModel configElement = this.resolve(config);
        this.assertElementName(configElement, "request-config");
        ComponentConfiguration connection = (ComponentConfiguration)config.getNestedComponents().get(0);
        DslElementModel connectionElement = this.getChild(configElement, connection);
        this.assertElementName(connectionElement, "request-connection");
        this.assertHasParameter((ParameterizedModel)connectionElement.getModel(), "host");
        this.assertAttributeIsPresent(connectionElement, "host");
        this.assertHasParameter((ParameterizedModel)connectionElement.getModel(), "port");
        this.assertAttributeIsPresent(connectionElement, "port");
        ComponentConfiguration authenticationWrapper = (ComponentConfiguration)connection.getNestedComponents().get(0);
        DslElementModel authenticationWrapperElement = this.getChild(connectionElement, authenticationWrapper);
        this.assertElementName(authenticationWrapperElement, "authentication");
        DslElementModel basicAuthElement = this.getChild(connectionElement, this.newIdentifier("basic-authentication", "http"));
        this.assertElementName(basicAuthElement, "basic-authentication");
        MatcherAssert.assertThat((Object)basicAuthElement.getDsl().isWrapped(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)basicAuthElement.getDsl().supportsAttributeDeclaration(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)configElement.findElement(this.newIdentifier("listener-connection", "http")).isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void resolveConnectionWithImportedTypes() throws Exception {
        ComponentConfiguration config = this.getAppElement(this.applicationModel, "httpRequester");
        DslElementModel configElement = this.resolve(config);
        this.assertElementName(configElement, "request-config");
        ComponentConfiguration connection = (ComponentConfiguration)config.getNestedComponents().get(0);
        DslElementModel connectionElement = this.getChild(configElement, connection);
        this.assertElementName(connectionElement, "request-connection");
        this.assertHasParameter((ParameterizedModel)connectionElement.getModel(), "host");
        this.assertAttributeIsPresent(connectionElement, "host");
        this.assertHasParameter((ParameterizedModel)connectionElement.getModel(), "port");
        this.assertAttributeIsPresent(connectionElement, "port");
        ComponentConfiguration propertiesWrapper = (ComponentConfiguration)connection.getNestedComponents().get(1);
        DslElementModel wrapperElement = this.getChild(connectionElement, propertiesWrapper);
        this.assertElementName(wrapperElement, "client-socket-properties");
        ComponentConfiguration properties = (ComponentConfiguration)propertiesWrapper.getNestedComponents().get(0);
        DslElementModel propertiesElement = this.getChild(wrapperElement, properties);
        this.assertElementName(propertiesElement, "tcp-client-socket-properties");
        MatcherAssert.assertThat((Object)propertiesElement.getDsl().isWrapped(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)propertiesElement.getDsl().supportsAttributeDeclaration(), (Matcher)Is.is((Object)false));
        this.assertValue((DslElementModel)configElement.findElement("receiveBufferSize").get(), "1024");
        this.assertValue((DslElementModel)configElement.findElement("sendTcpNoDelay").get(), "true");
        MatcherAssert.assertThat((Object)configElement.findElement(this.newIdentifier("listener-connection", "http")).isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void flowElementsResolution() throws Exception {
        ComponentConfiguration flow = this.getAppElement(this.applicationModel, "testFlow");
        ComponentConfiguration listener = (ComponentConfiguration)flow.getNestedComponents().get(0);
        this.assertListenerSourceWithMessageBuilder(listener);
        ComponentConfiguration dbBulkInsert = (ComponentConfiguration)flow.getNestedComponents().get(2);
        this.assertBulkInsertOperationWithNestedList(dbBulkInsert);
        ComponentConfiguration requester = (ComponentConfiguration)flow.getNestedComponents().get(3);
        this.assertRequestOperationWithFlatParameters(requester);
        ComponentConfiguration dbInsert = (ComponentConfiguration)flow.getNestedComponents().get(4);
        this.assertInsertOperationWithMaps(dbInsert);
    }

    @Test
    public void multiFlowModelLoaderFromComponentConfiguration() throws Exception {
        ExtensionModel jmsModel = (ExtensionModel)muleContext.getExtensionManager().getExtension("JMS").orElseThrow(() -> new IllegalStateException("Missing Extension JMS"));
        DslSyntaxResolver jmsDslResolver = DslSyntaxResolver.getDefault((ExtensionModel)jmsModel, (DslResolvingContext)this.dslContext);
        this.applicationModel = this.loadApplicationModel("multi-flow-dsl-app.xml");
        DslElementModel config = this.resolve(this.getAppElement(this.applicationModel, "config"));
        ConfigurationModel jmsConfigModel = (ConfigurationModel)jmsModel.getConfigurationModel("config").get();
        this.assertConfigLoaded(config, jmsConfigModel, jmsDslResolver);
        this.assertConnectionLoaded(config);
        OperationModel publishModel = (OperationModel)jmsConfigModel.getOperationModel("publish").get();
        OperationModel consumeModel = (OperationModel)jmsConfigModel.getOperationModel("consume").get();
        this.assertSendPayloadLoaded(publishModel, jmsDslResolver);
        this.assertBridgeLoaded(publishModel, consumeModel, jmsDslResolver);
        this.assertBridgeReceiverLoaded(consumeModel, jmsDslResolver);
    }

    private void assertSendPayloadLoaded(OperationModel publishModel, DslSyntaxResolver jmsDslResolver) {
        List sendOperations = this.getAppElement(this.applicationModel, "send-payload").getNestedComponents();
        MatcherAssert.assertThat((Object)sendOperations.size(), (Matcher)Is.is((Object)1));
        DslElementModel publishElement = this.resolve((ComponentConfiguration)sendOperations.get(0));
        MatcherAssert.assertThat((Object)publishElement.getModel(), (Matcher)Is.is((Object)publishModel));
        MatcherAssert.assertThat((Object)publishElement.getDsl(), (Matcher)Is.is((Object)jmsDslResolver.resolve((NamedObject)publishModel)));
        MatcherAssert.assertThat(((ComponentConfiguration)publishElement.getConfiguration().get()).getParameters().get("destination"), (Matcher)Is.is((Object)"#[initialDestination]"));
        MatcherAssert.assertThat((Object)((DslElementModel)publishElement.findElement("destination").get()).getConfiguration().isPresent(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)((DslElementModel)publishElement.findElement("destination").get()).getModel(), (Matcher)Is.is((Object)this.findParameter("destination", (ParameterizedModel)publishModel)));
        DslElementModel builderElement = (DslElementModel)publishElement.findElement("Message").get();
        MatcherAssert.assertThat((Object)builderElement.getModel(), (Matcher)Is.is((Object)publishModel.getParameterGroupModels().stream().filter(g -> g.getName().equals("Message")).findFirst().get()));
        Optional messageBuilder = builderElement.getConfiguration();
        MatcherAssert.assertThat((Object)messageBuilder.isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((ComponentConfiguration)messageBuilder.get()).getNestedComponents().size(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)((String)((ComponentConfiguration)((ComponentConfiguration)messageBuilder.get()).getNestedComponents().get(1)).getValue().get()).trim(), (Matcher)Is.is((Object)"#[{(initialProperty): propertyValue}]"));
    }

    private void assertBridgeLoaded(OperationModel publishModel, OperationModel consumeModel, DslSyntaxResolver jmsDslResolver) {
        List bridgeOperation = this.getAppElement(this.applicationModel, "bridge").getNestedComponents();
        MatcherAssert.assertThat((Object)bridgeOperation.size(), (Matcher)Is.is((Object)2));
        DslElementModel consumeElement = this.resolve((ComponentConfiguration)bridgeOperation.get(0));
        DslElementModel publishElement = this.resolve((ComponentConfiguration)((ComponentConfiguration)bridgeOperation.get(1)).getNestedComponents().get(0));
        MatcherAssert.assertThat((Object)consumeElement.getModel(), (Matcher)Is.is((Object)consumeModel));
        MatcherAssert.assertThat((Object)consumeElement.getDsl(), (Matcher)Is.is((Object)jmsDslResolver.resolve((NamedObject)consumeModel)));
        MatcherAssert.assertThat(((ComponentConfiguration)consumeElement.getConfiguration().get()).getParameters().get("destination"), (Matcher)Is.is((Object)"#[initialDestination]"));
        MatcherAssert.assertThat((Object)((DslElementModel)consumeElement.findElement("destination").get()).getConfiguration().isPresent(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)((DslElementModel)consumeElement.findElement("destination").get()).getModel(), (Matcher)Is.is((Object)this.findParameter("destination", (ParameterizedModel)consumeModel)));
        MatcherAssert.assertThat((Object)publishElement.getModel(), (Matcher)Is.is((Object)publishModel));
        MatcherAssert.assertThat((Object)publishElement.getDsl(), (Matcher)Is.is((Object)jmsDslResolver.resolve((NamedObject)publishModel)));
        MatcherAssert.assertThat((Object)((DslElementModel)publishElement.findElement("destination").get()).getModel(), (Matcher)Is.is((Object)this.findParameter("destination", (ParameterizedModel)publishModel)));
        MatcherAssert.assertThat((Object)((DslElementModel)publishElement.findElement("destination").get()).getConfiguration().isPresent(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat(((ComponentConfiguration)publishElement.getConfiguration().get()).getParameters().get("destination"), (Matcher)Is.is((Object)"#[finalDestination]"));
        DslElementModel builderElement = (DslElementModel)publishElement.findElement("Message").get();
        MatcherAssert.assertThat((Object)builderElement.getModel(), (Matcher)Is.is((Object)publishModel.getParameterGroupModels().stream().filter(g -> g.getName().equals("Message")).findFirst().get()));
        Optional messageBuilder = builderElement.getConfiguration();
        MatcherAssert.assertThat((Object)messageBuilder.isPresent(), (Matcher)Is.is((Object)true));
    }

    private void assertBridgeReceiverLoaded(OperationModel consumeModel, DslSyntaxResolver jmsDslResolver) {
        List consumeOperation = this.getAppElement(this.applicationModel, "bridge-receiver").getNestedComponents();
        MatcherAssert.assertThat((Object)consumeOperation.size(), (Matcher)Is.is((Object)1));
        DslElementModel consumeElement = this.resolve((ComponentConfiguration)consumeOperation.get(0));
        MatcherAssert.assertThat((Object)consumeElement.getModel(), (Matcher)Is.is((Object)consumeModel));
        MatcherAssert.assertThat((Object)consumeElement.getDsl(), (Matcher)Is.is((Object)jmsDslResolver.resolve((NamedObject)consumeModel)));
        MatcherAssert.assertThat((Object)((DslElementModel)consumeElement.findElement("destination").get()).getModel(), (Matcher)Is.is((Object)this.findParameter("destination", (ParameterizedModel)consumeModel)));
        MatcherAssert.assertThat((Object)((DslElementModel)consumeElement.findElement("destination").get()).getConfiguration().isPresent(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat(((ComponentConfiguration)consumeElement.getConfiguration().get()).getParameters().get("destination"), (Matcher)Is.is((Object)"#[finalDestination]"));
        MatcherAssert.assertThat((Object)consumeElement.findElement("ackMode").isPresent(), (Matcher)Is.is((Object)false));
    }

    private void assertConfigLoaded(DslElementModel<ConfigurationModel> config, ConfigurationModel jmsConfigModel, DslSyntaxResolver jmsDslResolver) {
        MatcherAssert.assertThat((Object)config.getModel(), (Matcher)Is.is((Object)jmsConfigModel));
        MatcherAssert.assertThat((Object)config.getDsl(), (Matcher)Is.is((Object)jmsDslResolver.resolve((NamedObject)jmsConfigModel)));
    }

    private void assertConnectionLoaded(DslElementModel<ConfigurationModel> config) {
        MatcherAssert.assertThat((Object)config.getContainedElements().size(), (Matcher)Is.is((Object)6));
        MatcherAssert.assertThat((Object)config.findElement("active-mq").isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((DslElementModel)config.findElement("active-mq").get()).getContainedElements().size(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)config.findElement(this.newIdentifier("consumer-config", "jms")).isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((DslElementModel)config.findElement(this.newIdentifier("consumer-config", "jms")).get()).getContainedElements().size(), (Matcher)Is.is((Object)2));
        MatcherAssert.assertThat((Object)config.findElement(this.newIdentifier("producer-config", "jms")).isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((DslElementModel)config.findElement(this.newIdentifier("producer-config", "jms")).get()).getContainedElements().size(), (Matcher)Is.is((Object)7));
        MatcherAssert.assertThat((Object)config.findElement(this.newIdentifier("no-caching", "jms")).isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)config.getContainedElements().stream().filter(element -> element.getDsl().getAttributeName().equals("sendCorrelationId")).findAny().isPresent(), (Matcher)Is.is((Object)true));
    }

    private ParameterModel findParameter(String name, ParameterizedModel model) {
        return model.getAllParameterModels().stream().filter(p -> p.getName().equals(name)).findFirst().get();
    }

    private void assertInsertOperationWithMaps(ComponentConfiguration dbInsert) {
        DslElementModel dbElement = this.resolve(dbInsert);
        MatcherAssert.assertThat((Object)dbElement.getContainedElements().size(), (Matcher)Is.is((Object)9));
        ComponentConfiguration sql = (ComponentConfiguration)dbInsert.getNestedComponents().get(0);
        DslElementModel sqlElement = this.getChild(dbElement, sql);
        this.assertElementName(sqlElement, "sql");
        ComponentConfiguration parameterTypes = (ComponentConfiguration)dbInsert.getNestedComponents().get(1);
        DslElementModel parameterTypesElement = this.getChild(dbElement, parameterTypes);
        this.assertElementName(parameterTypesElement, "parameter-types");
        DslElementModel elementOne = (DslElementModel)parameterTypesElement.getContainedElements().get(0);
        this.assertElementName(elementOne, "parameter-type");
        this.assertValue((DslElementModel)elementOne.findElement("key").get(), "description");
        this.assertValue((DslElementModel)elementOne.findElement("type").get(), "CLOB");
        this.assertValue((DslElementModel)dbElement.findElement(this.newIdentifier("input-parameters", "db")).get(), "#[{{'description' : payload}}]");
    }

    protected void assertRequestOperationWithFlatParameters(ComponentConfiguration requester) {
        DslElementModel requesterElement = this.resolve(requester);
        this.assertHasParameter((ParameterizedModel)requesterElement.getModel(), "path");
        MatcherAssert.assertThat((Object)requesterElement.findElement("path").isPresent(), (Matcher)Is.is((Object)true));
        this.assertHasParameter((ParameterizedModel)requesterElement.getModel(), "method");
        MatcherAssert.assertThat((Object)requesterElement.findElement("method").isPresent(), (Matcher)Is.is((Object)true));
    }

    protected void assertBulkInsertOperationWithNestedList(ComponentConfiguration dbInsert) {
        DslElementModel bulkInsertElement = this.resolve(dbInsert);
        MatcherAssert.assertThat((Object)bulkInsertElement.getContainedElements().size(), (Matcher)Is.is((Object)7));
        this.assertValue((DslElementModel)bulkInsertElement.findElement("bulkInputParameters").get(), "#[payload]");
        ComponentConfiguration sql = (ComponentConfiguration)dbInsert.getNestedComponents().get(0);
        DslElementModel sqlElement = this.getChild(bulkInsertElement, sql);
        this.assertElementName(sqlElement, "sql");
        this.assertValue(sqlElement, "INSERT INTO PLANET(POSITION, NAME) VALUES (:position, :name)");
        ComponentConfiguration parameterTypes = (ComponentConfiguration)dbInsert.getNestedComponents().get(1);
        DslElementModel parameterTypesElement = this.getChild(bulkInsertElement, parameterTypes);
        this.assertElementName(parameterTypesElement, "parameter-types");
        ComponentConfiguration parameterOne = (ComponentConfiguration)parameterTypes.getNestedComponents().get(0);
        MatcherAssert.assertThat(parameterOne.getParameters().get("key"), (Matcher)Is.is((Object)"name"));
        DslElementModel elementOne = (DslElementModel)parameterTypesElement.getContainedElements().get(0);
        this.assertElementName(elementOne, parameterOne.getIdentifier().getName());
        this.assertValue((DslElementModel)elementOne.findElement("key").get(), "name");
        this.assertValue((DslElementModel)elementOne.findElement("type").get(), "VARCHAR");
        ComponentConfiguration parameterTwo = (ComponentConfiguration)parameterTypes.getNestedComponents().get(1);
        MatcherAssert.assertThat(parameterTwo.getParameters().get("key"), (Matcher)Is.is((Object)"position"));
        DslElementModel elementTwo = (DslElementModel)parameterTypesElement.getContainedElements().get(1);
        this.assertElementName(elementTwo, parameterTwo.getIdentifier().getName());
        this.assertValue((DslElementModel)elementTwo.findElement("key").get(), "position");
        this.assertValue((DslElementModel)elementTwo.findElement("type").get(), "INTEGER");
    }

    protected void assertListenerSourceWithMessageBuilder(ComponentConfiguration listener) {
        DslElementModel listenerElement = this.resolve(listener);
        this.assertHasParameter((ParameterizedModel)listenerElement.getModel(), "path");
        ComponentConfiguration responseBuilder = (ComponentConfiguration)listener.getNestedComponents().get(1);
        DslElementModel responseBuilderElement = this.getChild(listenerElement, responseBuilder);
        this.assertElementName(responseBuilderElement, "response");
        MatcherAssert.assertThat((Object)responseBuilderElement.getDsl().getChild("headers").isPresent(), (Matcher)Is.is((Object)true));
        this.assertValue((DslElementModel)responseBuilderElement.findElement(this.newIdentifier("headers", "http")).get(), "#[{{'content-type' : 'text/plain'}}]");
        this.assertValue((DslElementModel)listenerElement.findElement("path").get(), "testBuilder");
    }
}

