/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.extension.dsl.syntax;

import java.util.Arrays;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.dsl.syntax.resolver.ImportTypesStrategy;
import org.mule.runtime.extension.api.dsl.syntax.resolver.SingleExtensionImportTypesStrategy;
import org.mule.runtime.internal.dsl.DslConstants;

public class MuleModelsDslSyntaxResolverTestCase {
    private static final String ASYNC_COMPONENT = "async";
    private static final String UNTIL_SUCCESSFUL_COMPONENT = "untilSuccessful";
    private static final String PARALLEL_FOREACH_COMPONENT = "parallelForeach";
    private static final String TRY_COMPONENT = "try";
    private static final String ERROR_HANDLER_COMPONENT = "errorHandler";
    private static final String CHOICE_COMPONENT = "choice";
    private static final String FOREACH_COMPONENT = "foreach";
    private static final String FIRST_SUCCESSFUL_COMPONENT = "firstSuccessful";
    private static final String SCATTER_GATHER_COMPONENT = "scatterGather";
    private static final String ROUND_ROBIN_COMPONENT = "roundRobin";
    private static final String FLOW_COMPONENT = "flow";
    private static final String SUBFLOW_COMPONENT = "subFlow";
    private DslSyntaxResolver dslSyntaxResolver;
    private ExtensionModel extensionModel = MuleExtensionModelProvider.getExtensionModel();

    @Before
    public void createDslSyntaxResolver() {
        this.dslSyntaxResolver = DslSyntaxResolver.getDefault((ExtensionModel)this.extensionModel, (ImportTypesStrategy)new SingleExtensionImportTypesStrategy());
    }

    @Test
    public void asyncComponentDslSyntax() {
        this.assertComponentDsl(ASYNC_COMPONENT, "name", "maxConcurrency");
    }

    @Test
    public void untilSuccessfulComponentDslSyntax() {
        this.assertComponentDsl(UNTIL_SUCCESSFUL_COMPONENT, "maxRetries", "millisBetweenRetries");
    }

    @Test
    public void parallelForeachComponentDslSyntax() {
        this.assertComponentDsl(PARALLEL_FOREACH_COMPONENT, "timeout", "target", "maxConcurrency", "targetValue");
    }

    @Test
    public void tryComponentDslSyntax() {
        this.assertComponentDsl(TRY_COMPONENT, "transactionalAction", "transactionType");
    }

    @Test
    public void errorHandlerComponentDslSyntax() {
        ConstructModel construct = (ConstructModel)this.extensionModel.getConstructModel(ERROR_HANDLER_COMPONENT).get();
        DslElementSyntax constructSyntax = this.dslSyntaxResolver.resolve((NamedObject)construct);
        this.assertParameterAttribute(constructSyntax, "name");
        this.assertParameterAttribute(constructSyntax, "ref");
        Optional onErrorSyntax = constructSyntax.getChild("onError");
        Optional onErrorContinueSyntax = constructSyntax.getChild("onErrorContinue");
        Optional onErrorPropagateSyntax = constructSyntax.getChild("onErrorPropagate");
        MatcherAssert.assertThat((Object)onErrorSyntax.isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)onErrorContinueSyntax.isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)onErrorPropagateSyntax.isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((DslElementSyntax)onErrorContinueSyntax.get()).getChild("processors").isPresent(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)((DslElementSyntax)onErrorPropagateSyntax.get()).getChild("processors").isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void choiceComponentDslSyntax() {
        ConstructModel construct = (ConstructModel)this.extensionModel.getConstructModel(CHOICE_COMPONENT).get();
        DslElementSyntax constructSyntax = this.dslSyntaxResolver.resolve((NamedObject)construct);
        Optional whenSyntax = constructSyntax.getChild("when");
        Optional otherwiseSyntax = constructSyntax.getChild("otherwise");
        MatcherAssert.assertThat((Object)whenSyntax.isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)otherwiseSyntax.isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((DslElementSyntax)whenSyntax.get()).getChild("processors").isPresent(), (Matcher)Is.is((Object)false));
        MatcherAssert.assertThat((Object)((DslElementSyntax)otherwiseSyntax.get()).getChild("processors").isPresent(), (Matcher)Is.is((Object)false));
    }

    @Test
    public void foreachComponentDslSyntax() {
        this.assertComponentDsl(FOREACH_COMPONENT, new String[0]);
    }

    @Test
    public void flowComponentDslSyntax() {
        this.assertComponentDsl(FLOW_COMPONENT, "name");
    }

    @Test
    public void subFlowComponentDslSyntax() {
        this.assertComponentDsl(SUBFLOW_COMPONENT, "name");
    }

    @Test
    public void firstSuccessfulComponentDslSyntax() {
        this.assertComponentWithRouteDsl(FIRST_SUCCESSFUL_COMPONENT, new String[0]);
    }

    @Test
    public void scatterGatherComponentDslSyntax() {
        this.assertComponentWithRouteDsl(SCATTER_GATHER_COMPONENT, new String[0]);
    }

    @Test
    public void roundRobinComponentDslSyntax() {
        this.assertComponentWithRouteDsl(ROUND_ROBIN_COMPONENT, new String[0]);
    }

    private void assertComponentDsl(String modelName, String ... attributes) {
        DslElementSyntax constructSyntax = this.getAndAssertConstruct(modelName, attributes);
        Optional processorsSyntax = constructSyntax.getChild("processors");
        MatcherAssert.assertThat((Object)processorsSyntax.isPresent(), (Matcher)Is.is((Object)false));
    }

    private void assertComponentWithRouteDsl(String modelName, String ... attributes) {
        DslElementSyntax constructSyntax = this.getAndAssertConstruct(modelName, attributes);
        Optional routeSyntax = constructSyntax.getChild("route");
        MatcherAssert.assertThat((Object)routeSyntax.isPresent(), (Matcher)Is.is((Object)true));
        Optional processorsSyntax = ((DslElementSyntax)routeSyntax.get()).getChild("processors");
        MatcherAssert.assertThat((Object)processorsSyntax.isPresent(), (Matcher)Is.is((Object)false));
    }

    private DslElementSyntax getAndAssertConstruct(String modelName, String[] attributes) {
        ConstructModel construct = (ConstructModel)this.extensionModel.getConstructModel(modelName).get();
        DslElementSyntax constructSyntax = this.dslSyntaxResolver.resolve((NamedObject)construct);
        MatcherAssert.assertThat((Object)constructSyntax.getPrefix(), (Matcher)Is.is((Object)"mule"));
        MatcherAssert.assertThat((Object)constructSyntax.getNamespace(), (Matcher)Is.is((Object)DslConstants.CORE_NAMESPACE));
        Arrays.stream(attributes).forEach(attribute -> this.assertParameterAttribute(constructSyntax, (String)attribute));
        return constructSyntax;
    }

    private void assertParameterAttribute(DslElementSyntax dslElementSyntax, String parameterName) {
        Optional parameterDslElementSyntax = dslElementSyntax.getAttribute(parameterName);
        MatcherAssert.assertThat((Object)parameterDslElementSyntax.isPresent(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((DslElementSyntax)parameterDslElementSyntax.get()).getElementName(), (Matcher)Is.is((Object)""));
        MatcherAssert.assertThat((Object)((DslElementSyntax)parameterDslElementSyntax.get()).getAttributeName(), (Matcher)Is.is((Object)parameterName));
    }
}

