/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config;

import io.qameta.allure.Description;
import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.runner.ArtifactClassLoaderRunnerConfig;

@ArtifactClassLoaderRunnerConfig(applicationSharedRuntimeLibs={"org.apache.derby:derby", "org.apache.activemq:activemq-client", "org.apache.activemq:activemq-broker", "org.apache.activemq:activemq-kahadb-store"})
@Feature(value="Lifecycle and Dependency Injection")
@Story(value="Graceful shutdown")
public class DefaultShutdowntimeoutTestCase
extends MuleArtifactFunctionalTestCase {
    @Rule
    public SystemProperty gracefulShutdownDefaultTimeout = new SystemProperty("mule.gracefulShutdown.defaultTimeout", "1234");

    protected String getConfigFile() {
        return "./simple.xml";
    }

    @Test
    @Description(value="Verify that the dsl/extModel do not have a default value that overrides the one from the environment configuration.")
    public void defaultShutdownTimeoutOverride() {
        MatcherAssert.assertThat((Object)muleContext.getConfiguration().getShutdownTimeout(), (Matcher)Is.is((Object)1234L));
    }

    protected boolean isGracefulShutdown() {
        return true;
    }
}

