/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config.ast;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.Before;
import org.junit.BeforeClass;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.extension.RuntimeExtensionModelProvider;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.module.extension.api.loader.java.DefaultJavaExtensionModelLoader;
import org.mule.runtime.module.extension.internal.manager.DefaultExtensionManager;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.test.runner.infrastructure.ExtensionsTestInfrastructureDiscoverer;

@Feature(value="Mule Artifact AST")
@Story(value="Parameter AST resolution")
public abstract class BaseParameterAstTestCase
extends AbstractMuleContextTestCase {
    private static List<ExtensionModel> runtimeExtensionModels;
    private DefaultExtensionManager extensionManager;

    @BeforeClass
    public static void beforeClass() throws Exception {
        runtimeExtensionModels = new ArrayList<ExtensionModel>();
        Collection runtimeExtensionModelProviders = new SpiServiceRegistry().lookupProviders(RuntimeExtensionModelProvider.class, Thread.currentThread().getContextClassLoader());
        for (RuntimeExtensionModelProvider runtimeExtensionModelProvider : runtimeExtensionModelProviders) {
            runtimeExtensionModels.add(runtimeExtensionModelProvider.createExtensionModel());
        }
    }

    @Before
    public void before() throws Exception {
        this.extensionManager = new DefaultExtensionManager();
        muleContext.setExtensionManager((ExtensionManager)this.extensionManager);
        LifecycleUtils.initialiseIfNeeded((Object)this.extensionManager, (MuleContext)muleContext);
    }

    protected ArtifactAst buildArtifactAst(String configFile, Class ... extensions) {
        ExtensionsTestInfrastructureDiscoverer discoverer = new ExtensionsTestInfrastructureDiscoverer((ExtensionManager)this.extensionManager);
        DefaultJavaExtensionModelLoader extensionModelLoader = new DefaultJavaExtensionModelLoader();
        for (Class annotatedClass : extensions) {
            discoverer.discoverExtension(annotatedClass, (ExtensionModelLoader)extensionModelLoader);
        }
        return AstXmlParser.builder().withExtensionModels((Collection)muleContext.getExtensionManager().getExtensions()).withExtensionModels(runtimeExtensionModels).withSchemaValidationsDisabled().build().parse(new URL[]{((Object)((Object)this)).getClass().getClassLoader().getResource("ast/" + configFile)});
    }

    protected Optional<ComponentAst> findComponent(Stream<ComponentAst> stream, String componentIdentifier, String componentId) {
        return this.findComponent(stream, ComponentIdentifier.buildFromStringRepresentation((String)componentIdentifier), componentId);
    }

    protected Optional<ComponentAst> findComponent(Stream<ComponentAst> stream, ComponentIdentifier identifier, String componentId) {
        return stream.filter(componentAst -> identifier.equals(componentAst.getIdentifier()) && componentId.equals(componentAst.getComponentId().orElse(null))).findFirst();
    }

    protected Optional<ComponentAst> findComponent(Stream<ComponentAst> stream, String componentIdentifier) {
        return this.findComponent(stream, ComponentIdentifier.buildFromStringRepresentation((String)componentIdentifier));
    }

    protected Optional<ComponentAst> findComponent(Stream<ComponentAst> stream, ComponentIdentifier identifier) {
        return stream.filter(componentAst -> identifier.equals(componentAst.getIdentifier())).findFirst();
    }

    protected Optional<ComponentAst> findComponentByComponentId(Stream<ComponentAst> stream, String componentId) {
        return stream.filter(c -> componentId.equals(c.getComponentId().orElse(null))).findFirst();
    }
}

