/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.extension.dsl;

import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ConstructElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterGroupElementDeclaration;
import org.mule.runtime.app.declaration.api.component.location.Location;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ParameterSimpleValue;
import org.mule.runtime.app.declaration.api.fluent.SourceElementDeclarer;
import org.mule.runtime.ast.api.DependencyResolutionMode;
import org.mule.runtime.config.api.dsl.ArtifactDeclarationXmlSerializer;
import org.mule.runtime.config.api.dsl.model.DslElementModelFactory;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.extension.dsl.AbstractElementModelTestCase;

public class ArtifactDeclarationLocationPathTestCase
extends AbstractElementModelTestCase {
    @Rule
    public SystemProperty minimalDependencies = new SystemProperty("mule." + DependencyResolutionMode.class.getName(), DependencyResolutionMode.MINIMAL.name());
    public static final String ORIGINAL_CONFIG = "multi-flow-dsl-app.xml";
    public static final String EXPECTED_UPDATED_CONFIG = "location-path-update-multi-flow-dsl-app.xml";
    public ArtifactDeclaration multiFlowDeclaration;
    private ArtifactDeclarationXmlSerializer serializer;

    protected String getConfigFile() {
        return ORIGINAL_CONFIG;
    }

    @Override
    @Before
    public void setup() throws Exception {
        Set extensions = muleContext.getExtensionManager().getExtensions();
        this.dslContext = DslResolvingContext.getDefault((Set)ImmutableSet.builder().addAll((Iterable)extensions).add((Object)MuleExtensionModelProvider.getExtensionModel()).build());
        this.modelResolver = DslElementModelFactory.getDefault((DslResolvingContext)this.dslContext);
        this.serializer = ArtifactDeclarationXmlSerializer.getDefault((DslResolvingContext)this.dslContext);
        this.multiFlowDeclaration = this.serializer.deserialize(this.getConfigFile(), Thread.currentThread().getContextClassLoader().getResourceAsStream(this.getConfigFile()));
    }

    @Test
    public void updatePropertyAndSerialize() throws Exception {
        ElementDeclarer jms = ElementDeclarer.forExtension((String)"JMS");
        Location destinationLocation = Location.builder().globalName("send-payload").addProcessorsPart().addIndexPart(0).addParameterPart().addPart("destination").build();
        Optional destination = this.multiFlowDeclaration.findElement(destinationLocation);
        MatcherAssert.assertThat((Object)destination.isPresent(), (Matcher)Is.is((Object)true));
        ((ParameterElementDeclaration)destination.get()).setValue(ParameterSimpleValue.of((String)"updatedDestination"));
        Location flowLocation = Location.builder().globalName("send-payload").build();
        Optional flow = this.multiFlowDeclaration.findElement(flowLocation);
        MatcherAssert.assertThat((Object)destination.isPresent(), (Matcher)Is.is((Object)true));
        ((ConstructElementDeclaration)flow.get()).addComponent(0, (ComponentElementDeclaration)((SourceElementDeclarer)((SourceElementDeclarer)jms.newSource("listener").withConfig("config")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("destination", "myListenerDestination").getDeclaration())).getDeclaration());
        String serialized = this.serializer.serialize(this.multiFlowDeclaration);
        ArtifactDeclarationLocationPathTestCase.compareXML(IOUtils.getResourceAsString((String)EXPECTED_UPDATED_CONFIG, ((Object)((Object)this)).getClass()), serialized);
    }
}

