/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.extension.dsl;

import java.io.IOException;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.config.api.dsl.model.XmlDslElementModelConverter;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.extension.dsl.AbstractElementModelTestCase;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ConfigurationBasedDslElementModelSerializerTestCase
extends AbstractElementModelTestCase {
    public static final int SOCKETS_SEND_RECEIVE_PATH = 4;
    public static final int TRY_PATH = 5;
    public static final int WSC_CONSUME_PATH = 6;
    private Element flow;
    private String expectedAppXml;
    @Rule
    public DynamicPort port = new DynamicPort("port");
    @Rule
    public DynamicPort otherPort = new DynamicPort("otherPort");

    @Before
    public void createDocument() throws Exception {
        this.applicationModel = this.loadApplicationModel();
        this.createAppDocument();
        Element flow = this.doc.createElement("flow");
        flow.setAttribute("name", "testFlow");
        flow.setAttribute("initialState", "stopped");
        this.flow = flow;
    }

    @Before
    public void loadExpectedResult() throws IOException {
        this.expectedAppXml = IOUtils.getResourceAsString((String)this.getConfigFile(), ((Object)((Object)this)).getClass());
    }

    protected String getConfigFile() {
        return "component-config-app-declaration.xml";
    }

    @Test
    public void serialize() throws Exception {
        XmlDslElementModelConverter converter = XmlDslElementModelConverter.getDefault((Document)this.doc);
        this.doc.getDocumentElement().appendChild(converter.asXml(this.resolve(this.getAppElement(this.applicationModel, "dbConfig"))));
        Element httpListenerConfig = converter.asXml(this.resolve(this.getAppElement(this.applicationModel, "httpListener")));
        httpListenerConfig.getElementsByTagName("http:listener-connection").item(0).getAttributes().getNamedItem("port").setNodeValue("${port}");
        this.doc.getDocumentElement().appendChild(httpListenerConfig);
        Element httpRequesterConfig = converter.asXml(this.resolve(this.getAppElement(this.applicationModel, "httpRequester")));
        httpRequesterConfig.getElementsByTagName("http:request-connection").item(0).getAttributes().getNamedItem("port").setNodeValue("${otherPort}");
        this.doc.getDocumentElement().appendChild(httpRequesterConfig);
        this.doc.getDocumentElement().appendChild(converter.asXml(this.resolve(this.getAppElement(this.applicationModel, "sockets-config"))));
        this.doc.getDocumentElement().appendChild(converter.asXml(this.resolve(this.getAppElement(this.applicationModel, "wsc-config"))));
        ComponentAst componentsFlow = this.getAppElement(this.applicationModel, "testFlow");
        this.flow.appendChild(converter.asXml(this.resolve((ComponentAst)componentsFlow.directChildrenStream().skip(0L).findFirst().get())));
        this.flow.appendChild(converter.asXml(this.resolve((ComponentAst)componentsFlow.directChildrenStream().skip(1L).findFirst().get())));
        this.flow.appendChild(converter.asXml(this.resolve((ComponentAst)componentsFlow.directChildrenStream().skip(2L).findFirst().get())));
        this.flow.appendChild(converter.asXml(this.resolve((ComponentAst)componentsFlow.directChildrenStream().skip(3L).findFirst().get())));
        this.flow.appendChild(converter.asXml(this.resolve((ComponentAst)componentsFlow.directChildrenStream().skip(4L).findFirst().get())));
        this.flow.appendChild(converter.asXml(this.resolve((ComponentAst)componentsFlow.directChildrenStream().skip(5L).findFirst().get())));
        this.flow.appendChild(converter.asXml(this.resolve((ComponentAst)componentsFlow.directChildrenStream().skip(6L).findFirst().get())));
        this.doc.getDocumentElement().appendChild(this.flow);
        String serializationResult = this.write();
        ConfigurationBasedDslElementModelSerializerTestCase.compareXML(this.expectedAppXml, serializationResult);
    }
}

