/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.extension.dsl;

import java.util.List;
import java.util.function.Consumer;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.Is;
import org.junit.Before;
import org.junit.Test;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.app.declaration.api.OperationElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterGroupElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.OperationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ParameterListValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterObjectValue;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.config.api.dsl.model.DslElementModel;
import org.mule.test.extension.dsl.AbstractElementModelTestCase;

public class DslElementModelFactoryComparisonTestCase
extends AbstractElementModelTestCase {
    private static final String OPERATION_NAME = "withComplexActingParameter";
    private static final String COMPLEX_ACTING_PARAMETER_NAME = "complexActingParameter";
    private static final String INT_PARAM_NAME = "intParam";
    private static final String STRING_PRAM_NAME = "stringParam";
    private static final String INNER_POJO_PARAM_NAME = "innerPojoParam";
    private static final String MAP_PARAM_NAME = "mapParam";
    private static final String LIST_PARAM_NAME = "listParam";
    private static final String COMPLEX_MAP_PARAM_NAME = "complexMapParam";
    private static final String COMPLEX_LIST_PARAM_NAME = "complexListParam";

    @Before
    public void initApp() throws Exception {
        this.applicationModel = this.loadApplicationModel();
    }

    protected String getConfigFile() {
        return "comparison-config.xml";
    }

    private ParameterValue declareInnerPojo() {
        return ParameterObjectValue.builder().withParameter(INT_PARAM_NAME, "0").withParameter(STRING_PRAM_NAME, "zero").withParameter(LIST_PARAM_NAME, (ParameterValue)ParameterListValue.builder().withValue("zero").withValue("one").withValue("two").build()).withParameter(MAP_PARAM_NAME, (ParameterValue)ParameterObjectValue.builder().withParameter("0", "zero").withParameter("1", "one").withParameter("2", "two").build()).build();
    }

    private void validateInnerPojo(DslElementModel<?> innerPojoModel) {
        MatcherAssert.assertThat((Object)innerPojoModel.getContainedElements(), (Matcher)IsCollectionWithSize.hasSize((int)4));
        DslElementModel intParam = this.getElement(INT_PARAM_NAME, innerPojoModel.getContainedElements());
        MatcherAssert.assertThat(intParam.getValue().get(), (Matcher)Is.is((Object)"0"));
        DslElementModel stringParam = this.getElement(STRING_PRAM_NAME, innerPojoModel.getContainedElements());
        MatcherAssert.assertThat(stringParam.getValue().get(), (Matcher)Is.is((Object)"zero"));
        DslElementModel listParam = this.getElement(LIST_PARAM_NAME, innerPojoModel.getContainedElements());
        MatcherAssert.assertThat((Object)listParam.getContainedElements(), (Matcher)IsCollectionWithSize.hasSize((int)3));
        this.validateListEntry((DslElementModel)listParam.getContainedElements().get(0), "zero");
        this.validateListEntry((DslElementModel)listParam.getContainedElements().get(1), "one");
        this.validateListEntry((DslElementModel)listParam.getContainedElements().get(2), "two");
        DslElementModel mapParam = this.getElement(MAP_PARAM_NAME, innerPojoModel.getContainedElements());
        MatcherAssert.assertThat((Object)mapParam.getContainedElements(), (Matcher)IsCollectionWithSize.hasSize((int)3));
        this.validateMapEntry((DslElementModel)mapParam.getContainedElements().get(0), "0", v -> MatcherAssert.assertThat(v.getValue().get(), (Matcher)Is.is((Object)"zero")));
        this.validateMapEntry((DslElementModel)mapParam.getContainedElements().get(1), "1", v -> MatcherAssert.assertThat(v.getValue().get(), (Matcher)Is.is((Object)"one")));
        this.validateMapEntry((DslElementModel)mapParam.getContainedElements().get(2), "2", v -> MatcherAssert.assertThat(v.getValue().get(), (Matcher)Is.is((Object)"two")));
    }

    private DslElementModel getElement(String attributeName, List<DslElementModel> allElements) {
        return allElements.stream().filter(e -> e.getDsl().getAttributeName().equals(attributeName)).findAny().get();
    }

    private void validateListEntry(DslElementModel<?> listEntry, String expectedValue) {
        MatcherAssert.assertThat((Object)listEntry.getContainedElements(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        DslElementModel valueElement = (DslElementModel)listEntry.getContainedElements().get(0);
        MatcherAssert.assertThat((Object)valueElement.getDsl().getAttributeName(), (Matcher)Is.is((Object)"value"));
        MatcherAssert.assertThat(valueElement.getValue().get(), (Matcher)Is.is((Object)expectedValue));
    }

    private void validateMapEntry(DslElementModel<?> mapEntry, String expectedKey, Consumer<DslElementModel> valueValidator) {
        MatcherAssert.assertThat((Object)mapEntry.getContainedElements(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        DslElementModel keyElement = (DslElementModel)mapEntry.getContainedElements().get(0);
        DslElementModel valueElement = (DslElementModel)mapEntry.getContainedElements().get(1);
        MatcherAssert.assertThat((Object)keyElement.getDsl().getAttributeName(), (Matcher)Is.is((Object)"key"));
        MatcherAssert.assertThat((Object)valueElement.getDsl().getAttributeName(), (Matcher)Is.is((Object)"value"));
        MatcherAssert.assertThat(keyElement.getValue().get(), (Matcher)Is.is((Object)expectedKey));
        valueValidator.accept(valueElement);
    }

    private void validateDsl(DslElementModel<OperationModel> dslElementModel) {
        MatcherAssert.assertThat((Object)((OperationModel)dslElementModel.getModel()).getName(), (Matcher)Is.is((Object)OPERATION_NAME));
        MatcherAssert.assertThat((String)dslElementModel.getContainedElements().toString(), (Object)dslElementModel.getContainedElements(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        DslElementModel complexActingParameterModel = (DslElementModel)dslElementModel.getContainedElements().get(0);
        MatcherAssert.assertThat((Object)((ParameterModel)complexActingParameterModel.getModel()).getName(), (Matcher)Is.is((Object)COMPLEX_ACTING_PARAMETER_NAME));
        MatcherAssert.assertThat((String)complexActingParameterModel.getContainedElements().toString(), (Object)complexActingParameterModel.getContainedElements(), (Matcher)IsCollectionWithSize.hasSize((int)7));
        DslElementModel innerPojo = this.getElement(INNER_POJO_PARAM_NAME, complexActingParameterModel.getContainedElements());
        this.validateInnerPojo(innerPojo);
        DslElementModel intParam = this.getElement(INT_PARAM_NAME, complexActingParameterModel.getContainedElements());
        MatcherAssert.assertThat(intParam.getValue().get(), (Matcher)Is.is((Object)"0"));
        DslElementModel stringParam = this.getElement(STRING_PRAM_NAME, complexActingParameterModel.getContainedElements());
        MatcherAssert.assertThat(stringParam.getValue().get(), (Matcher)Is.is((Object)"zero"));
        DslElementModel complexMap = this.getElement(COMPLEX_MAP_PARAM_NAME, complexActingParameterModel.getContainedElements());
        MatcherAssert.assertThat((Object)complexMap.getContainedElements(), (Matcher)IsCollectionWithSize.hasSize((int)2));
        this.validateMapEntry((DslElementModel)complexMap.getContainedElements().get(0), "0", this::validateInnerPojo);
        this.validateMapEntry((DslElementModel)complexMap.getContainedElements().get(1), "1", this::validateInnerPojo);
        DslElementModel complexList = this.getElement(COMPLEX_LIST_PARAM_NAME, complexActingParameterModel.getContainedElements());
        MatcherAssert.assertThat((Object)complexList.getContainedElements(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        complexList.getContainedElements().forEach(this::validateInnerPojo);
        DslElementModel listParam = this.getElement(LIST_PARAM_NAME, complexActingParameterModel.getContainedElements());
        MatcherAssert.assertThat((Object)listParam.getContainedElements(), (Matcher)IsCollectionWithSize.hasSize((int)3));
        this.validateListEntry((DslElementModel)listParam.getContainedElements().get(0), "zero");
        this.validateListEntry((DslElementModel)listParam.getContainedElements().get(1), "one");
        this.validateListEntry((DslElementModel)listParam.getContainedElements().get(2), "two");
        DslElementModel mapParam = this.getElement(MAP_PARAM_NAME, complexActingParameterModel.getContainedElements());
        MatcherAssert.assertThat((Object)mapParam.getContainedElements(), (Matcher)IsCollectionWithSize.hasSize((int)3));
        this.validateMapEntry((DslElementModel)mapParam.getContainedElements().get(0), "0", v -> MatcherAssert.assertThat(v.getValue().get(), (Matcher)Is.is((Object)"zero")));
        this.validateMapEntry((DslElementModel)mapParam.getContainedElements().get(1), "1", v -> MatcherAssert.assertThat(v.getValue().get(), (Matcher)Is.is((Object)"one")));
        this.validateMapEntry((DslElementModel)mapParam.getContainedElements().get(2), "2", v -> MatcherAssert.assertThat(v.getValue().get(), (Matcher)Is.is((Object)"two")));
    }

    @Test
    public void compareModels() {
        ElementDeclarer values = ElementDeclarer.forExtension((String)"Values");
        ParameterObjectValue complexParameterValue = ParameterObjectValue.builder().withParameter(COMPLEX_LIST_PARAM_NAME, (ParameterValue)ParameterListValue.builder().withValue(this.declareInnerPojo()).build()).withParameter(COMPLEX_MAP_PARAM_NAME, (ParameterValue)ParameterObjectValue.builder().withParameter("0", this.declareInnerPojo()).withParameter("1", this.declareInnerPojo()).build()).withParameter(INNER_POJO_PARAM_NAME, this.declareInnerPojo()).withParameter(INT_PARAM_NAME, "0").withParameter(STRING_PRAM_NAME, "zero").withParameter(LIST_PARAM_NAME, (ParameterValue)ParameterListValue.builder().withValue("zero").withValue("one").withValue("two").build()).withParameter(MAP_PARAM_NAME, (ParameterValue)ParameterObjectValue.builder().withParameter("0", "zero").withParameter("1", "one").withParameter("2", "two").build()).build();
        OperationElementDeclaration complexActingParameterOperation = (OperationElementDeclaration)((OperationElementDeclarer)values.newOperation(OPERATION_NAME).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter(COMPLEX_ACTING_PARAMETER_NAME, (ParameterValue)complexParameterValue).getDeclaration())).getDeclaration();
        ComponentAst flow = this.getAppElement(this.applicationModel, "testFlow");
        ComponentAst operationAst = (ComponentAst)flow.directChildrenStream().findFirst().get();
        DslElementModel astDsl = this.resolve(operationAst);
        DslElementModel declarationDsl = this.resolve((ElementDeclaration)complexActingParameterOperation);
        this.validateDsl(declarationDsl);
        this.validateDsl(astDsl);
    }

    @Test
    public void repeatedElementsAreNotPopulated() {
        ElementDeclarer values = ElementDeclarer.forExtension((String)"Values");
        ParameterObjectValue complexParameterValue = ParameterObjectValue.builder().withParameter(LIST_PARAM_NAME, (ParameterValue)ParameterListValue.builder().withValue("one").withValue("one").withValue("one").build()).build();
        OperationElementDeclaration complexActingParameterOperation = (OperationElementDeclaration)((OperationElementDeclarer)values.newOperation(OPERATION_NAME).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter(COMPLEX_ACTING_PARAMETER_NAME, (ParameterValue)complexParameterValue).getDeclaration())).getDeclaration();
        DslElementModel declarationDsl = this.resolve((ElementDeclaration)complexActingParameterOperation);
        MatcherAssert.assertThat((Object)declarationDsl.getContainedElements(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        DslElementModel complexActingParameter = (DslElementModel)declarationDsl.getContainedElements().get(0);
        MatcherAssert.assertThat((Object)complexActingParameter.getDsl().getAttributeName(), (Matcher)Is.is((Object)COMPLEX_ACTING_PARAMETER_NAME));
        MatcherAssert.assertThat((Object)complexActingParameter.getContainedElements(), (Matcher)IsCollectionWithSize.hasSize((int)1));
        DslElementModel listParam = (DslElementModel)complexActingParameter.getContainedElements().get(0);
        MatcherAssert.assertThat((Object)listParam.getDsl().getAttributeName(), (Matcher)Is.is((Object)LIST_PARAM_NAME));
        MatcherAssert.assertThat((String)listParam.getContainedElements().toString(), (Object)listParam.getContainedElements(), (Matcher)IsCollectionWithSize.hasSize((int)3));
    }
}

