/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.test.config.ast;

import static org.hamcrest.Matchers.is;
import static org.hamcrest.collection.IsCollectionWithSize.hasSize;
import static org.junit.Assert.assertThat;
import static org.mule.runtime.core.api.extension.MuleExtensionModelProvider.MULE_NAME;
import static org.mule.test.allure.AllureConstants.ArtifactAst.ARTIFACT_AST;

import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.tck.junit4.AbstractMuleContextTestCase;

import java.util.Set;

import org.junit.Test;

import io.qameta.allure.Feature;

@Feature(ARTIFACT_AST)
public class MuleAstUtilsTestCase extends AbstractMuleContextTestCase {

  @Test
  public void emptyArtifactHasCoreExtModelDependency() {
    final Set<ExtensionModel> dependencies = MuleAstUtils.emptyArtifact().dependencies();

    assertThat(dependencies, hasSize(1));
    assertThat(dependencies.iterator().next().getName(), is(MULE_NAME));
  }
}
