/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config.ast;

import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Story;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Singleton;
import org.codejargon.feather.Feather;
import org.codejargon.feather.Provides;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.validation.ArtifactAstValidator;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResult;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.module.artifact.activation.api.extension.discovery.ExtensionModelDiscoverer;
import org.mule.runtime.module.extension.internal.manager.DefaultExtensionManager;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.weave.v2.el.WeaveDefaultExpressionLanguageFactoryService;

@Features(value={@Feature(value="Mule Artifact AST"), @Feature(value="Expression Language")})
@Story(value="Mule DSL Validations")
public class ArtifactAstValidationsTestCase
extends AbstractMuleContextTestCase {
    private static Set<ExtensionModel> runtimeExtensionModels;
    private DefaultExtensionManager extensionManager;

    @BeforeClass
    public static void beforeClass() throws Exception {
        runtimeExtensionModels = ExtensionModelDiscoverer.discoverRuntimeExtensionModels();
    }

    @Before
    public void before() throws Exception {
        this.extensionManager = new DefaultExtensionManager();
        muleContext.setExtensionManager((ExtensionManager)this.extensionManager);
        LifecycleUtils.initialiseIfNeeded((Object)this.extensionManager, (MuleContext)muleContext);
    }

    @Test
    public void astValidationsWithBaseRegistryOutsideRuntime() throws ConfigurationException {
        ArtifactAst ast = this.buildArtifactAst("expression-language-illegal-syntax-dw-config.xml");
        List<ValidationResultItem> errors = this.doValidate(ast);
        MatcherAssert.assertThat(errors, (Matcher)IsCollectionWithSize.hasSize((int)1));
        ValidationResultItem error = errors.get(0);
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.equalTo((Object)"Missing Expression"));
    }

    protected List<ValidationResultItem> doValidate(ArtifactAst ast) throws ConfigurationException {
        Feather feather = Feather.with((Object[])new Object[]{new BaseRegistryForValidationsModule()});
        ArtifactAstValidator astValidator = MuleAstUtils.validatorBuilder().withValidationEnricher(arg_0 -> ((Feather)feather).injectFields(arg_0)).build();
        ValidationResult result = astValidator.validate(ast);
        List<ValidationResultItem> errors = result.getItems().stream().filter(v -> v.getValidation().getLevel().equals((Object)Validation.Level.ERROR)).collect(Collectors.toList());
        return errors;
    }

    protected ArtifactAst buildArtifactAst(String configFile) {
        return AstXmlParser.builder().withExtensionModels((Collection)muleContext.getExtensionManager().getExtensions()).withExtensionModels(runtimeExtensionModels).withSchemaValidationsDisabled().build().parse(new URL[]{((Object)((Object)this)).getClass().getClassLoader().getResource("ast/" + configFile)});
    }

    public class BaseRegistryForValidationsModule {
        @Provides
        @Singleton
        public ExpressionLanguage expressionLanguage() {
            return new WeaveDefaultExpressionLanguageFactoryService(null).create();
        }
    }
}

