/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.extension.dsl;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ConfigurationElementDeclaration;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.app.declaration.api.OperationElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterGroupElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.SourceElementDeclaration;
import org.mule.runtime.app.declaration.api.fluent.ConfigurationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConnectionElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.OperationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.SourceElementDeclarer;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.runtime.metadata.api.dsl.DslElementModel;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.extension.dsl.AbstractElementModelTestCase;

public class DeclarationBasedElementModelFactoryTestCase
extends AbstractElementModelTestCase {
    @Rule
    public DynamicPort port = new DynamicPort("port");
    @Rule
    public DynamicPort otherPort = new DynamicPort("otherPort");
    private ConfigurationElementDeclaration dbConfig;
    private ConfigurationElementDeclaration listenerConfig;
    private ConfigurationElementDeclaration requestConfig;
    private OperationElementDeclaration request;
    private SourceElementDeclaration listener;
    private OperationElementDeclaration bulkInsert;
    private ConnectionElementDeclaration derbyConnection;
    private ConnectionElementDeclaration listenerConnection;
    private ConnectionElementDeclaration requestConnection;

    protected String getConfigFile() {
        return "integration-multi-config-dsl-app.xml";
    }

    @Before
    public void createAppDeclaration() {
        ElementDeclarer db = ElementDeclarer.forExtension((String)"Database");
        ElementDeclarer http = ElementDeclarer.forExtension((String)"HTTP");
        this.derbyConnection = (ConnectionElementDeclaration)((ConnectionElementDeclarer)db.newConnection("derby").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Connection").withParameter("database", "target/muleEmbeddedDB").withParameter("create", "true").getDeclaration())).getDeclaration();
        this.dbConfig = (ConfigurationElementDeclaration)db.newConfiguration("config").withRefName("dbConfig").withConnection(this.derbyConnection).getDeclaration();
        this.listenerConnection = (ConnectionElementDeclaration)((ConnectionElementDeclarer)((ConnectionElementDeclarer)http.newConnection("listener").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("tlsContext", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("key-store", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("path", "ssltest-keystore.jks").withParameter("password", "changeit").withParameter("keyPassword", "changeit").build()).build()).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Connection").withParameter("host", "localhost").withParameter("port", "${port}").withParameter("protocol", "HTTPS").getDeclaration())).getDeclaration();
        this.listenerConfig = (ConfigurationElementDeclaration)((ConfigurationElementDeclarer)http.newConfiguration("listenerConfig").withRefName("httpListener").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("basePath", "/").getDeclaration())).withConnection(this.listenerConnection).getDeclaration();
        this.requestConnection = (ConnectionElementDeclaration)((ConnectionElementDeclarer)((ConnectionElementDeclarer)http.newConnection("request").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("authentication", (ParameterValue)ElementDeclarer.newObjectValue().ofType("org.mule.extension.http.api.request.authentication.BasicAuthentication").withParameter("username", "user").withParameter("password", "pass").build()).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Connection").withParameter("host", "localhost").withParameter("port", "${otherPort}").withParameter("clientSocketProperties", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("connectionTimeout", "1000").withParameter("keepAlive", "true").withParameter("receiveBufferSize", "1024").withParameter("sendBufferSize", "1024").withParameter("clientTimeout", "1000").withParameter("linger", "1000").build()).getDeclaration())).getDeclaration();
        this.requestConfig = (ConfigurationElementDeclaration)http.newConfiguration("requestConfig").withRefName("httpRequester").withConnection(this.requestConnection).getDeclaration();
        this.listener = (SourceElementDeclaration)((SourceElementDeclarer)((SourceElementDeclarer)((SourceElementDeclarer)((SourceElementDeclarer)http.newSource("listener").withConfig("httpListener")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("path", "testBuilder").withParameter("redeliveryPolicy", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("maxRedeliveryCount", "2").withParameter("useSecureHash", "true").build()).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Connection").withParameter("reconnectionStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("reconnect").withParameter("blocking", "true").withParameter("count", "1").withParameter("frequency", "0").build()).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Response").withParameter("headers", "#[{{'content-type' : 'text/plain'}}]").getDeclaration())).getDeclaration();
        this.bulkInsert = (OperationElementDeclaration)((OperationElementDeclarer)db.newOperation("bulkInsert").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Query").withParameter("sql", "INSERT INTO PLANET(POSITION, NAME) VALUES (:position, :name)").withParameter("parameterTypes", (ParameterValue)ElementDeclarer.newListValue().withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("key", "name").withParameter("type", "VARCHAR").build()).withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("key", "position").withParameter("type", "INTEGER").build()).build()).getDeclaration())).getDeclaration();
        this.request = (OperationElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)((OperationElementDeclarer)http.newOperation("request").withConfig("httpRequester")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"URI Settings").withParameter("path", "/nested").getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("method", "POST").getDeclaration())).getDeclaration();
    }

    @Test
    public void resolveSimpleConfigWithFlatConnection() throws Exception {
        DslElementModel configElement = this.resolve((ElementDeclaration)this.dbConfig);
        this.assertElementName(configElement, "config");
        DslElementModel connectionElement = this.getChild(configElement, this.derbyConnection.getName());
        this.validateFlatConnection(connectionElement);
        MatcherAssert.assertThat((Object)configElement.getConfiguration().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)configElement.getIdentifier().isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)configElement.findElement(this.newIdentifier("oracle-connection", "db")).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void resolveFlatConnectionDirectly() {
        this.validateFlatConnection(this.resolve((ElementDeclaration)this.derbyConnection));
    }

    private void validateFlatConnection(DslElementModel<ConnectionProviderModel> connectionElement) {
        this.assertElementName(connectionElement, "derby-connection");
        this.assertHasParameter((ParameterizedModel)connectionElement.getModel(), "database");
        this.assertAttributeIsPresent(connectionElement, "database");
        this.assertHasParameter((ParameterizedModel)connectionElement.getModel(), "create");
        this.assertAttributeIsPresent(connectionElement, "create");
        MatcherAssert.assertThat((Object)connectionElement.findElement(this.newIdentifier("connection-properties", "db")).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void resolveConnectionNoExtraParameters() throws Exception {
        DslElementModel configElement = this.resolve((ElementDeclaration)this.dbConfig);
        DslElementModel connectionElement = this.getChild(configElement, this.derbyConnection.getName());
        this.validateConnectionNoExtraParameters(connectionElement);
    }

    @Test
    public void resolveConnectionNoExtraParametersDirectly() {
        this.validateConnectionNoExtraParameters(this.resolve((ElementDeclaration)this.derbyConnection));
    }

    private void validateConnectionNoExtraParameters(DslElementModel<ConnectionProviderModel> connectionElement) {
        this.assertHasParameter((ParameterizedModel)connectionElement.getModel(), "columnTypes");
        MatcherAssert.assertThat((Object)connectionElement.findElement("columnTypes").isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void resolveConfigNoExtraContainedElements() throws Exception {
        DslElementModel configElement = this.resolve((ElementDeclaration)this.listenerConfig);
        MatcherAssert.assertThat((Object)configElement.findElement(this.newIdentifier("request-connection", "http")).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void resolveConfigWithParameters() throws Exception {
        DslElementModel configElement = this.resolve((ElementDeclaration)this.listenerConfig);
        this.assertElementName(configElement, "listener-config");
        this.assertHasParameter((ParameterizedModel)configElement.getModel(), "basePath");
        this.assertAttributeIsPresent(configElement, "basePath");
        DslElementModel connectionElement = this.getChild(configElement, this.listenerConnection.getName());
        this.validateSimpleListenerConnection(connectionElement);
        MatcherAssert.assertThat((Object)configElement.findElement(this.newIdentifier("request", "http")).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void resolveConnectionWithParametersDirectly() {
        this.validateSimpleListenerConnection(this.resolve((ElementDeclaration)this.listenerConnection));
    }

    private void validateSimpleListenerConnection(DslElementModel<ConnectionProviderModel> connectionElement) {
        this.assertElementName(connectionElement, "listener-connection");
        this.assertAttributeIsPresent(connectionElement, "host");
        this.assertAttributeIsPresent(connectionElement, "port");
    }

    @Test
    public void resolveConnectionWithSubtypes() throws Exception {
        DslElementModel configElement = this.resolve((ElementDeclaration)this.requestConfig);
        this.assertElementName(configElement, "request-config");
        DslElementModel connectionElement = this.getChild(configElement, this.requestConnection.getName());
        this.validateConnectionWithSubtypes(connectionElement);
        MatcherAssert.assertThat((Object)configElement.findElement(this.newIdentifier("listener", "http")).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void resolveConnectionWithSubtypesDirectly() throws Exception {
        this.validateConnectionWithSubtypes(this.resolve((ElementDeclaration)this.requestConnection));
    }

    private void validateConnectionWithSubtypes(DslElementModel<ConnectionProviderModel> connectionElement) {
        this.assertElementName(connectionElement, "request-connection");
        this.assertHasParameter((ParameterizedModel)connectionElement.getModel(), "host");
        this.assertAttributeIsPresent(connectionElement, "host");
        this.assertHasParameter((ParameterizedModel)connectionElement.getModel(), "port");
        this.assertAttributeIsPresent(connectionElement, "port");
        DslElementModel authenticationWrapperElement = this.getChild(connectionElement, "authentication");
        this.assertElementName(authenticationWrapperElement, "authentication");
        DslElementModel basicAuthElement = this.getChild(connectionElement, this.newIdentifier("basic-authentication", "http"));
        this.assertElementName(basicAuthElement, "basic-authentication");
        MatcherAssert.assertThat((Object)basicAuthElement.getDsl().isWrapped(), (Matcher)Matchers.is((Object)false));
        MatcherAssert.assertThat((Object)basicAuthElement.getDsl().supportsAttributeDeclaration(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void resolveConnectionWithImportedTypes() throws Exception {
        DslElementModel configElement = this.resolve((ElementDeclaration)this.requestConfig);
        this.assertElementName(configElement, "request-config");
        DslElementModel connectionElement = this.getChild(configElement, this.requestConnection.getName());
        this.validateConnectionWithImportedTypes(connectionElement);
        MatcherAssert.assertThat((Object)configElement.findElement(this.newIdentifier("listener", "db")).isPresent(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void resolveConnectionWithImportedTypesDirectly() {
        this.validateConnectionWithImportedTypes(this.resolve((ElementDeclaration)this.requestConnection));
    }

    private void validateConnectionWithImportedTypes(DslElementModel<ConnectionProviderModel> connectionElement) {
        this.assertElementName(connectionElement, "request-connection");
        this.assertHasParameter((ParameterizedModel)connectionElement.getModel(), "host");
        this.assertAttributeIsPresent(connectionElement, "host");
        this.assertHasParameter((ParameterizedModel)connectionElement.getModel(), "port");
        this.assertAttributeIsPresent(connectionElement, "port");
        DslElementModel wrapperElement = this.getChild(connectionElement, "clientSocketProperties");
        this.assertElementName(wrapperElement, "client-socket-properties");
        DslElementModel propertiesElement = this.getChild(wrapperElement, this.newIdentifier("tcp-client-socket-properties", "sockets"));
        this.assertElementName(propertiesElement, "tcp-client-socket-properties");
        MatcherAssert.assertThat((Object)propertiesElement.getDsl().isWrapped(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)propertiesElement.getDsl().supportsAttributeDeclaration(), (Matcher)Matchers.is((Object)false));
    }

    @Test
    public void flowElementsResolution() throws Exception {
        this.assertListenerSourceWithMessageBuilder((ComponentElementDeclaration)this.listener);
        this.assertBulkInsertOperationWithNestedList((ComponentElementDeclaration)this.bulkInsert);
        this.assertRequestOperationWithFlatParameters((ComponentElementDeclaration)this.request);
    }

    private void assertRequestOperationWithFlatParameters(ComponentElementDeclaration requester) {
        DslElementModel requesterElement = this.resolve((ElementDeclaration)requester);
        this.assertHasParameter((ParameterizedModel)requesterElement.getModel(), "path");
        MatcherAssert.assertThat((Object)requesterElement.findElement("path").isPresent(), (Matcher)Matchers.is((Object)true));
        this.assertHasParameter((ParameterizedModel)requesterElement.getModel(), "method");
        MatcherAssert.assertThat((Object)requesterElement.findElement("method").isPresent(), (Matcher)Matchers.is((Object)true));
    }

    private void assertBulkInsertOperationWithNestedList(ComponentElementDeclaration dbInsert) {
        DslElementModel dbElement = this.resolve((ElementDeclaration)dbInsert);
        DslElementModel sqlElement = this.getChild(dbElement, "sql");
        this.assertElementName(sqlElement, "sql");
        DslElementModel parameterTypesElement = this.getChild(dbElement, "parameterTypes");
        this.assertElementName(parameterTypesElement, "parameter-types");
        ComponentConfiguration parameterOne = (ComponentConfiguration)((ComponentConfiguration)parameterTypesElement.getConfiguration().get()).getNestedComponents().get(0);
        MatcherAssert.assertThat(parameterOne.getParameters().get("key"), (Matcher)Matchers.is((Object)"name"));
        DslElementModel elementOne = (DslElementModel)parameterTypesElement.getContainedElements().get(0);
        this.assertElementName(elementOne, parameterOne.getIdentifier().getName());
        ComponentConfiguration parameterTwo = (ComponentConfiguration)((ComponentConfiguration)parameterTypesElement.getConfiguration().get()).getNestedComponents().get(1);
        MatcherAssert.assertThat(parameterTwo.getParameters().get("key"), (Matcher)Matchers.is((Object)"position"));
        DslElementModel elementTwo = (DslElementModel)parameterTypesElement.getContainedElements().get(1);
        this.assertElementName(elementTwo, parameterTwo.getIdentifier().getName());
    }

    private void assertListenerSourceWithMessageBuilder(ComponentElementDeclaration listener) {
        DslElementModel listenerElement = this.resolve((ElementDeclaration)listener);
        this.assertHasParameter((ParameterizedModel)listenerElement.getModel(), "path");
        DslElementModel responseBuilderElement = this.getChild(listenerElement, "Response");
        this.assertElementName(responseBuilderElement, "response");
        MatcherAssert.assertThat((Object)responseBuilderElement.getDsl().getChild("headers").isPresent(), (Matcher)Matchers.is((Object)true));
    }
}

