/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config.ast;

import io.qameta.allure.Feature;
import io.qameta.allure.Story;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.serialization.ArtifactAstDeserializer;
import org.mule.runtime.ast.api.serialization.ArtifactAstSerializer;
import org.mule.runtime.ast.api.serialization.ArtifactAstSerializerProvider;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.core.api.extension.provider.RuntimeExtensionModelProvider;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaExtensionModelLoader;
import org.mule.runtime.module.extension.internal.manager.DefaultExtensionManager;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.test.runner.infrastructure.ExtensionsTestInfrastructureDiscoverer;

@Feature(value="Mule Artifact AST")
@Story(value="Parameter AST resolution")
@RunWith(value=Parameterized.class)
public abstract class BaseParameterAstTestCase
extends AbstractMuleContextTestCase {
    private static List<ExtensionModel> runtimeExtensionModels;
    private final boolean serialize;
    private final boolean populateGenerationInformation;
    private DefaultExtensionManager extensionManager;

    @BeforeClass
    public static void beforeClass() throws Exception {
        runtimeExtensionModels = new ArrayList<ExtensionModel>(RuntimeExtensionModelProvider.discoverRuntimeExtensionModels());
    }

    @Parameterized.Parameters(name="serialize: {0}; populateGenerationInformation: {1}")
    public static List<Object[]> params() {
        return Arrays.asList({false, true}, {true, false}, {true, true});
    }

    public BaseParameterAstTestCase(boolean serialize, boolean populateGenerationInformation) {
        this.serialize = serialize;
        this.populateGenerationInformation = populateGenerationInformation;
    }

    @Before
    public void before() throws Exception {
        this.extensionManager = new DefaultExtensionManager();
        muleContext.setExtensionManager((ExtensionManager)this.extensionManager);
        LifecycleUtils.initialiseIfNeeded((Object)this.extensionManager, (MuleContext)muleContext);
    }

    protected ArtifactAst buildArtifactAst(String configFile, Class ... extensions) {
        ExtensionsTestInfrastructureDiscoverer discoverer = new ExtensionsTestInfrastructureDiscoverer((ExtensionManager)this.extensionManager);
        DefaultJavaExtensionModelLoader extensionModelLoader = new DefaultJavaExtensionModelLoader();
        HashSet<ExtensionModel> dependencies = new HashSet<ExtensionModel>(Collections.singleton(MuleExtensionModelProvider.getExtensionModel()));
        for (Class annotatedClass : extensions) {
            dependencies.add(discoverer.discoverExtension(annotatedClass, (ExtensionModelLoader)extensionModelLoader, DslResolvingContext.getDefault(dependencies)));
        }
        ArtifactAst parsedAst = AstXmlParser.builder().withExtensionModels((Collection)muleContext.getExtensionManager().getExtensions()).withExtensionModels(runtimeExtensionModels).withSchemaValidationsDisabled().build().parse(new URL[]{((Object)((Object)this)).getClass().getClassLoader().getResource("ast/" + configFile)});
        if (this.isSerialize()) {
            try {
                return this.serializeAndDeserialize(parsedAst);
            }
            catch (IOException e) {
                Assert.fail((String)e.getMessage());
                return null;
            }
        }
        return parsedAst;
    }

    protected Optional<ComponentAst> findComponent(Stream<ComponentAst> stream, String componentIdentifier, String componentId) {
        return this.findComponent(stream, ComponentIdentifier.buildFromStringRepresentation((String)componentIdentifier), componentId);
    }

    protected Optional<ComponentAst> findComponent(Stream<ComponentAst> stream, ComponentIdentifier identifier, String componentId) {
        return stream.filter(componentAst -> identifier.equals(componentAst.getIdentifier()) && componentId.equals(componentAst.getComponentId().orElse(null))).findFirst();
    }

    protected Optional<ComponentAst> findComponent(Stream<ComponentAst> stream, String componentIdentifier) {
        return this.findComponent(stream, ComponentIdentifier.buildFromStringRepresentation((String)componentIdentifier));
    }

    protected Optional<ComponentAst> findComponent(Stream<ComponentAst> stream, ComponentIdentifier identifier) {
        return stream.filter(componentAst -> identifier.equals(componentAst.getIdentifier())).findFirst();
    }

    protected Optional<ComponentAst> findComponentByComponentId(Stream<ComponentAst> stream, String componentId) {
        return stream.filter(c -> componentId.equals(c.getComponentId().orElse(null))).findFirst();
    }

    private ArtifactAst serializeAndDeserialize(ArtifactAst artifactAst) throws IOException {
        ArtifactAstSerializer jsonArtifactAstSerializer = new ArtifactAstSerializerProvider().getSerializer("JSON", "1.0");
        InputStream inputStream = jsonArtifactAstSerializer.serialize(artifactAst);
        ArtifactAstDeserializer defaultArtifactAstDeserializer = new ArtifactAstSerializerProvider().getDeserializer(this.isPopulateGenerationInformation());
        ArtifactAst deserializedArtifactAst = defaultArtifactAstDeserializer.deserialize(inputStream, name -> artifactAst.dependencies().stream().filter(x -> x.getName().equals(name)).findFirst().orElse(null));
        return deserializedArtifactAst;
    }

    public boolean isSerialize() {
        return this.serialize;
    }

    public boolean isPopulateGenerationInformation() {
        return this.populateGenerationInformation;
    }
}

