/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config.ast;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import io.qameta.allure.Feature;
import io.qameta.allure.Features;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.validation.ArtifactAstValidator;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResult;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.extension.provider.RuntimeExtensionModelProvider;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.module.extension.internal.manager.DefaultExtensionManager;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.test.config.ast.BasicModule;

@Features(value={@Feature(value="Mule Artifact AST"), @Feature(value="Expression Language")})
@Story(value="Mule DSL Validations")
public class ArtifactAstValidationsTestCase
extends AbstractMuleContextTestCase {
    private Injector injector;
    private static Set<ExtensionModel> runtimeExtensionModels;
    private DefaultExtensionManager extensionManager;

    @BeforeClass
    public static void beforeClass() {
        runtimeExtensionModels = RuntimeExtensionModelProvider.discoverRuntimeExtensionModels();
    }

    @Before
    public void before() throws Exception {
        this.extensionManager = new DefaultExtensionManager();
        muleContext.setExtensionManager((ExtensionManager)this.extensionManager);
        LifecycleUtils.initialiseIfNeeded((Object)this.extensionManager, (MuleContext)muleContext);
        this.injector = Guice.createInjector((Module[])new Module[]{new BasicModule()});
    }

    @Test
    @Issue(value="W-12637937")
    public void astValidationsWithBaseRegistryOutsideRuntime() throws ConfigurationException {
        ArtifactAst ast = this.buildArtifactAst("expression-language-illegal-syntax-dw-config.xml");
        List<ValidationResultItem> errors = this.doValidate(ast);
        MatcherAssert.assertThat(errors, (Matcher)IsCollectionWithSize.hasSize((int)1));
        ValidationResultItem error = errors.get(0);
        MatcherAssert.assertThat((Object)error.getMessage(), (Matcher)Matchers.equalTo((Object)"Missing Expression"));
    }

    protected List<ValidationResultItem> doValidate(ArtifactAst ast) throws ConfigurationException {
        ArtifactAstValidator astValidator = MuleAstUtils.validatorBuilder().withValidationEnricher(arg_0 -> ((Injector)this.injector).injectMembers(arg_0)).build();
        ValidationResult result = astValidator.validate(ast);
        List<ValidationResultItem> errors = result.getItems().stream().filter(v -> v.getValidation().getLevel().equals((Object)Validation.Level.ERROR)).collect(Collectors.toList());
        return errors;
    }

    protected ArtifactAst buildArtifactAst(String configFile) {
        return AstXmlParser.builder().withExtensionModels((Collection)muleContext.getExtensionManager().getExtensions()).withExtensionModels(runtimeExtensionModels).withSchemaValidationsDisabled().build().parse(new URL[]{((Object)((Object)this)).getClass().getClassLoader().getResource("ast/" + configFile)});
    }
}

