/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config.ast;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.io.FileMatchers;
import org.junit.After;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.mule.extension.db.internal.DbConnector;
import org.mule.extension.http.internal.temporary.HttpConnector;
import org.mule.extension.oauth2.OAuthExtension;
import org.mule.extension.socket.api.SocketsExtension;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.config.internal.context.ConnectionsDataExtractor;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.core.api.extension.provider.RuntimeExtensionModelProvider;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.module.extension.internal.loader.java.DefaultJavaExtensionModelLoader;
import org.mule.runtime.module.extension.internal.manager.DefaultExtensionManager;
import org.mule.tck.junit4.AbstractMuleContextTestCase;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.runner.infrastructure.ExtensionsTestInfrastructureDiscoverer;

public class ConnectionsDataExtractorTestCase
extends AbstractMuleContextTestCase {
    private static Set<ExtensionModel> runtimeExtensionModels;
    private DefaultExtensionManager extensionManager;
    @Rule
    public TemporaryFolder muleHome = new TemporaryFolder();
    @Rule
    public SystemProperty extractConnectionDataEnable = new SystemProperty("mule.extractConnectionData.enable", "true");

    @BeforeClass
    public static void beforeClass() {
        runtimeExtensionModels = RuntimeExtensionModelProvider.discoverRuntimeExtensionModels();
    }

    @Before
    public void before() throws Exception {
        this.extensionManager = new DefaultExtensionManager();
        muleContext.setExtensionManager((ExtensionManager)this.extensionManager);
        LifecycleUtils.initialiseIfNeeded((Object)this.extensionManager, (MuleContext)muleContext);
    }

    @Before
    public void setUpHome() {
        System.setProperty("mule.base", this.muleHome.getRoot().getAbsolutePath());
    }

    @After
    public void cleanUpHome() {
        System.clearProperty("mule.base");
    }

    @Test
    public void parametersTestHttpOauthProxyConfig() throws IOException {
        ArtifactAst ast = this.buildArtifactAst("parameters-test-http-oauth-proxy-config.xml", HttpConnector.class, SocketsExtension.class, OAuthExtension.class);
        new ConnectionsDataExtractor(ast).persist();
        File report = new File(this.muleHome.getRoot().getAbsolutePath(), ".mule/.introspection/connections_data_artifact.csv");
        MatcherAssert.assertThat((Object)report, (Matcher)FileMatchers.anExistingFile());
        String reportContent = new String(Files.readAllBytes(report.toPath()), StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)reportContent, (Matcher)Is.is((Object)("Component,Host,Port" + System.lineSeparator() + "\"httpRequestConfigWithOAuthProxyInline/connection(http:request-connection)\",\"localhost\",\"8081\"" + System.lineSeparator() + "\"httpRequestConfigWithOAuthProxyInline/connection/0/0/0/0(http:proxy)\",\"localhost\",\"8083\"" + System.lineSeparator() + "\"HTTP_Listener_config/connection(http:listener-connection)\",\"localhost\",\"8080\"" + System.lineSeparator() + "\"HTTP_Listener_config/1/0/0/0(http:origin)\",\"www.the-origin-of-time.com\",\"80\"" + System.lineSeparator() + "\"HTTP_Listener_config/1/0/0/1(http:origin)\",\"www.the-origin-of-life.com\",\"80\"" + System.lineSeparator() + "\"defaultHttpListenerConfig/connection(http:listener-connection)\",\"localhost\",\"8081\"" + System.lineSeparator() + "\"clientGlobalConfig/connection(http:request-connection)\",\"localhost\",\"8082\"" + System.lineSeparator())));
    }

    @Test
    public void dbWithSpringDatasource() throws IOException {
        ArtifactAst ast = this.buildArtifactAst("db-with-spring-datasource.xml", DbConnector.class);
        new ConnectionsDataExtractor(ast).persist();
        File report = new File(this.muleHome.getRoot().getAbsolutePath(), ".mule/.introspection/connections_data_artifact.csv");
        MatcherAssert.assertThat((Object)report, (Matcher)FileMatchers.anExistingFile());
        String reportContent = new String(Files.readAllBytes(report.toPath()), StandardCharsets.UTF_8);
        MatcherAssert.assertThat((Object)reportContent, (Matcher)Is.is((Object)("Component,Host,Port" + System.lineSeparator() + "\"pooledJdbcConfig/connection(db:data-source-connection)\",\"\",\"-1\"" + System.lineSeparator())));
    }

    protected ArtifactAst buildArtifactAst(String configFile, Class ... extensions) {
        ExtensionsTestInfrastructureDiscoverer discoverer = new ExtensionsTestInfrastructureDiscoverer((ExtensionManager)this.extensionManager);
        DefaultJavaExtensionModelLoader extensionModelLoader = new DefaultJavaExtensionModelLoader();
        HashSet<ExtensionModel> dependencies = new HashSet<ExtensionModel>(Collections.singleton(MuleExtensionModelProvider.getExtensionModel()));
        for (Class annotatedClass : extensions) {
            dependencies.add(discoverer.discoverExtension(annotatedClass, (ExtensionModelLoader)extensionModelLoader, DslResolvingContext.getDefault(dependencies)));
        }
        ArtifactAst parsedAst = AstXmlParser.builder().withExtensionModels((Collection)muleContext.getExtensionManager().getExtensions()).withExtensionModels(runtimeExtensionModels).withSchemaValidationsDisabled().build().parse(new URL[]{((Object)((Object)this)).getClass().getClassLoader().getResource("ast/" + configFile)});
        return parsedAst;
    }
}

