/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.extension.dsl;

import java.io.IOException;
import java.io.InputStream;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.security.SecurityException;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.ast.api.DependencyResolutionMode;
import org.mule.runtime.config.api.dsl.ArtifactDeclarationXmlSerializer;
import org.mule.runtime.core.api.security.AbstractSecurityProvider;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.extension.dsl.AbstractElementModelTestCase;

public class MuleModelsDeclarationSerializerTestCase
extends AbstractElementModelTestCase {
    @Rule
    public SystemProperty minimalDependencies = new SystemProperty("mule." + DependencyResolutionMode.class.getName(), DependencyResolutionMode.MINIMAL.name());
    private ArtifactDeclarationXmlSerializer serializer;

    protected String[] getConfigFiles() {
        return new String[0];
    }

    @Override
    @Before
    public void setup() throws Exception {
        super.setup();
        this.serializer = ArtifactDeclarationXmlSerializer.getDefault((DslResolvingContext)this.dslContext);
    }

    @Test
    public void loadAndSerializeAppWithParallelForEach() throws Exception {
        String appXmlFile = "app-with-parallel-foreach.xml";
        ArtifactDeclaration artifact = this.loadApplicationDeclaration(appXmlFile);
        this.assertApplicationArtifactSerialization(appXmlFile, artifact);
    }

    @Test
    public void loadAndSerializeAppWithAsync() throws Exception {
        String appXmlFile = "app-with-async.xml";
        ArtifactDeclaration artifact = this.loadApplicationDeclaration(appXmlFile);
        this.assertApplicationArtifactSerialization(appXmlFile, artifact);
    }

    @Test
    public void loadAndSerializeAppWithUntilSuccessful() throws Exception {
        String appXmlFile = "app-with-until-successful.xml";
        ArtifactDeclaration artifact = this.loadApplicationDeclaration(appXmlFile);
        this.assertApplicationArtifactSerialization(appXmlFile, artifact);
    }

    @Test
    public void loadAndSerializeAppWithTry() throws Exception {
        String appXmlFile = "app-with-try.xml";
        ArtifactDeclaration artifact = this.loadApplicationDeclaration(appXmlFile);
        this.assertApplicationArtifactSerialization(appXmlFile, artifact);
    }

    @Test
    public void loadAndSerializeAppWithErrorHandler() throws Exception {
        String appXmlFile = "app-with-error-handler.xml";
        ArtifactDeclaration artifact = this.loadApplicationDeclaration(appXmlFile);
        this.assertApplicationArtifactSerialization(appXmlFile, artifact);
    }

    @Test
    public void loadAndSerializeAppWithObject() throws Exception {
        String appXmlFile = "app-with-object.xml";
        ArtifactDeclaration artifact = this.loadApplicationDeclaration(appXmlFile);
        this.assertApplicationArtifactSerialization(appXmlFile, artifact);
    }

    @Test
    public void loadAndSerializeAppWithSecurityManager() throws Exception {
        String appXmlFile = "app-with-security-manager.xml";
        ArtifactDeclaration artifact = this.loadApplicationDeclaration(appXmlFile);
        this.assertApplicationArtifactSerialization(appXmlFile, artifact);
    }

    @Test
    public void loadAndSerializeAppWithChoice() throws Exception {
        String appXmlFile = "app-with-choice.xml";
        ArtifactDeclaration artifact = this.loadApplicationDeclaration(appXmlFile);
        this.assertApplicationArtifactSerialization(appXmlFile, artifact);
    }

    @Test
    public void loadAndSerializeAppWithForEach() throws Exception {
        String appXmlFile = "app-with-foreach.xml";
        ArtifactDeclaration artifact = this.loadApplicationDeclaration(appXmlFile);
        this.assertApplicationArtifactSerialization(appXmlFile, artifact);
    }

    @Test
    public void loadAndSerializeAppWithFirstSuccessful() throws Exception {
        String appXmlFile = "app-with-first-successful.xml";
        ArtifactDeclaration artifact = this.loadApplicationDeclaration(appXmlFile);
        this.assertApplicationArtifactSerialization(appXmlFile, artifact);
    }

    @Test
    public void loadAndSerializeAppWithRoundRobin() throws Exception {
        String appXmlFile = "app-with-round-robin.xml";
        ArtifactDeclaration artifact = this.loadApplicationDeclaration(appXmlFile);
        this.assertApplicationArtifactSerialization(appXmlFile, artifact);
    }

    @Test
    public void loadAndSerializeAppWithScatterGather() throws Exception {
        String appXmlFile = "app-with-scatter-gather.xml";
        ArtifactDeclaration artifact = this.loadApplicationDeclaration(appXmlFile);
        this.assertApplicationArtifactSerialization(appXmlFile, artifact);
    }

    @Test
    public void loadAndSerializeAppWithSubflow() throws Exception {
        String appXmlFile = "app-with-subflow.xml";
        ArtifactDeclaration artifact = this.loadApplicationDeclaration(appXmlFile);
        this.assertApplicationArtifactSerialization(appXmlFile, artifact);
    }

    private String getResourceContent(String xmlFile) throws IOException {
        return IOUtils.getResourceAsString((String)xmlFile, ((Object)((Object)this)).getClass());
    }

    private ArtifactDeclaration loadApplicationDeclaration(String appXmlFile) {
        InputStream appIs = Thread.currentThread().getContextClassLoader().getResourceAsStream(appXmlFile);
        return this.serializer.deserialize(appIs);
    }

    private void assertApplicationArtifactSerialization(String appXmlFile, ArtifactDeclaration artifact) throws Exception {
        String expectedAppXml = this.getResourceContent(appXmlFile);
        String serializationResult = this.serializer.serialize(artifact);
        MuleModelsDeclarationSerializerTestCase.compareXML(expectedAppXml, serializationResult);
    }

    public static class TestSecurityProvider
    extends AbstractSecurityProvider {
        public TestSecurityProvider() {
            this("test-security-provider");
        }

        public TestSecurityProvider(String name) {
            super(name);
        }

        public Authentication authenticate(Authentication authentication) throws SecurityException {
            return null;
        }
    }
}

