/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config.ast;

import io.qameta.allure.Feature;
import io.qameta.allure.Issue;
import io.qameta.allure.Story;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.collection.ArrayMatching;
import org.hamcrest.collection.IsCollectionWithSize;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Assert;
import org.junit.Test;
import org.mule.extension.aggregator.internal.AggregatorsExtension;
import org.mule.extension.db.internal.DbConnector;
import org.mule.extension.http.api.request.proxy.HttpProxyConfig;
import org.mule.extension.http.internal.temporary.HttpConnector;
import org.mule.extension.oauth2.OAuthExtension;
import org.mule.extension.socket.api.SocketsExtension;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.annotation.IntAnnotation;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.config.api.dsl.CoreDslConstants;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.error.ErrorMapping;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.test.config.ast.BaseParameterAstTestCase;
import org.mule.test.heisenberg.extension.HeisenbergExtension;
import org.mule.test.heisenberg.extension.model.RecursivePojo;
import org.mule.test.heisenberg.extension.model.Weapon;
import org.mule.test.petstore.extension.PetStoreConnector;
import org.mule.test.subtypes.extension.SubTypesMappingConnector;
import org.mule.test.vegan.extension.VeganExtension;

@Feature(value="Mule Artifact AST")
@Story(value="Parameter AST resolution")
public class ParameterAstTestCase
extends BaseParameterAstTestCase {
    private static final String NAME = "name";

    public ParameterAstTestCase(boolean serialize, boolean populateGenerationInformation) {
        super(serialize, populateGenerationInformation);
    }

    @Issue(value="MULE-18564")
    @Test
    public void oauthCredentialThroughProxyInlineDefinition() {
        ArtifactAst artifactAst = this.buildArtifactAst("parameters-test-http-oauth-proxy-config.xml", HttpConnector.class, SocketsExtension.class, OAuthExtension.class);
        ComponentAst httpRequestConfigWithOAuthProxyInline = this.findComponentByComponentId(artifactAst.topLevelComponentsStream(), "httpRequestConfigWithOAuthProxyInline").orElseThrow(() -> new AssertionError((Object)"Couldn't find 'httpRequestConfigWithOAuthProxyInline'"));
        ComponentAst oAuthHttpRequestConnection = this.findComponent((Stream<ComponentAst>)httpRequestConfigWithOAuthProxyInline.directChildrenStream(), "http:request-connection").orElseThrow(() -> new AssertionError((Object)"Couldn't find 'http:request-connection'"));
        ComponentParameterAst proxyConfig = oAuthHttpRequestConnection.getParameter("General", "proxyConfig");
        Assert.assertThat((Object)proxyConfig.getRawValue(), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)proxyConfig.getValue(), (Matcher)CoreMatchers.is((Object)Either.empty()));
        Assert.assertThat((Object)MetadataTypeUtils.getTypeId((MetadataType)proxyConfig.getModel().getType()), (Matcher)Matchers.equalTo(Optional.of(HttpProxyConfig.class.getName())));
        ComponentAst grantType = (ComponentAst)oAuthHttpRequestConnection.getParameter("General", "authentication").getValue().getRight();
        ComponentParameterAst proxyConfigParameter = grantType.getParameter("ClientCredentialsGrantType", "proxyConfig");
        Assert.assertThat((Object)proxyConfigParameter.getRawValue(), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)proxyConfigParameter.getValue().getRight(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        ComponentAst oauthHttpProxy = (ComponentAst)proxyConfigParameter.getValue().getRight();
        Assert.assertThat((Object)oauthHttpProxy.getIdentifier().toString(), (Matcher)CoreMatchers.is((Object)"http:proxy"));
        ComponentParameterAst portParameter = oauthHttpProxy.getParameter("proxy", "port");
        Assert.assertThat((Object)portParameter.getValue().getRight(), (Matcher)CoreMatchers.is((Object)8083));
        ComponentParameterAst hostParameter = oauthHttpProxy.getParameter("proxy", "host");
        Assert.assertThat((Object)hostParameter.getValue().getRight(), (Matcher)CoreMatchers.is((Object)"localhost"));
    }

    @Test
    public void defaultComponentHttpParameterAst() {
        ArtifactAst artifactAst = this.buildArtifactAst("parameters-test-http-oauth-proxy-config.xml", HttpConnector.class, SocketsExtension.class, OAuthExtension.class);
        ComponentAst defaultParametersFlow = this.findComponent((Stream<ComponentAst>)artifactAst.topLevelComponentsStream(), CoreDslConstants.FLOW_IDENTIFIER, "defaultParametersFlow").orElseThrow(() -> new AssertionError((Object)"Couldn't find 'defaultParametersFlow' flow"));
        Assert.assertThat((Object)defaultParametersFlow.getParameter("General", "initialState").isDefaultValue(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)defaultParametersFlow.getParameter("General", "initialState").getValue().getRight(), (Matcher)CoreMatchers.is((Object)"started"));
        Assert.assertThat((Object)defaultParametersFlow.getParameter("General", "maxConcurrency").isDefaultValue(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)defaultParametersFlow.getParameter("General", "maxConcurrency").getValue(), (Matcher)CoreMatchers.is((Object)Either.empty()));
        ComponentAst flowParameters = this.findComponent((Stream<ComponentAst>)artifactAst.topLevelComponentsStream(), CoreDslConstants.FLOW_IDENTIFIER, "flowParameters").orElseThrow(() -> new AssertionError((Object)"Couldn't find 'flowParameters' flow"));
        Assert.assertThat((Object)flowParameters.getParameter("General", "initialState").isDefaultValue(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)flowParameters.getParameter("General", "initialState").getValue().getRight(), (Matcher)CoreMatchers.is((Object)"stopped"));
        Assert.assertThat((Object)flowParameters.getParameter("General", "maxConcurrency").isDefaultValue(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)flowParameters.getParameter("General", "maxConcurrency").getValue().getRight(), (Matcher)CoreMatchers.is((Object)2));
        ComponentAst httpListener = this.findComponent((Stream<ComponentAst>)defaultParametersFlow.directChildrenStream(), "http:listener").orElseThrow(() -> new AssertionError((Object)"Couldn't find 'http:listener'"));
        Assert.assertThat((Object)httpListener.getParameter("General", "path").isDefaultValue(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)httpListener.getParameter("General", "path").getValue().getRight(), (Matcher)CoreMatchers.is((Object)"/run"));
        Assert.assertThat((Object)httpListener.getParameter("General", "config-ref").isDefaultValue(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)httpListener.getParameter("General", "config-ref").getValue().getRight(), (Matcher)CoreMatchers.is((Object)"defaultHttpListenerConfig"));
        Assert.assertThat((Object)httpListener.getParameter("General", "allowedMethods").isDefaultValue(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)httpListener.getParameter("General", "allowedMethods").getValue(), (Matcher)CoreMatchers.is((Object)Either.empty()));
        ComponentAst httpListenerConfig = this.findComponent((Stream<ComponentAst>)artifactAst.topLevelComponentsStream(), "http:listener-config", "defaultHttpListenerConfig").orElseThrow(() -> new AssertionError((Object)"Couldn't find 'defaultHttpListenerConfig' http:listener-config"));
        ComponentAst httpConnectionConfig = (ComponentAst)httpListenerConfig.directChildrenStream().findFirst().get();
        Assert.assertThat((Object)httpConnectionConfig.getParameter("Connection", "protocol").isDefaultValue(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)httpConnectionConfig.getParameter("Connection", "protocol").getValue().getRight(), (Matcher)CoreMatchers.is((Object)"HTTP"));
        Assert.assertThat((Object)httpConnectionConfig.getParameter("Connection", "port").isDefaultValue(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)httpConnectionConfig.getParameter("Connection", "port").getValue().getRight(), (Matcher)CoreMatchers.is((Object)8081));
        Assert.assertThat((Object)httpConnectionConfig.getParameter("Connection", "host").isDefaultValue(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)httpConnectionConfig.getParameter("Connection", "host").getValue().getRight(), (Matcher)CoreMatchers.is((Object)"localhost"));
        Assert.assertThat((Object)httpConnectionConfig.getParameter("Connection", "usePersistentConnections").isDefaultValue(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)httpConnectionConfig.getParameter("Connection", "usePersistentConnections").getValue().getRight(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void defaultComponentAggregatorsParameterAst() {
        ArtifactAst artifactAst = this.buildArtifactAst("parameters-test-aggregators-config.xml", AggregatorsExtension.class);
        ComponentAst timeBasedAggregatorFlow = this.findComponent((Stream<ComponentAst>)artifactAst.topLevelComponentsStream(), CoreDslConstants.FLOW_IDENTIFIER, "defaultContentAggregatorFlow").orElseThrow(() -> new AssertionError((Object)"Couldn't find 'defaultContentAggregatorFlow' flow"));
        ComponentAst timeBasedAggregator = this.findComponent((Stream<ComponentAst>)timeBasedAggregatorFlow.directChildrenStream(), "aggregators:time-based-aggregator").orElseThrow(() -> new AssertionError((Object)"Couldn't find 'aggregators:time-based-aggregator'"));
        Assert.assertThat((Object)timeBasedAggregator.getParameter("Aggregator config", "period").isDefaultValue(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)timeBasedAggregator.getParameter("Aggregator config", "period").getValue().getRight(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)timeBasedAggregator.getParameter("Aggregator config", "periodUnit").isDefaultValue(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)timeBasedAggregator.getParameter("Aggregator config", "periodUnit").getValue().getRight(), (Matcher)CoreMatchers.is((Object)"SECONDS"));
        Assert.assertThat((Object)timeBasedAggregator.getParameter("Aggregator config", "content").isDefaultValue(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((String)timeBasedAggregator.getParameter("Aggregator config", "content").getValue().getLeft()), (Matcher)CoreMatchers.is((Object)"payload"));
        timeBasedAggregatorFlow = this.findComponent((Stream<ComponentAst>)artifactAst.topLevelComponentsStream(), CoreDslConstants.FLOW_IDENTIFIER, "payloadContentAggregatorFlow").orElseThrow(() -> new AssertionError((Object)"Couldn't find 'payloadContentAggregatorFlow' flow"));
        timeBasedAggregator = this.findComponent((Stream<ComponentAst>)timeBasedAggregatorFlow.directChildrenStream(), "aggregators:time-based-aggregator").orElseThrow(() -> new AssertionError((Object)"Couldn't find 'aggregators:time-based-aggregator'"));
        Assert.assertThat((Object)timeBasedAggregator.getParameter("Aggregator config", "period").isDefaultValue(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)timeBasedAggregator.getParameter("Aggregator config", "period").getValue().getRight(), (Matcher)CoreMatchers.is((Object)10));
        Assert.assertThat((Object)timeBasedAggregator.getParameter("Aggregator config", "periodUnit").isDefaultValue(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)timeBasedAggregator.getParameter("Aggregator config", "periodUnit").getValue().getRight(), (Matcher)CoreMatchers.is((Object)"SECONDS"));
        Assert.assertThat((Object)timeBasedAggregator.getParameter("Aggregator config", "content").isDefaultValue(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((String)timeBasedAggregator.getParameter("Aggregator config", "content").getValue().getLeft()), (Matcher)CoreMatchers.is((Object)"payload"));
        timeBasedAggregatorFlow = this.findComponent((Stream<ComponentAst>)artifactAst.topLevelComponentsStream(), CoreDslConstants.FLOW_IDENTIFIER, "customContentAggregatorFlow").orElseThrow(() -> new AssertionError((Object)"Couldn't find 'customContentAggregatorFlow' flow"));
        timeBasedAggregator = this.findComponent((Stream<ComponentAst>)timeBasedAggregatorFlow.directChildrenStream(), "aggregators:time-based-aggregator").orElseThrow(() -> new AssertionError((Object)"Couldn't find 'aggregators:time-based-aggregator'"));
        Assert.assertThat((Object)timeBasedAggregator.getParameter("Aggregator config", "period").isDefaultValue(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)timeBasedAggregator.getParameter("Aggregator config", "period").getValue().getRight(), (Matcher)CoreMatchers.is((Object)20));
        Assert.assertThat((Object)timeBasedAggregator.getParameter("Aggregator config", "periodUnit").isDefaultValue(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)timeBasedAggregator.getParameter("Aggregator config", "periodUnit").getValue().getRight(), (Matcher)CoreMatchers.is((Object)"MINUTES"));
        Assert.assertThat((Object)timeBasedAggregator.getParameter("Aggregator config", "content").isDefaultValue(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)((String)timeBasedAggregator.getParameter("Aggregator config", "content").getValue().getLeft()), (Matcher)CoreMatchers.is((Object)"message"));
    }

    @Test
    @Issue(value="MULE-18619")
    public void infrastructureParameters() {
        ArtifactAst artifactAst = this.buildArtifactAst("parameters-test-http-oauth-proxy-config.xml", HttpConnector.class, SocketsExtension.class, OAuthExtension.class);
        Optional<ComponentAst> clientGlobalConfig = this.findComponentByComponentId(artifactAst.topLevelComponentsStream(), "clientGlobalConfig");
        Assert.assertThat(clientGlobalConfig, (Matcher)Matchers.not(Optional.empty()));
        ComponentAst clientGlobalConfigConnection = this.findComponent((Stream<ComponentAst>)clientGlobalConfig.get().directChildrenStream(), "http:request-connection").orElseThrow(() -> new AssertionError((Object)"Couldn't find 'http:request-connection'"));
        ComponentAst tlsContext = (ComponentAst)clientGlobalConfigConnection.getParameter("General", "tlsContext").getValue().getRight();
        ComponentAst trustStore = (ComponentAst)tlsContext.getParameter("Tls", "trust-store").getValue().getRight();
        Assert.assertThat((Object)trustStore.getParameter("TrustStore", "path").getValue().getRight(), (Matcher)CoreMatchers.is((Object)"tls/ssltest-cacerts.jks"));
        Assert.assertThat((Object)trustStore.getParameter("TrustStore", "password").getValue().getRight(), (Matcher)CoreMatchers.is((Object)"changeit"));
        ComponentAst keyStore = (ComponentAst)tlsContext.getParameter("Tls", "key-store").getValue().getRight();
        Assert.assertThat((Object)keyStore.getParameter("KeyStore", "path").getValue().getRight(), (Matcher)CoreMatchers.is((Object)"tls/ssltest-keystore.jks"));
        Assert.assertThat((Object)keyStore.getParameter("KeyStore", "keyPassword").getValue().getRight(), (Matcher)CoreMatchers.is((Object)"changeit"));
        Assert.assertThat((Object)keyStore.getParameter("KeyStore", "password").getValue().getRight(), (Matcher)CoreMatchers.is((Object)"changeit"));
        Optional<ComponentAst> withInfrastructureParametersFlow = this.findComponent((Stream<ComponentAst>)artifactAst.topLevelComponentsStream(), CoreDslConstants.FLOW_IDENTIFIER, "withInfrastructureParametersFlow");
        Assert.assertThat(withInfrastructureParametersFlow, (Matcher)Matchers.not(Optional.empty()));
        List flowChildren = withInfrastructureParametersFlow.get().directChildrenStream().collect(Collectors.toList());
        ComponentAst source = (ComponentAst)flowChildren.get(0);
        ComponentParameterAst primaryNodeOnly = source.getParameter("General", "primaryNodeOnly");
        Assert.assertThat((Object)primaryNodeOnly.getValue().getRight(), (Matcher)CoreMatchers.is((Object)true));
        ComponentAst redeliveryPolicy = (ComponentAst)source.getParameter("General", "redeliveryPolicy").getValue().getRight();
        Assert.assertThat((Object)((NamedObject)redeliveryPolicy.getModel(NamedObject.class).get()).getName(), (Matcher)CoreMatchers.is((Object)"RedeliveryPolicy"));
        Assert.assertThat((Object)redeliveryPolicy.getIdentifier().getName(), (Matcher)CoreMatchers.is((Object)"redelivery-policy"));
        Assert.assertThat((Object)redeliveryPolicy.getParameter("RedeliveryPolicy", "maxRedeliveryCount").getValue().getRight(), (Matcher)CoreMatchers.is((Object)4));
        Assert.assertThat((Object)((String)redeliveryPolicy.getParameter("RedeliveryPolicy", "idExpression").getValue().getLeft()), (Matcher)CoreMatchers.is((Object)"payload.id"));
        ComponentParameterAst streamingStrategyParameter = source.getParameter("General", "streamingStrategy");
        Assert.assertThat((Object)((String)MetadataTypeUtils.getTypeId((MetadataType)streamingStrategyParameter.getModel().getType()).get()), (Matcher)CoreMatchers.is((Object)"ByteStreamingStrategy"));
        ComponentAst streamingStrategy = (ComponentAst)streamingStrategyParameter.getValue().getRight();
        Assert.assertThat((Object)((NamedObject)streamingStrategy.getModel(NamedObject.class).get()).getName(), (Matcher)CoreMatchers.is((Object)"non-repeatable-stream"));
        Assert.assertThat((Object)streamingStrategy.getIdentifier().getName(), (Matcher)CoreMatchers.is((Object)"non-repeatable-stream"));
        ComponentParameterAst reconnectionStrategyParam = source.getParameter("Connection", "reconnectionStrategy");
        Assert.assertThat((Object)((String)MetadataTypeUtils.getTypeId((MetadataType)reconnectionStrategyParam.getModel().getType()).get()), (Matcher)CoreMatchers.is((Object)"ReconnectionStrategy"));
        ComponentAst reconnectionStrategy = (ComponentAst)reconnectionStrategyParam.getValue().getRight();
        Assert.assertThat((Object)((NamedObject)reconnectionStrategy.getModel(NamedObject.class).get()).getName(), (Matcher)CoreMatchers.is((Object)"reconnect"));
        Assert.assertThat((Object)reconnectionStrategy.getIdentifier().getName(), (Matcher)CoreMatchers.is((Object)"reconnect"));
        ComponentAst operation = (ComponentAst)flowChildren.get(1);
        ComponentParameterAst target = operation.getParameter("Output", "target");
        Assert.assertThat((Object)target.getValue().getRight(), (Matcher)CoreMatchers.is((Object)"response"));
        ComponentParameterAst targetValue = operation.getParameter("Output", "targetValue");
        Assert.assertThat((Object)((String)targetValue.getValue().getLeft()), (Matcher)CoreMatchers.is((Object)"payload.body"));
        List errorMappings = (List)operation.getParameter("Error Mappings", "errorMappings").getValue().getRight();
        Assert.assertThat((Object)errorMappings, (Matcher)IsCollectionWithSize.hasSize((int)1));
        Assert.assertThat((Object)((ErrorMapping)errorMappings.get(0)).getSource(), (Matcher)CoreMatchers.is((Object)"HTTP:SECURITY"));
        Assert.assertThat((Object)((ErrorMapping)errorMappings.get(0)).getTarget(), (Matcher)CoreMatchers.is((Object)"APP:GET_OUT"));
        ComponentParameterAst streamingStrategyOpParam = operation.getParameter("General", "streamingStrategy");
        Assert.assertThat((Object)((String)MetadataTypeUtils.getTypeId((MetadataType)streamingStrategyOpParam.getModel().getType()).get()), (Matcher)CoreMatchers.is((Object)"ByteStreamingStrategy"));
        ComponentAst streamingStrategyOp = (ComponentAst)streamingStrategyOpParam.getValue().getRight();
        Assert.assertThat((Object)((NamedObject)streamingStrategyOp.getModel(NamedObject.class).get()).getName(), (Matcher)CoreMatchers.is((Object)"non-repeatable-stream"));
        Assert.assertThat((Object)streamingStrategyOp.getIdentifier().getName(), (Matcher)CoreMatchers.is((Object)"non-repeatable-stream"));
        ComponentParameterAst operationReconnectionParam = operation.getParameter("Connection", "reconnectionStrategy");
        Assert.assertThat((Object)((String)MetadataTypeUtils.getTypeId((MetadataType)operationReconnectionParam.getModel().getType()).get()), (Matcher)CoreMatchers.is((Object)"ReconnectionStrategy"));
        ComponentAst operationReconnection = (ComponentAst)operationReconnectionParam.getValue().getRight();
        Assert.assertThat((Object)((NamedObject)operationReconnection.getModel(NamedObject.class).get()).getName(), (Matcher)CoreMatchers.is((Object)"reconnect"));
        Assert.assertThat((Object)operationReconnection.getIdentifier().getName(), (Matcher)CoreMatchers.is((Object)"reconnect"));
        Assert.assertThat((Object)operationReconnection.getParameter("reconnect", "frequency").getValue().getRight(), (Matcher)CoreMatchers.is((Object)3000L));
        Assert.assertThat((Object)operationReconnection.getParameter("reconnect", "count").getValue().getRight(), (Matcher)CoreMatchers.is((Object)3));
    }

    @Test
    @Issue(value="W-12438526")
    public void defaultRedeliveryPolicyFlow() {
        ArtifactAst artifactAst = this.buildArtifactAst("parameters-test-http-oauth-proxy-config.xml", HttpConnector.class, SocketsExtension.class, OAuthExtension.class);
        Optional<ComponentAst> defaultRedeliveryPolicyFlow = this.findComponent((Stream<ComponentAst>)artifactAst.topLevelComponentsStream(), CoreDslConstants.FLOW_IDENTIFIER, "defaultRedeliveryPolicyFlow");
        Assert.assertThat(defaultRedeliveryPolicyFlow, (Matcher)Matchers.not(Optional.empty()));
        List flowChildren = defaultRedeliveryPolicyFlow.get().directChildrenStream().collect(Collectors.toList());
        ComponentAst source = (ComponentAst)flowChildren.get(0);
        ComponentAst redeliveryPolicy = (ComponentAst)source.getParameter("General", "redeliveryPolicy").getValue().getRight();
        Assert.assertThat((Object)redeliveryPolicy.getParameter("RedeliveryPolicy", "maxRedeliveryCount").getValue().getRight(), (Matcher)CoreMatchers.is((Object)5));
        Assert.assertThat((Object)redeliveryPolicy.getParameter("RedeliveryPolicy", "useSecureHash").getValue().getRight(), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    @Issue(value="MULE-19561")
    public void tlsContextParameter() {
        ArtifactAst artifactAst = this.buildArtifactAst("parameters-test-tls-config.xml", PetStoreConnector.class);
        ComponentAst petStoreInlineTls = artifactAst.topLevelComponentsStream().filter(componentAst -> componentAst.getComponentId().map(id -> id.equals("inlineTls")).orElse(false)).findFirst().get();
        ComponentParameterAst configTls = petStoreInlineTls.getParameter("General", "tlsContext");
        Assert.assertThat((Object)configTls, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)configTls.getValue().getRight(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        ComponentParameterAst cageParam = petStoreInlineTls.getParameter("General", "cage");
        ComponentAst cagePojo = (ComponentAst)cageParam.getValue().getRight();
        ComponentParameterAst pojoTls = cagePojo.getParameter("PetCage", "tls");
        Assert.assertThat((Object)pojoTls, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)pojoTls.getValue().getRight(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
    }

    @Test
    @Issue(value="MULE-19976")
    public void tlsContextWithRevocationCheckParameter() {
        ArtifactAst artifactAst = this.buildArtifactAst("parameters-test-tls-global-with-revocation-check-config.xml", PetStoreConnector.class);
        ComponentAst pojoTls = artifactAst.topLevelComponentsStream().filter(componentAst -> componentAst.getComponentId().map(id -> id.equals("globalTlsContext")).orElse(false)).findFirst().get();
        ComponentParameterAst revocationCheck = pojoTls.getParameter("Tls", "revocation-check");
        Assert.assertThat((Object)revocationCheck, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)revocationCheck.getValue().getRight(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
    }

    @Test
    @Issue(value="MULE-18602")
    public void nestedPojoOperationParameter() {
        ArtifactAst artifactAst = this.buildArtifactAst("parameters-test-pojo-config.xml", HeisenbergExtension.class, SubTypesMappingConnector.class, VeganExtension.class);
        Optional<ComponentAst> optionalFlowNestedPojo = this.findComponent((Stream<ComponentAst>)artifactAst.topLevelComponentsStream(), CoreDslConstants.FLOW_IDENTIFIER, "nestedPojo");
        Assert.assertThat(optionalFlowNestedPojo, (Matcher)Matchers.not(Optional.empty()));
        ComponentAst heisenbergApprove = optionalFlowNestedPojo.map(flow -> (ComponentAst)flow.directChildrenStream().findFirst().get()).orElseThrow(() -> new AssertionError((Object)"Couldn't find heisenberg approve operation"));
        ComponentParameterAst investmentParameter = heisenbergApprove.getParameter("General", "investment");
        ComponentAst investmentAst = (ComponentAst)investmentParameter.getValue().getRight();
        Assert.assertThat((Object)investmentAst, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        ComponentParameterAst commercialName = investmentAst.getParameter("CarWash", "commercialName");
        ComponentParameterAst carsPerMinute = investmentAst.getParameter("CarWash", "carsPerMinute");
        Assert.assertThat((Object)investmentAst.getParameters(), (Matcher)CoreMatchers.is((Matcher)Matchers.not(Optional.empty())));
        Assert.assertThat((Object)commercialName.getValue().getRight(), (Matcher)CoreMatchers.is((Object)"A1"));
        Assert.assertThat((Object)carsPerMinute.getValue().getRight(), (Matcher)CoreMatchers.is((Object)5));
        List investmentSpinOffs = (List)investmentAst.getParameter("CarWash", "investmentSpinOffs").getValue().getRight();
        ComponentAst firstSpinOff = (ComponentAst)investmentSpinOffs.get(0);
        ComponentAst carWash = (ComponentAst)firstSpinOff.getParameter("General", "value").getValue().getRight();
        List discardedInvestments = (List)carWash.getParameter("CarWash", "discardedInvestments").getValue().getRight();
        ComponentAst firstDiscardedInvestment = (ComponentAst)discardedInvestments.get(0);
        Assert.assertThat((Object)firstDiscardedInvestment.directChildren(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
        ComponentParameterAst investmentPlanB = firstDiscardedInvestment.getParameter("CarDealer", "investmentPlanB");
        Assert.assertThat((Object)investmentPlanB.getValue().getValue().isPresent(), (Matcher)CoreMatchers.is((Object)true));
        ComponentAst carDealer = (ComponentAst)investmentPlanB.getValue().getRight();
        List presentParameterNames = carDealer.getParameters().stream().filter(param -> param.getValue().getValue().isPresent()).map(param -> param.getModel().getName()).collect(Collectors.toList());
        Assert.assertThat(presentParameterNames, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"carStock", "commercialName", "valuation"}));
    }

    @Test
    public void recursivePojoOperationParameter() {
        ArtifactAst artifactAst = this.buildArtifactAst("parameters-test-pojo-config.xml", HeisenbergExtension.class, SubTypesMappingConnector.class, VeganExtension.class);
        Optional<ComponentAst> optionalFlowRecursivePojo = this.findComponent((Stream<ComponentAst>)artifactAst.topLevelComponentsStream(), CoreDslConstants.FLOW_IDENTIFIER, "recursivePojo");
        Assert.assertThat(optionalFlowRecursivePojo, (Matcher)Matchers.not(Optional.empty()));
        ComponentAst heisenbergApprove = optionalFlowRecursivePojo.map(flow -> (ComponentAst)flow.directChildrenStream().findFirst().get()).orElseThrow(() -> new AssertionError((Object)"Couldn't find heisenberg approve operation"));
        ComponentParameterAst recursivePojoParameter = heisenbergApprove.getParameter("General", "recursivePojo");
        ComponentAst recursivePojo = (ComponentAst)recursivePojoParameter.getValue().getRight();
        Assert.assertThat((Object)recursivePojo, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        ComponentParameterAst recursivePojoNextParameter = recursivePojo.getParameter("RecursivePojo", "next");
        Assert.assertThat((Object)MetadataTypeUtils.getTypeId((MetadataType)recursivePojoNextParameter.getModel().getType()), (Matcher)Matchers.equalTo(Optional.of(RecursivePojo.class.getName())));
        Assert.assertThat((Object)recursivePojoNextParameter.getValue().getRight(), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
        ComponentParameterAst recursivePojoChildsParameter = recursivePojo.getParameter("RecursivePojo", "childs");
        Assert.assertThat((Object)recursivePojoChildsParameter.getModel().getType(), (Matcher)IsInstanceOf.instanceOf(ArrayType.class));
        Assert.assertThat((Object)MetadataTypeUtils.getTypeId((MetadataType)((ArrayType)recursivePojoChildsParameter.getModel().getType()).getType()), (Matcher)Matchers.equalTo(Optional.of(RecursivePojo.class.getName())));
        Assert.assertThat((Object)recursivePojoChildsParameter.getValue().getRight(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        ComponentAst childRecursivePojo = (ComponentAst)((List)recursivePojoChildsParameter.getValue().getRight()).stream().findFirst().orElseThrow(() -> new AssertionError((Object)"Couldn't find child declaration"));
        ComponentParameterAst childRecursivePojoNextParameter = childRecursivePojo.getParameter("RecursivePojo", "next");
        Assert.assertThat((Object)MetadataTypeUtils.getTypeId((MetadataType)childRecursivePojoNextParameter.getModel().getType()), (Matcher)Matchers.equalTo(Optional.of(RecursivePojo.class.getName())));
        ComponentAst childRecursivePojoNext = (ComponentAst)childRecursivePojoNextParameter.getValue().getRight();
        Assert.assertThat((Object)childRecursivePojoNext, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        ComponentParameterAst childRecursivePojoNextMappedChildsParameter = childRecursivePojoNext.getParameter("RecursivePojo", "mappedChilds");
        Assert.assertThat((Object)childRecursivePojoNextMappedChildsParameter.getModel().getType(), (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        Optional openRestrictionChildRecursivePojoNextMappedChildsParameter = ((ObjectType)childRecursivePojoNextMappedChildsParameter.getModel().getType()).getOpenRestriction();
        Assert.assertThat((Object)openRestrictionChildRecursivePojoNextMappedChildsParameter, (Matcher)Matchers.not(Optional.empty()));
        Assert.assertThat((Object)MetadataTypeUtils.getTypeId((MetadataType)((MetadataType)openRestrictionChildRecursivePojoNextMappedChildsParameter.get())), (Matcher)Matchers.equalTo(Optional.of(RecursivePojo.class.getName())));
        List childRecursivePojoNextMappedChildsParameterComponent = (List)childRecursivePojoNextMappedChildsParameter.getValue().getRight();
        Assert.assertThat((Object)childRecursivePojoNextMappedChildsParameterComponent, (Matcher)IsCollectionWithSize.hasSize((int)1));
        ComponentParameterAst childRecursivePojoNextMappedChildsParameterComponentKeyParam = ((ComponentAst)childRecursivePojoNextMappedChildsParameterComponent.get(0)).getParameter("General", "key");
        Assert.assertThat((Object)childRecursivePojoNextMappedChildsParameterComponentKeyParam.getValue().getRight(), (Matcher)Matchers.equalTo((Object)"someKey"));
        Assert.assertThat((Object)MetadataTypeUtils.getTypeId((MetadataType)childRecursivePojoNextMappedChildsParameterComponentKeyParam.getModel().getType()), (Matcher)Matchers.equalTo(Optional.of(String.class.getName())));
        ComponentParameterAst childRecursivePojoNextMappedChildsParameterComponentValueParam = ((ComponentAst)childRecursivePojoNextMappedChildsParameterComponent.get(0)).getParameter("General", "value");
        Assert.assertThat((Object)((String)childRecursivePojoNextMappedChildsParameterComponentValueParam.getValue().getLeft()), (Matcher)Matchers.equalTo((Object)"{} as Object {class: 'new org.mule.test.heisenberg.extension.model.RecursivePojo'}"));
        Assert.assertThat((Object)MetadataTypeUtils.getTypeId((MetadataType)childRecursivePojoNextMappedChildsParameterComponentValueParam.getModel().getType()), (Matcher)Matchers.equalTo(Optional.of(RecursivePojo.class.getName())));
        ComponentParameterAst recursivePojoMappedChildsParameter = recursivePojo.getParameter("RecursivePojo", "mappedChilds");
        Assert.assertThat((Object)recursivePojoMappedChildsParameter.getModel().getType(), (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        Optional openRestrictionRecursivePojoMappedChildsParameter = ((ObjectType)recursivePojoMappedChildsParameter.getModel().getType()).getOpenRestriction();
        Assert.assertThat((Object)openRestrictionRecursivePojoMappedChildsParameter, (Matcher)Matchers.not(Optional.empty()));
        Assert.assertThat((Object)MetadataTypeUtils.getTypeId((MetadataType)((MetadataType)openRestrictionRecursivePojoMappedChildsParameter.get())), (Matcher)Matchers.equalTo(Optional.of(RecursivePojo.class.getName())));
        Assert.assertThat((Object)recursivePojoMappedChildsParameter.getValue().getRight(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        List recursivePojoMappedChilds = (List)recursivePojoMappedChildsParameter.getValue().getRight();
        ComponentAst recursivePojoMappedChild = (ComponentAst)recursivePojoMappedChilds.stream().findFirst().get();
        ParameterizedModel recursivePojoMappedChildModel = (ParameterizedModel)recursivePojoMappedChild.getModel(ParameterizedModel.class).orElseThrow(() -> new AssertionError((Object)"Model is missing for mapped-childs"));
        ParameterModel keyParameterModel = recursivePojoMappedChildModel.getAllParameterModels().stream().filter(paramModel -> paramModel.getName().equals("key")).findFirst().orElseThrow(() -> new AssertionError((Object)"mapped-childs model is missing key parameter"));
        Assert.assertThat((Object)MetadataTypeUtils.getTypeId((MetadataType)keyParameterModel.getType()), (Matcher)Matchers.equalTo(Optional.of(String.class.getName())));
        ParameterModel valueParameterModel = recursivePojoMappedChildModel.getAllParameterModels().stream().filter(paramModel -> paramModel.getName().equals("value")).findFirst().orElseThrow(() -> new AssertionError((Object)"mapped-childs model is missing key parameter"));
        Assert.assertThat((Object)MetadataTypeUtils.getTypeId((MetadataType)valueParameterModel.getType()), (Matcher)Matchers.equalTo(Optional.of(RecursivePojo.class.getName())));
    }

    @Test
    public void mapListOfSimpleValueType() {
        ArtifactAst artifactAst = this.buildArtifactAst("parameters-test-pojo-config.xml", HeisenbergExtension.class, SubTypesMappingConnector.class, VeganExtension.class);
        ComponentAst heisenbergConfig = this.getHeisenbergConfiguration(artifactAst);
        ComponentParameterAst deathsBySeasonsParam = heisenbergConfig.getParameter("General", "deathsBySeasons");
        Assert.assertThat((Object)ExtensionMetadataTypeUtils.isMap((MetadataType)deathsBySeasonsParam.getModel().getType()), (Matcher)CoreMatchers.is((Object)true));
        Optional optionalOpenRestriction = ((ObjectType)deathsBySeasonsParam.getModel().getType()).getOpenRestriction();
        Assert.assertThat((Object)optionalOpenRestriction, (Matcher)Matchers.not(Optional.empty()));
        Assert.assertThat((Object)((MetadataType)optionalOpenRestriction.get()), (Matcher)IsInstanceOf.instanceOf(ArrayType.class));
        Assert.assertThat((Object)MetadataTypeUtils.getTypeId((MetadataType)((ArrayType)optionalOpenRestriction.get()).getType()), (Matcher)Matchers.equalTo(Optional.of(String.class.getName())));
        List deathsBySeasons = (List)deathsBySeasonsParam.getValue().getRight();
        Assert.assertThat((Object)deathsBySeasons, (Matcher)IsCollectionWithSize.hasSize((int)1));
        ComponentAst deathBySeason = (ComponentAst)deathsBySeasons.stream().findFirst().get();
        ComponentParameterAst keyParameter = deathBySeason.getParameter("General", "key");
        Assert.assertThat((Object)keyParameter.getValue().getRight(), (Matcher)CoreMatchers.is((Object)"s01"));
        ComponentParameterAst valueParameter = deathBySeason.getParameter("General", "value");
        List values = (List)valueParameter.getValue().getRight();
        Assert.assertThat((Object)values, (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat((Object)((ComponentAst)values.get(0)).getParameter("General", "value").getValue().getRight(), (Matcher)CoreMatchers.is((Object)"emilio"));
        Assert.assertThat((Object)((ComponentAst)values.get(1)).getParameter("General", "value").getValue().getRight(), (Matcher)CoreMatchers.is((Object)"domingo"));
    }

    @Test
    public void mapListOfComplexValueType() {
        ArtifactAst artifactAst = this.buildArtifactAst("parameters-test-pojo-config.xml", HeisenbergExtension.class, SubTypesMappingConnector.class, VeganExtension.class);
        ComponentAst heisenbergConfig = this.getHeisenbergConfiguration(artifactAst);
        ComponentParameterAst weaponValueMapsParam = heisenbergConfig.getParameter("General", "weaponValueMap");
        Assert.assertThat((Object)ExtensionMetadataTypeUtils.isMap((MetadataType)weaponValueMapsParam.getModel().getType()), (Matcher)CoreMatchers.is((Object)true));
        Optional optionalOpenRestriction = ((ObjectType)weaponValueMapsParam.getModel().getType()).getOpenRestriction();
        Assert.assertThat((Object)optionalOpenRestriction, (Matcher)Matchers.not(Optional.empty()));
        Assert.assertThat((Object)MetadataTypeUtils.getTypeId((MetadataType)((MetadataType)optionalOpenRestriction.get())), (Matcher)Matchers.equalTo(Optional.of(Weapon.class.getName())));
        List weaponValueMaps = (List)weaponValueMapsParam.getValue().getRight();
        Assert.assertThat((Object)weaponValueMaps, (Matcher)IsCollectionWithSize.hasSize((int)2));
        ComponentAst weaponValueMap = (ComponentAst)weaponValueMaps.stream().findFirst().get();
        ComponentParameterAst keyParameter = weaponValueMap.getParameter("General", "key");
        Assert.assertThat((Object)keyParameter.getValue().getRight(), (Matcher)CoreMatchers.is((Object)"first"));
        ComponentParameterAst valueParameter = weaponValueMap.getParameter("General", "value");
        ComponentAst ricinValue = (ComponentAst)valueParameter.getValue().getRight();
        Assert.assertThat((Object)ricinValue.getParameter("Ricin", "microgramsPerKilo").getValue().getRight(), (Matcher)CoreMatchers.is((Object)22L));
        ComponentAst destination = (ComponentAst)ricinValue.getParameter("Ricin", "destination").getValue().getRight();
        Assert.assertThat((Object)destination, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)destination.getParameter("door", "victim").getValue().getRight(), (Matcher)Matchers.equalTo((Object)"Lidia"));
        Assert.assertThat((Object)destination.getParameter("door", "address").getValue().getRight(), (Matcher)Matchers.equalTo((Object)"Stevia coffe shop"));
        weaponValueMap = (ComponentAst)weaponValueMaps.stream().skip(1L).findFirst().get();
        keyParameter = weaponValueMap.getParameter("General", "key");
        Assert.assertThat((Object)keyParameter.getValue().getRight(), (Matcher)CoreMatchers.is((Object)"second"));
        valueParameter = weaponValueMap.getParameter("General", "value");
        ComponentAst revolver = (ComponentAst)valueParameter.getValue().getRight();
        Assert.assertThat((Object)revolver.getParameter("Revolver", NAME).getValue().getRight(), (Matcher)CoreMatchers.is((Object)"sledgeHammer's"));
        Assert.assertThat((Object)revolver.getParameter("Revolver", "bullets").getValue().getRight(), (Matcher)CoreMatchers.is((Object)1));
    }

    @Test
    public void mapSimpleValueType() {
        ArtifactAst artifactAst = this.buildArtifactAst("parameters-test-pojo-config.xml", HeisenbergExtension.class, SubTypesMappingConnector.class, VeganExtension.class);
        ComponentAst heisenbergConfig = this.getHeisenbergConfiguration(artifactAst);
        ComponentParameterAst recipesParam = heisenbergConfig.getParameter("General", "recipe");
        Assert.assertThat((Object)ExtensionMetadataTypeUtils.isMap((MetadataType)recipesParam.getModel().getType()), (Matcher)CoreMatchers.is((Object)true));
        Optional optionalOpenRestriction = ((ObjectType)recipesParam.getModel().getType()).getOpenRestriction();
        Assert.assertThat((Object)optionalOpenRestriction, (Matcher)Matchers.not(Optional.empty()));
        Assert.assertThat((Object)((MetadataType)optionalOpenRestriction.get()), (Matcher)IsInstanceOf.instanceOf(NumberType.class));
        List recipes = (List)recipesParam.getValue().getRight();
        Assert.assertThat((Object)recipes, (Matcher)IsCollectionWithSize.hasSize((int)3));
        ComponentAst recipe = (ComponentAst)recipes.stream().findFirst().get();
        ComponentParameterAst keyParameter = recipe.getParameter("General", "key");
        Assert.assertThat((Object)keyParameter.getValue().getRight(), (Matcher)CoreMatchers.is((Object)"methylamine"));
        ComponentParameterAst valueParameter = recipe.getParameter("General", "value");
        Assert.assertThat((Object)valueParameter.getValue().getRight(), (Matcher)CoreMatchers.is((Object)75L));
    }

    private ComponentAst getHeisenbergConfiguration(ArtifactAst artifactAst) {
        Optional<ComponentAst> optionalHeisenbergConfig = this.findComponent((Stream<ComponentAst>)artifactAst.topLevelComponentsStream(), "heisenberg:config", "heisenberg");
        Assert.assertThat(optionalHeisenbergConfig, (Matcher)Matchers.not(Optional.empty()));
        return optionalHeisenbergConfig.get();
    }

    @Test
    public void listSimpleValueType() {
        ArtifactAst artifactAst = this.buildArtifactAst("parameters-test-pojo-config.xml", HeisenbergExtension.class, SubTypesMappingConnector.class, VeganExtension.class);
        ComponentAst heisenbergConfig = this.getHeisenbergConfiguration(artifactAst);
        ComponentParameterAst enemiesParam = heisenbergConfig.getParameter("General", "enemies");
        List enemies = (List)enemiesParam.getValue().getRight();
        Assert.assertThat((Object)enemies, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)enemies, (Matcher)IsCollectionWithSize.hasSize((int)2));
        Assert.assertThat((Object)((ComponentAst)enemies.get(0)).getParameter("General", "value").getValue().getRight(), (Matcher)Matchers.equalTo((Object)"Gustavo Fring"));
        Assert.assertThat((Object)((ComponentAst)enemies.get(1)).getParameter("General", "value").getValue().getRight(), (Matcher)Matchers.equalTo((Object)"Hank"));
    }

    @Test
    public void simpleParameters() {
        ArtifactAst artifactAst = this.buildArtifactAst("parameters-test-config.xml", DbConnector.class, PetStoreConnector.class);
        Optional<ComponentAst> optionalFlowParameters = this.findComponent((Stream<ComponentAst>)artifactAst.topLevelComponentsStream(), CoreDslConstants.FLOW_IDENTIFIER, "flowParameters");
        Assert.assertThat(optionalFlowParameters, (Matcher)Matchers.not(Optional.empty()));
        ComponentAst componentAst = optionalFlowParameters.get();
        Optional optionalConstructModel = componentAst.getModel(ConstructModel.class);
        Assert.assertThat((Object)optionalConstructModel, (Matcher)Matchers.not(Optional.empty()));
        ConstructModel constructModel = (ConstructModel)optionalConstructModel.get();
        ComponentParameterAst componentParameterAst = componentAst.getParameter("General", "initialState");
        Assert.assertThat((Object)componentParameterAst.getRawValue(), (Matcher)Matchers.equalTo((Object)"stopped"));
        Assert.assertThat((Object)componentParameterAst.isDefaultValue(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat(this.findParameterModel((ParameterizedModel)constructModel, componentParameterAst), (Matcher)Matchers.not(Optional.empty()));
        String[] values = (String[])((EnumAnnotation)componentParameterAst.getModel().getType().getAnnotation(EnumAnnotation.class).get()).getValues();
        Assert.assertThat((Object)values, (Matcher)Matchers.allOf((Matcher)ArrayMatching.hasItemInArray((Object)"started"), (Matcher)ArrayMatching.hasItemInArray((Object)"stopped")));
        componentParameterAst = componentAst.getParameter("General", "maxConcurrency");
        Assert.assertThat(this.findParameterModel((ParameterizedModel)constructModel, componentParameterAst), (Matcher)Matchers.not(Optional.empty()));
        Assert.assertThat((Object)componentParameterAst.isDefaultValue(), (Matcher)CoreMatchers.is((Object)false));
        Assert.assertThat((Object)componentParameterAst.getModel().getType().getAnnotation(IntAnnotation.class), (Matcher)Matchers.not(Optional.empty()));
        Assert.assertThat((Object)componentAst.getComponentId(), (Matcher)Matchers.not(Optional.empty()));
        componentParameterAst = componentAst.getParameter("General", NAME);
        Assert.assertThat(this.findParameterModel((ParameterizedModel)constructModel, componentParameterAst), (Matcher)Matchers.not(Optional.empty()));
        Assert.assertThat((Object)componentParameterAst.getValue().getRight(), (Matcher)Matchers.equalTo(componentAst.getComponentId().get()));
    }

    private Optional<ParameterModel> findParameterModel(ParameterizedModel constructModel, ComponentParameterAst componentParameterAst) {
        return constructModel.getAllParameterModels().stream().filter(parameterModel -> parameterModel.equals(componentParameterAst.getModel())).findFirst();
    }

    @Test
    public void wrappedElementSimpleMapType() {
        ArtifactAst artifactAst = this.buildArtifactAst("parameters-test-config.xml", DbConnector.class, PetStoreConnector.class);
        Optional<ComponentAst> optionalDbConfig = this.findComponent((Stream<ComponentAst>)artifactAst.topLevelComponentsStream(), "db:config", "dbConfig");
        Assert.assertThat(optionalDbConfig, (Matcher)Matchers.not(Optional.empty()));
        ComponentAst dbConfig = optionalDbConfig.get();
        Optional<ComponentAst> optionalConnectionProvider = dbConfig.recursiveStream().filter(inner -> inner.getModel(ConnectionProviderModel.class).isPresent()).findFirst();
        Assert.assertThat(optionalConnectionProvider, (Matcher)Matchers.not(Optional.empty()));
        ComponentAst connectionProvider = optionalConnectionProvider.get();
        ComponentParameterAst poolingProfileParameterAst = connectionProvider.getParameter("General", "poolingProfile");
        Assert.assertThat((Object)poolingProfileParameterAst, (Matcher)Matchers.not(Optional.empty()));
        Optional poolingProfileParameter = poolingProfileParameterAst.getValue().getValue();
        Assert.assertThat((Object)poolingProfileParameter, (Matcher)Matchers.not(Optional.empty()));
        ComponentParameterAst maxWaitUnit = ((ComponentAst)poolingProfileParameter.get()).getParameter("pooling-profile", "maxWaitUnit");
        Assert.assertThat((Object)maxWaitUnit.getValue().isRight(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)maxWaitUnit.getValue().getRight(), (Matcher)CoreMatchers.is((Object)""));
        Optional<ComponentParameterAst> additionalPropertiesParameterAst = poolingProfileParameter.map(ppp -> ppp.getParameter("pooling-profile", "additionalProperties"));
        Assert.assertThat(additionalPropertiesParameterAst, (Matcher)Matchers.not(Optional.empty()));
        Optional additionalProperties = additionalPropertiesParameterAst.get().getValue().getValue();
        Assert.assertThat((Object)additionalProperties, (Matcher)Matchers.not(Optional.empty()));
        Assert.assertThat((Object)((List)additionalProperties.get()).isEmpty(), (Matcher)CoreMatchers.is((Object)true));
        ComponentParameterAst connectionPropertiesParameterAst = connectionProvider.getParameter("Connection", "connectionProperties");
        Assert.assertThat((Object)connectionPropertiesParameterAst.getModel().getType(), (Matcher)IsInstanceOf.instanceOf(ObjectType.class));
        Optional openRestrictionTypeForConnectionPropertiesParameter = ((ObjectType)connectionPropertiesParameterAst.getModel().getType()).getOpenRestriction();
        Assert.assertThat((Object)openRestrictionTypeForConnectionPropertiesParameter, (Matcher)Matchers.not(Optional.empty()));
        Assert.assertThat((Object)MetadataTypeUtils.getTypeId((MetadataType)((MetadataType)openRestrictionTypeForConnectionPropertiesParameter.get())), (Matcher)Matchers.equalTo(Optional.of(String.class.getName())));
        List connectionProperties = (List)connectionPropertiesParameterAst.getValue().getRight();
        ComponentAst connectionProperty = (ComponentAst)connectionProperties.stream().findFirst().orElseThrow(() -> new AssertionError((Object)"Couldn't find connection property entry"));
        ParameterizedModel connectionPropertyModel = (ParameterizedModel)connectionProperty.getModel(ParameterizedModel.class).orElseThrow(() -> new AssertionError((Object)"Model is missing for connection-properties"));
        ParameterModel keyParameterModel = connectionPropertyModel.getAllParameterModels().stream().filter(paramModel -> paramModel.getName().equals("key")).findFirst().orElseThrow(() -> new AssertionError((Object)"connection-properties model is missing key parameter"));
        Assert.assertThat((Object)MetadataTypeUtils.getTypeId((MetadataType)keyParameterModel.getType()), (Matcher)Matchers.equalTo(Optional.of(String.class.getName())));
        ParameterModel valueParameterModel = connectionPropertyModel.getAllParameterModels().stream().filter(paramModel -> paramModel.getName().equals("value")).findFirst().orElseThrow(() -> new AssertionError((Object)"connection-properties model is missing value parameter"));
        Assert.assertThat((Object)MetadataTypeUtils.getTypeId((MetadataType)valueParameterModel.getType()), (Matcher)Matchers.equalTo(Optional.of(String.class.getName())));
        Assert.assertThat((Object)connectionProperty.getParameter("General", "key").getValue().getRight(), (Matcher)Matchers.equalTo((Object)"first"));
        Assert.assertThat((Object)connectionProperty.getParameter("General", "value").getValue().getRight(), (Matcher)Matchers.equalTo((Object)"propertyOne"));
        connectionProperty = (ComponentAst)connectionProperties.stream().skip(1L).findFirst().orElseThrow(() -> new AssertionError((Object)"Couldn't find connection property entry"));
        keyParameterModel = connectionPropertyModel.getAllParameterModels().stream().filter(paramModel -> paramModel.getName().equals("key")).findFirst().orElseThrow(() -> new AssertionError((Object)"connection-properties model is missing key parameter"));
        Assert.assertThat((Object)MetadataTypeUtils.getTypeId((MetadataType)keyParameterModel.getType()), (Matcher)Matchers.equalTo(Optional.of(String.class.getName())));
        valueParameterModel = connectionPropertyModel.getAllParameterModels().stream().filter(paramModel -> paramModel.getName().equals("value")).findFirst().orElseThrow(() -> new AssertionError((Object)"connection-properties model is missing value parameter"));
        Assert.assertThat((Object)MetadataTypeUtils.getTypeId((MetadataType)valueParameterModel.getType()), (Matcher)Matchers.equalTo(Optional.of(String.class.getName())));
        Assert.assertThat((Object)connectionProperty.getParameter("General", "key").getValue().getRight(), (Matcher)Matchers.equalTo((Object)"second"));
        Assert.assertThat((Object)connectionProperty.getParameter("General", "value").getValue().getRight(), (Matcher)Matchers.equalTo((Object)"propertyTwo"));
    }

    @Test
    public void wrappedElementArrayType() {
        ArtifactAst artifactAst = this.buildArtifactAst("parameters-test-http-oauth-proxy-config.xml", HttpConnector.class, SocketsExtension.class, OAuthExtension.class);
        Optional<ComponentAst> optionalHttpListenerConfig = this.findComponent((Stream<ComponentAst>)artifactAst.topLevelComponentsStream(), "http:listener-config", "HTTP_Listener_config");
        Assert.assertThat(optionalHttpListenerConfig, (Matcher)Matchers.not(Optional.empty()));
        ComponentAst httpListenerConfig = optionalHttpListenerConfig.get();
        Assert.assertThat((Object)httpListenerConfig.getModel(ConfigurationModel.class), (Matcher)Matchers.not(Optional.empty()));
        Assert.assertThat((Object)httpListenerConfig.getComponentId(), (Matcher)Matchers.not(Optional.empty()));
        ComponentParameterAst nameComponentParameter = httpListenerConfig.getParameter("General", NAME);
        Assert.assertThat((Object)nameComponentParameter.getValue().getRight(), (Matcher)Matchers.equalTo(httpListenerConfig.getComponentId().get()));
        Optional<ComponentAst> optionalConnectionProvider = httpListenerConfig.recursiveStream().filter(inner -> inner.getModel(ConnectionProviderModel.class).isPresent()).findFirst();
        Assert.assertThat(optionalConnectionProvider, (Matcher)Matchers.not(Optional.empty()));
        ComponentAst connectionProvider = optionalConnectionProvider.get();
        ComponentParameterAst tlsContextParameter = connectionProvider.getParameter("General", "tlsContext");
        Assert.assertThat((Object)((String)tlsContextParameter.getValue().getLeft()), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)tlsContextParameter.getValue().getRight(), (Matcher)Matchers.equalTo((Object)"listenerTlsContext"));
        ComponentParameterAst basePathParameter = httpListenerConfig.getParameter("General", "basePath");
        Assert.assertThat((Object)((String)basePathParameter.getValue().getLeft()), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)basePathParameter.getValue().getRight(), (Matcher)Matchers.equalTo((Object)"/api"));
        ComponentParameterAst listenerInterceptorsParameter = httpListenerConfig.getParameter("General", "listenerInterceptors");
        Assert.assertThat((Object)((String)listenerInterceptorsParameter.getValue().getLeft()), (Matcher)Matchers.nullValue());
        ComponentAst listenerInterceptors = (ComponentAst)listenerInterceptorsParameter.getValue().getRight();
        ComponentParameterAst corsInterceptorParameter = listenerInterceptors.getParameter("CorsInterceptorWrapper", "corsInterceptor");
        Assert.assertThat((Object)((String)corsInterceptorParameter.getValue().getLeft()), (Matcher)Matchers.nullValue());
        ComponentAst corsInterceptor = (ComponentAst)corsInterceptorParameter.getValue().getRight();
        ComponentParameterAst allowCredentialsParameter = corsInterceptor.getParameter("CorsListenerInterceptor", "allowCredentials");
        Assert.assertThat((Object)((String)allowCredentialsParameter.getValue().getLeft()), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)allowCredentialsParameter.getValue().getRight(), (Matcher)CoreMatchers.is((Object)Boolean.TRUE));
        ComponentParameterAst originsParameter = corsInterceptor.getParameter("CorsListenerInterceptor", "origins");
        Assert.assertThat((Object)((String)originsParameter.getValue().getLeft()), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)originsParameter.getValue().getRight(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        List origins = (List)originsParameter.getValue().getRight();
        ComponentAst origin = (ComponentAst)origins.stream().findFirst().get();
        ComponentParameterAst originUrlParameter = origin.getParameter("origin", "url");
        Assert.assertThat((Object)((String)originUrlParameter.getValue().getLeft()), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)originUrlParameter.getValue().getRight(), (Matcher)CoreMatchers.is((Object)"http://www.the-origin-of-time.com"));
        ComponentParameterAst originAccessControlMaxAgeParameter = origin.getParameter("origin", "accessControlMaxAge");
        Assert.assertThat((Object)((String)originAccessControlMaxAgeParameter.getValue().getLeft()), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)originAccessControlMaxAgeParameter.getValue().getRight(), (Matcher)CoreMatchers.is((Object)30L));
        this.assertParameters(origin, "origin", "allowedMethods", "Method", "methodName", "POST", "PUT", "GET");
        this.assertParameters(origin, "origin", "allowedHeaders", "Header", "headerName", "x-allow-origin", "x-yet-another-valid-header");
        this.assertParameters(origin, "origin", "exposeHeaders", "Header", "headerName", "x-forwarded-for");
        origin = (ComponentAst)origins.stream().skip(1L).findFirst().get();
        originUrlParameter = origin.getParameter("origin", "url");
        Assert.assertThat((Object)((String)originUrlParameter.getValue().getLeft()), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)originUrlParameter.getValue().getRight(), (Matcher)CoreMatchers.is((Object)"http://www.the-origin-of-life.com"));
        originAccessControlMaxAgeParameter = origin.getParameter("origin", "accessControlMaxAge");
        Assert.assertThat((Object)((String)originAccessControlMaxAgeParameter.getValue().getLeft()), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)originAccessControlMaxAgeParameter.getValue().getRight(), (Matcher)CoreMatchers.is((Object)60L));
        this.assertParameters(origin, "origin", "allowedMethods", "Method", "methodName", "POST", "GET");
        this.assertParameters(origin, "origin", "allowedHeaders", "Header", "headerName", "x-allow-origin");
        this.assertParameters(origin, "origin", "exposeHeaders", "Header", "headerName", "x-forwarded-for");
    }

    @Test
    @Issue(value="MULE-19563")
    public void complexParamWithDefaultValueFixed() {
        ArtifactAst artifactAst = this.buildArtifactAst("parameters-test-pojo-config.xml", HeisenbergExtension.class, SubTypesMappingConnector.class, VeganExtension.class);
        ComponentAst killWithRicinAsChildElementFlow = artifactAst.topLevelComponentsStream().filter(componentAst -> componentAst.getComponentId().map(id -> id.equals("killWithRicinAsChildElement")).orElse(false)).findFirst().get();
        ComponentAst killWithRicinsOperation = (ComponentAst)killWithRicinAsChildElementFlow.directChildrenStream().findFirst().get();
        Either ricinsValue = killWithRicinsOperation.getParameter("General", "ricins").getValue();
        Assert.assertThat((String)ricinsValue.toString(), (Object)ricinsValue.isRight(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)ricinsValue.toString(), (Object)ricinsValue.getRight(), (Matcher)IsInstanceOf.instanceOf(List.class));
    }

    @Test
    @Issue(value="MULE-19563")
    public void complexParamWithDefaultValueExpression() {
        ArtifactAst artifactAst = this.buildArtifactAst("parameters-test-pojo-config.xml", HeisenbergExtension.class, SubTypesMappingConnector.class, VeganExtension.class);
        ComponentAst killWithRicinAsChildElementFlow = artifactAst.topLevelComponentsStream().filter(componentAst -> componentAst.getComponentId().map(id -> id.equals("killWithRicinAsExpression")).orElse(false)).findFirst().get();
        ComponentAst killWithRicinsOperation = (ComponentAst)killWithRicinAsChildElementFlow.directChildrenStream().findFirst().get();
        Either ricinsValue = killWithRicinsOperation.getParameter("General", "ricins").getValue();
        Assert.assertThat((String)ricinsValue.toString(), (Object)ricinsValue.isLeft(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)ricinsValue.toString(), (Object)((String)ricinsValue.getLeft()), (Matcher)CoreMatchers.is((Object)"{}"));
    }

    @Test
    @Issue(value="MULE-19563")
    public void complexParamWithDefaultValue() {
        ArtifactAst artifactAst = this.buildArtifactAst("parameters-test-pojo-config.xml", HeisenbergExtension.class, SubTypesMappingConnector.class, VeganExtension.class);
        ComponentAst killWithRicinAsChildElementFlow = artifactAst.topLevelComponentsStream().filter(componentAst -> componentAst.getComponentId().map(id -> id.equals("killWithRicinDefault")).orElse(false)).findFirst().get();
        ComponentAst killWithRicinsOperation = (ComponentAst)killWithRicinAsChildElementFlow.directChildrenStream().findFirst().get();
        Either ricinsValue = killWithRicinsOperation.getParameter("General", "ricins").getValue();
        Assert.assertThat((String)ricinsValue.toString(), (Object)ricinsValue.isLeft(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((String)ricinsValue.toString(), (Object)((String)ricinsValue.getLeft()), (Matcher)CoreMatchers.is((Object)"payload"));
    }

    @Test
    @Issue(value="MULE-19264")
    public void parameterGroupNameWithSpacesIsMatchedWithDslWhenItShowsInTheDsl() {
        ArtifactAst artifactAst = this.buildArtifactAst("parameters-test-config.xml", DbConnector.class, PetStoreConnector.class);
        ComponentIdentifier PETSTORE_CONFIG_IDENTIFIER = ComponentIdentifier.builder().namespace("petstore").name("config").build();
        Optional<ComponentAst> optionalPetstoreConfigComponentAst = artifactAst.topLevelComponentsStream().filter(componentAst -> componentAst.getIdentifier().equals(PETSTORE_CONFIG_IDENTIFIER)).findFirst();
        Assert.assertThat(optionalPetstoreConfigComponentAst, (Matcher)Matchers.not(Optional.empty()));
        ComponentAst petstoreConfigComponentAst = optionalPetstoreConfigComponentAst.get();
        ComponentParameterAst brandParameter = petstoreConfigComponentAst.getParameter("Advanced Leash Configuration", "brand");
        Assert.assertThat((Object)brandParameter, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)((String)brandParameter.getValue().getLeft()), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)brandParameter.getValue().getRight(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        ComponentParameterAst materialParameter = petstoreConfigComponentAst.getParameter("Advanced Leash Configuration", "material");
        Assert.assertThat((Object)materialParameter, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)((String)materialParameter.getValue().getLeft()), (Matcher)CoreMatchers.is((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)materialParameter.getValue().getRight(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
    }

    @Test
    @Feature(value="Sources")
    @Issue(value="MULE-19331")
    public void schedulingStrategyParameterSchedulerSource() {
        ArtifactAst artifactAst = this.buildArtifactAst("parameters-test-config.xml", DbConnector.class, PetStoreConnector.class);
        ComponentAst schedulerFlowFixedSource = artifactAst.topLevelComponentsStream().filter(componentAst -> componentAst.getComponentId().map(id -> id.equals("schedulerFlowFixed")).orElse(false)).map(schedulerFlowFixed -> (ComponentAst)schedulerFlowFixed.directChildrenStream().findFirst().get()).findFirst().get();
        ComponentParameterAst schedulerFlowFixedSourceSchStrategy = schedulerFlowFixedSource.getParameter("General", "schedulingStrategy");
        Assert.assertThat((Object)schedulerFlowFixedSourceSchStrategy, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)((ComponentAst)schedulerFlowFixedSourceSchStrategy.getValue().getRight()).getIdentifier().getName(), (Matcher)CoreMatchers.is((Object)"fixed-frequency"));
    }

    @Test
    @Feature(value="Sources")
    @Issue(value="MULE-19331")
    public void fixedSchedulingStrategyParameterSdkPollingSource() {
        ArtifactAst artifactAst = this.buildArtifactAst("parameters-test-config.xml", DbConnector.class, PetStoreConnector.class);
        ComponentAst dbSchedulerFlowFixed = artifactAst.topLevelComponentsStream().filter(componentAst -> componentAst.getComponentId().map(id -> id.equals("dbSchedulerFlowFixed")).orElse(false)).map(schedulerFlowFixed -> (ComponentAst)schedulerFlowFixed.directChildrenStream().findFirst().get()).findFirst().get();
        ComponentParameterAst dbSchedulerFlowFixedSchStrategy = dbSchedulerFlowFixed.getParameter("General", "schedulingStrategy");
        Assert.assertThat((Object)dbSchedulerFlowFixedSchStrategy, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)((ComponentAst)dbSchedulerFlowFixedSchStrategy.getValue().getRight()).getIdentifier().getName(), (Matcher)CoreMatchers.is((Object)"fixed-frequency"));
    }

    @Test
    @Feature(value="Sources")
    @Issue(value="MULE-19331")
    public void cronSchedulingStrategyParameterSdkPollingSource() {
        ArtifactAst artifactAst = this.buildArtifactAst("parameters-test-config.xml", DbConnector.class, PetStoreConnector.class);
        ComponentAst dbSchedulerFlowCronSource = artifactAst.topLevelComponentsStream().filter(componentAst -> componentAst.getComponentId().map(id -> id.equals("dbSchedulerFlowCron")).orElse(false)).map(schedulerFlowFixed -> (ComponentAst)schedulerFlowFixed.directChildrenStream().findFirst().get()).findFirst().get();
        ComponentParameterAst dbSchedulerFlowCronSchStrategy = dbSchedulerFlowCronSource.getParameter("General", "schedulingStrategy");
        Assert.assertThat((Object)dbSchedulerFlowCronSchStrategy, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)((ComponentAst)dbSchedulerFlowCronSchStrategy.getValue().getRight()).getIdentifier().getName(), (Matcher)CoreMatchers.is((Object)"cron"));
    }

    @Test
    public void configPojoParameter() {
        ArtifactAst artifactAst = this.buildArtifactAst("parameters-test-pojo-config.xml", HeisenbergExtension.class, SubTypesMappingConnector.class, VeganExtension.class);
        ComponentAst appleConfig = artifactAst.topLevelComponentsStream().filter(componentAst -> componentAst.getComponentId().map(id -> id.equals("apple")).orElse(false)).findFirst().get();
        ComponentParameterAst cookBookParam = appleConfig.getParameter("General", "cookBook");
        Assert.assertThat((Object)cookBookParam, (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        Assert.assertThat((Object)((ComponentAst)cookBookParam.getValue().getRight()).getIdentifier().getName(), (Matcher)CoreMatchers.is((Object)"vegan-cook-book"));
    }

    @Test
    @Issue(value="MULE-19676")
    public void configPojoParameterWithWrappedParamsHasNotTheWrapperAsChild() {
        ArtifactAst artifactAst = this.buildArtifactAst("parameters-test-pojo-config.xml", HeisenbergExtension.class, SubTypesMappingConnector.class, VeganExtension.class);
        ComponentAst appleConfig = artifactAst.topLevelComponentsStream().filter(componentAst -> componentAst.getComponentId().map(id -> id.equals("apple")).orElse(false)).findFirst().get();
        Assert.assertThat((Object)appleConfig.directChildren(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
    }

    @Test
    @Issue(value="MULE-19824")
    public void objectTagPropertiesHasNotTheWrapperAsChild() {
        ArtifactAst artifactAst = this.buildArtifactAst("parameters-test-pojo-config.xml", HeisenbergExtension.class, SubTypesMappingConnector.class, VeganExtension.class);
        ComponentAst object = artifactAst.topLevelComponentsStream().filter(componentAst -> componentAst.getComponentId().map(id -> id.equals("anObject")).orElse(false)).findFirst().get();
        Assert.assertThat((Object)object.directChildren(), (Matcher)CoreMatchers.is((Matcher)Matchers.empty()));
    }

    @Test
    @Issue(value="MULE-19770")
    public void cdataParameterNotTrimmed() {
        ArtifactAst artifactAst = this.buildArtifactAst("parameters-test-http-through-sockets-config.xml", SocketsExtension.class);
        ComponentAst httpRequestThroughSocketsFlow = artifactAst.topLevelComponentsStream().filter(componentAst -> componentAst.getComponentId().map(id -> id.equals("httpRequestThroughSockets")).orElse(false)).findFirst().get();
        ComponentAst sendAndReceiveOp = (ComponentAst)httpRequestThroughSocketsFlow.directChildren().get(0);
        ComponentParameterAst contentParam = sendAndReceiveOp.getParameter("General", "content");
        Assert.assertThat((Object)contentParam.getValue().getRight(), (Matcher)CoreMatchers.is((Object)"POST /test HTTP/1.1\nHost: localhost:8081\nTransfer-Encoding: chunked, deflate\n2\nOK\n0\n\n"));
    }

    @Test
    @Issue(value="MULE-19809")
    public void generationInformationSyntaxForNotAllowInlineDefinitionNestedParam() {
        if (!this.isPopulateGenerationInformation()) {
            return;
        }
        ArtifactAst artifactAst = this.buildArtifactAst("parameters-test-pojo-config.xml", HeisenbergExtension.class, SubTypesMappingConnector.class, VeganExtension.class);
        ComponentAst heisenbergConfig = artifactAst.topLevelComponentsStream().filter(componentAst -> componentAst.getComponentId().map(id -> id.equals("heisenberg")).orElse(false)).findFirst().get();
        Optional wildCardsSyntax = heisenbergConfig.getParameter("General", "wildCards").getGenerationInformation().getSyntax();
        Assert.assertThat((Object)wildCardsSyntax.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        Assert.assertThat((Object)((DslElementSyntax)wildCardsSyntax.get()).getElementName(), (Matcher)CoreMatchers.is((Object)"wild-cards"));
    }

    @Test
    @Issue(value="MULE-20047")
    public void pojoParamIsSubtypeFromAnotherExtension() {
        ArtifactAst artifactAst = this.buildArtifactAst("parameters-test-pojo-config.xml", HeisenbergExtension.class, SubTypesMappingConnector.class, VeganExtension.class);
        ComponentAst killWithRevolver = artifactAst.topLevelComponentsStream().filter(componentAst -> componentAst.getComponentId().map(id -> id.equals("killWithRevolver")).orElse(false)).findFirst().get();
        ComponentAst killOperation = (ComponentAst)killWithRevolver.directChildren().get(0);
        ComponentAst deadlyValue = (ComponentAst)killOperation.getParameter("General", "deadly").getValue().getRight();
        ComponentAst deadlyWeapon = (ComponentAst)deadlyValue.getParameter("Deadly", "weapon").getValue().getRight();
        Assert.assertThat((Object)killOperation.directChildren(), (Matcher)IsCollectionWithSize.hasSize((int)0));
        Assert.assertThat((Object)deadlyValue.directChildren(), (Matcher)IsCollectionWithSize.hasSize((int)0));
        Assert.assertThat((Object)deadlyWeapon.directChildren(), (Matcher)IsCollectionWithSize.hasSize((int)0));
        Assert.assertThat((Object)deadlyWeapon.getIdentifier().getNamespace(), (Matcher)CoreMatchers.is((Object)"subtypes"));
        Assert.assertThat((Object)deadlyWeapon.getIdentifier().getName(), (Matcher)CoreMatchers.is((Object)"revolver"));
        ComponentAst killWithRicin = artifactAst.topLevelComponentsStream().filter(componentAst -> componentAst.getComponentId().map(id -> id.equals("killWithRicin")).orElse(false)).findFirst().get();
        killOperation = (ComponentAst)killWithRicin.directChildren().get(0);
        deadlyValue = (ComponentAst)killOperation.getParameter("General", "deadly").getValue().getRight();
        deadlyWeapon = (ComponentAst)deadlyValue.getParameter("Deadly", "weapon").getValue().getRight();
        Assert.assertThat((Object)killOperation.directChildren(), (Matcher)IsCollectionWithSize.hasSize((int)0));
        Assert.assertThat((Object)deadlyValue.directChildren(), (Matcher)IsCollectionWithSize.hasSize((int)0));
        Assert.assertThat((Object)deadlyWeapon.directChildren(), (Matcher)IsCollectionWithSize.hasSize((int)0));
        Assert.assertThat((Object)deadlyWeapon.getIdentifier().getNamespace(), (Matcher)CoreMatchers.is((Object)"heisenberg"));
        Assert.assertThat((Object)deadlyWeapon.getIdentifier().getName(), (Matcher)CoreMatchers.is((Object)"ricin"));
        ComponentAst destination = (ComponentAst)deadlyWeapon.getParameter("Ricin", "destination").getValue().getRight();
        Assert.assertThat((Object)destination.getParameter("door", "victim").getValue().getRight(), (Matcher)CoreMatchers.is((Object)"Lidia"));
        Assert.assertThat((Object)destination.directChildren(), (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    private void assertParameters(ComponentAst container, String containerParameterGroupName, String containerParameterName, String elementParameterGroupName, String elementParameterName, String ... rightValues) {
        ComponentParameterAst containerParameter = container.getParameter(containerParameterGroupName, containerParameterName);
        Assert.assertThat((Object)((String)containerParameter.getValue().getLeft()), (Matcher)Matchers.nullValue());
        Assert.assertThat((Object)containerParameter.getValue().getRight(), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
        List elementComponents = (List)containerParameter.getValue().getRight();
        String[] actual = (String[])elementComponents.stream().map(componentAst -> {
            ComponentParameterAst elementParameter = componentAst.getParameter(elementParameterGroupName, elementParameterName);
            Assert.assertThat((Object)((String)elementParameter.getValue().getLeft()), (Matcher)Matchers.nullValue());
            return (String)elementParameter.getValue().getRight();
        }).toArray(String[]::new);
        Assert.assertThat((Object)actual, (Matcher)ArrayMatching.arrayContaining((Object[])rightValues));
    }
}

