/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.extension.dsl;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.junit.Before;
import org.junit.Test;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.construct.HasConstructModels;
import org.mule.runtime.api.meta.model.nested.NestableElementModelVisitor;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.api.meta.model.nested.NestedComponentModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.fluent.ArtifactDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ComponentElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConfigurationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConnectionElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConstructElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.OperationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ParameterListValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterObjectValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterSimpleValue;
import org.mule.runtime.app.declaration.api.fluent.ParameterizedElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.RouteElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.SourceElementDeclarer;
import org.mule.runtime.config.api.dsl.ArtifactDeclarationXmlSerializer;
import org.mule.runtime.config.api.dsl.model.DslElementModelFactory;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.property.QNameModelProperty;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;
import org.mule.test.extension.dsl.AbstractElementModelTestCase;

public class BulkArtifactDeclarationTestCase
extends AbstractElementModelTestCase {
    private static final String EXPECTED_XML = "core-bulk-extension-model.xml";
    private static final boolean UPDATE_EXPECTED_FILES_ON_ERROR = Boolean.getBoolean("mule.appXml.updateExpectedFilesOnError");
    private ArtifactDeclarationXmlSerializer serializer;
    private DslSyntaxResolver dslResolver;

    protected String[] getConfigFiles() {
        return new String[0];
    }

    @Override
    @Before
    public void setup() throws Exception {
        Set extensions = muleContext.getExtensionManager().getExtensions();
        this.dslContext = DslResolvingContext.getDefault((Set)ImmutableSet.builder().addAll((Iterable)extensions).add((Object)MuleExtensionModelProvider.getExtensionModel()).build());
        this.modelResolver = DslElementModelFactory.getDefault((DslResolvingContext)this.dslContext);
        this.serializer = ArtifactDeclarationXmlSerializer.getDefault((DslResolvingContext)this.dslContext);
    }

    private boolean shouldUpdateExpectedFilesOnError() {
        return UPDATE_EXPECTED_FILES_ON_ERROR;
    }

    @Test
    public void bulkDeclaration() throws Exception {
        ExtensionModel extensionModel = MuleExtensionModelProvider.getExtensionModel();
        final ElementDeclarer core = ElementDeclarer.forExtension((String)extensionModel.getName());
        final ArtifactDeclarer artifactDeclarer = ElementDeclarer.newArtifact();
        this.dslResolver = DslSyntaxResolver.getDefault((ExtensionModel)extensionModel, (DslResolvingContext)this.dslContext);
        new ExtensionWalker(){

            protected void onConfiguration(ConfigurationModel configModel) {
                if (configModel.getConnectionProviders().isEmpty()) {
                    ConfigurationElementDeclarer declarer = core.newConfiguration(configModel.getName()).withRefName("config");
                    BulkArtifactDeclarationTestCase.this.populateParameterized((ParameterizedModel)configModel, (ParameterizedElementDeclarer)declarer);
                    artifactDeclarer.withGlobalElement((GlobalElementDeclaration)declarer.getDeclaration());
                } else {
                    configModel.getConnectionProviders().forEach(connection -> {
                        ConnectionElementDeclarer connectionDeclarer = core.newConnection(connection.getName());
                        BulkArtifactDeclarationTestCase.this.populateParameterized((ParameterizedModel)connection, (ParameterizedElementDeclarer)connectionDeclarer);
                        ConfigurationElementDeclarer configurationDeclarer = core.newConfiguration(configModel.getName()).withRefName("config" + connection.getName()).withConnection((ConnectionElementDeclaration)connectionDeclarer.getDeclaration());
                        BulkArtifactDeclarationTestCase.this.populateParameterized((ParameterizedModel)configModel, (ParameterizedElementDeclarer)configurationDeclarer);
                        artifactDeclarer.withGlobalElement((GlobalElementDeclaration)configurationDeclarer.getDeclaration());
                    });
                }
            }

            protected void onConstruct(HasConstructModels owner, ConstructModel model) {
                ConstructElementDeclarer declarer = core.newConstruct(model.getName());
                BulkArtifactDeclarationTestCase.this.populateParameterized((ParameterizedModel)model, (ParameterizedElementDeclarer)declarer);
                this.populateNested((ComponentModel)model, (ComponentElementDeclarer)declarer);
                if (model.allowsTopLevelDeclaration()) {
                    artifactDeclarer.withGlobalElement((GlobalElementDeclaration)declarer.withRefName("global-" + model.getName()).getDeclaration());
                } else {
                    artifactDeclarer.withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("flowFor-" + model.getName()).withComponent((ComponentElementDeclaration)declarer.getDeclaration())).getDeclaration());
                }
            }

            protected void onOperation(HasOperationModels owner, OperationModel model) {
                if (model.getName().equals("flowRef")) {
                    return;
                }
                OperationElementDeclarer declarer = core.newOperation(model.getName());
                BulkArtifactDeclarationTestCase.this.populateParameterized((ParameterizedModel)model, (ParameterizedElementDeclarer)declarer);
                this.populateNested((ComponentModel)model, (ComponentElementDeclarer)declarer);
                artifactDeclarer.withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("flowFor-" + model.getName()).withComponent((ComponentElementDeclaration)declarer.getDeclaration())).getDeclaration());
            }

            protected void onSource(HasSourceModels owner, SourceModel model) {
                SourceElementDeclarer declarer = core.newSource(model.getName());
                BulkArtifactDeclarationTestCase.this.populateParameterized((ParameterizedModel)model, (ParameterizedElementDeclarer)declarer);
                artifactDeclarer.withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("flowFor-" + model.getName()).withComponent((ComponentElementDeclaration)declarer.getDeclaration())).getDeclaration());
            }

            private void populateNested(ComponentModel model, final ComponentElementDeclarer declarer) {
                model.getNestedComponents().forEach(nestedPlaceholder -> nestedPlaceholder.accept(new NestableElementModelVisitor(){

                    public void visit(NestedComponentModel component) {
                        declarer.withComponent((ComponentElementDeclaration)core.newOperation("logger").getDeclaration());
                    }

                    public void visit(NestedChainModel component) {
                        declarer.withComponent((ComponentElementDeclaration)core.newOperation("logger").getDeclaration());
                    }

                    public void visit(NestedRouteModel component) {
                        RouteElementDeclarer routeDeclarer = core.newRoute(component.getName());
                        BulkArtifactDeclarationTestCase.this.populateParameterized((ParameterizedModel)component, (ParameterizedElementDeclarer)routeDeclarer);
                        routeDeclarer.withComponent((ComponentElementDeclaration)core.newOperation("logger").getDeclaration());
                        declarer.withComponent((ComponentElementDeclaration)routeDeclarer.getDeclaration());
                    }
                }));
            }
        }.walk(extensionModel);
        String serializationResult = this.serializer.serialize((ArtifactDeclaration)artifactDeclarer.getDeclaration());
        String expected = IOUtils.getResourceAsString((String)EXPECTED_XML, ((Object)((Object)this)).getClass());
        try {
            BulkArtifactDeclarationTestCase.compareXML(expected, serializationResult);
        }
        catch (Throwable t) {
            if (this.shouldUpdateExpectedFilesOnError()) {
                File root = new File(IOUtils.getResourceAsUrl((String)EXPECTED_XML, ((Object)((Object)this)).getClass()).toURI()).getParentFile().getParentFile().getParentFile();
                File testDir = new File(root, "src/test/resources");
                File target = new File(testDir, EXPECTED_XML);
                FileUtils.stringToFile((String)target.getAbsolutePath(), (String)serializationResult);
                System.out.println(expected + " fixed");
            }
            throw t;
        }
    }

    private void populateParameterized(ParameterizedModel model, ParameterizedElementDeclarer<?, ?> parameterizedDeclarer) {
        model.getParameterGroupModels().forEach(group -> parameterizedDeclarer.withParameterGroup(groupDeclarer -> {
            groupDeclarer.withName(group.getName());
            group.getParameterModels().stream().filter(p -> !(p.getType() instanceof UnionType)).filter(p -> !p.getModelProperty(QNameModelProperty.class).isPresent()).forEach(param -> this.addParameter(param.getType(), ExtensionModelUtils.isContent((ParameterModel)param) || param.getExpressionSupport().equals((Object)ExpressionSupport.REQUIRED), ExtensionModelUtils.isText((ParameterModel)param), this.allowsReferences((ParameterModel)param), Optional.ofNullable(param.getDefaultValue()), param.getAllowedStereotypes(), value -> groupDeclarer.withParameter(param.getName(), value)));
        }));
    }

    private boolean allowsReferences(ParameterModel param) {
        return param.getDslConfiguration().allowsReferences();
    }

    private void addParameter(MetadataType type, final boolean isContent, final boolean isText, final boolean allowsReferences, final Optional<Object> defaultValue, final List<StereotypeModel> allowedStereotypes, final Consumer<ParameterValue> valueConsumer) {
        type.accept(new MetadataTypeVisitor(){

            protected void defaultVisit(MetadataType metadataType) {
                if (isContent) {
                    valueConsumer.accept(ParameterSimpleValue.of((String)String.valueOf(defaultValue.orElse("#['ExpressionAttribute']"))));
                } else if (isText) {
                    valueConsumer.accept(ParameterSimpleValue.cdata((String)String.valueOf(defaultValue.orElse("Attribute\nText"))));
                } else {
                    String fallback = allowedStereotypes.isEmpty() ? "Attribute" : allowedStereotypes.stream().map(Object::toString).collect(Collectors.joining("|"));
                    valueConsumer.accept(ParameterSimpleValue.of((String)String.valueOf(defaultValue.orElse(fallback))));
                }
            }

            public void visitNumber(NumberType numberType) {
                valueConsumer.accept(ParameterSimpleValue.of((String)String.valueOf(defaultValue.orElse("10000"))));
            }

            public void visitArrayType(ArrayType arrayType) {
                if (isContent) {
                    this.defaultVisit((MetadataType)arrayType);
                    return;
                }
                ParameterListValue.Builder listValue = ElementDeclarer.newListValue();
                BulkArtifactDeclarationTestCase.this.addParameter(arrayType.getType(), false, false, false, Optional.empty(), Collections.emptyList(), arg_0 -> ((ParameterListValue.Builder)listValue).withValue(arg_0));
                BulkArtifactDeclarationTestCase.this.addParameter(arrayType.getType(), false, false, false, Optional.empty(), Collections.emptyList(), arg_0 -> ((ParameterListValue.Builder)listValue).withValue(arg_0));
                valueConsumer.accept(listValue.build());
            }

            public void visitObject(ObjectType objectType) {
                if (isContent || allowsReferences || !BulkArtifactDeclarationTestCase.this.supportsInlineDeclaration(objectType).booleanValue() && !BulkArtifactDeclarationTestCase.this.isWrapped(objectType).booleanValue()) {
                    this.defaultVisit((MetadataType)objectType);
                    return;
                }
                ParameterObjectValue.Builder objectValue = ElementDeclarer.newObjectValue();
                ExtensionMetadataTypeUtils.getId((MetadataType)objectType).ifPresent(arg_0 -> ((ParameterObjectValue.Builder)objectValue).ofType(arg_0));
                objectType.getFields().forEach(field -> BulkArtifactDeclarationTestCase.this.addParameter(field.getValue(), false, false, false, Optional.ofNullable(MetadataTypeUtils.getDefaultValue((MetadataType)field.getValue()).orElse(null)), Collections.emptyList(), fieldValue -> objectValue.withParameter(ExtensionMetadataTypeUtils.getAlias((ObjectFieldType)field), fieldValue)));
                valueConsumer.accept(objectValue.build());
            }
        });
    }

    private Boolean supportsInlineDeclaration(ObjectType objectType) {
        return this.dslResolver.resolve((MetadataType)objectType).map(DslElementSyntax::supportsChildDeclaration).orElse(false);
    }

    private Boolean isWrapped(ObjectType objectType) {
        return this.dslResolver.resolve((MetadataType)objectType).map(DslElementSyntax::isWrapped).orElse(false);
    }
}

