/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.extension.dsl;

import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runners.Parameterized;
import org.mule.extensions.jms.api.connection.caching.NoCachingConfiguration;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.app.declaration.serialization.ArtifactDeclarationJsonSerializer;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ComponentElementDeclaration;
import org.mule.runtime.app.declaration.api.ConnectionElementDeclaration;
import org.mule.runtime.app.declaration.api.GlobalElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterGroupElementDeclaration;
import org.mule.runtime.app.declaration.api.ParameterValue;
import org.mule.runtime.app.declaration.api.RouteElementDeclaration;
import org.mule.runtime.app.declaration.api.fluent.ArtifactDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConfigurationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConnectionElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ConstructElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.OperationElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.ParameterSimpleValue;
import org.mule.runtime.app.declaration.api.fluent.RouteElementDeclarer;
import org.mule.runtime.app.declaration.api.fluent.SimpleValueType;
import org.mule.runtime.app.declaration.api.fluent.SourceElementDeclarer;
import org.mule.runtime.ast.api.DependencyResolutionMode;
import org.mule.runtime.config.api.dsl.ArtifactDeclarationXmlSerializer;
import org.mule.runtime.core.api.extension.provider.MuleExtensionModelProvider;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.extension.api.runtime.ExpirationPolicy;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.tck.junit4.rule.SystemProperty;
import org.mule.test.extension.dsl.AbstractElementModelTestCase;
import org.mule.test.runner.RunnerDelegateTo;
import org.skyscreamer.jsonassert.JSONAssert;
import org.skyscreamer.jsonassert.JSONCompareMode;

@RunnerDelegateTo(value=Parameterized.class)
public class ArtifactDeclarationSerializerTestCase
extends AbstractElementModelTestCase {
    @Rule
    public SystemProperty minimalDependencies = new SystemProperty("mule." + DependencyResolutionMode.class.getName(), DependencyResolutionMode.MINIMAL.name());
    private static final boolean UPDATE_EXPECTED_FILES_ON_ERROR = Boolean.getBoolean("mule.appJson.updateExpectedFilesOnError");
    @Rule
    public DynamicPort port = new DynamicPort("port");
    @Rule
    public DynamicPort otherPort = new DynamicPort("otherPort");
    private String expectedAppXml;
    private String expectedAppJson;
    @Parameterized.Parameter(value=0)
    public String configFile;
    @Parameterized.Parameter(value=1)
    public ArtifactDeclaration applicationDeclaration;
    @Parameterized.Parameter(value=2)
    public String declarationFile;
    @Parameterized.Parameter(value=3)
    public String declarationFileOld;

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return Arrays.asList({"full-artifact-config-dsl-app.xml", ArtifactDeclarationSerializerTestCase.createFullArtifactDeclaration(), "full-artifact-config-dsl-app.json", "full-artifact-config-dsl-app-old.json"}, {"multi-flow-dsl-app.xml", ArtifactDeclarationSerializerTestCase.createMultiFlowArtifactDeclaration(), "multi-flow-dsl-app.json", "multi-flow-dsl-app.json"}, {"no-mule-components-dsl-app.xml", ArtifactDeclarationSerializerTestCase.createNoMuleComponentsArtifactDeclaration(), "no-mule-components-dsl-app.json", "no-mule-components-dsl-app.json"});
    }

    private boolean shouldUpdateExpectedFilesOnError() {
        return UPDATE_EXPECTED_FILES_ON_ERROR;
    }

    @Before
    public void loadExpectedResult() throws IOException {
        this.expectedAppXml = IOUtils.getResourceAsString((String)this.configFile, ((Object)((Object)this)).getClass());
        JsonParser parser = new JsonParser();
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream(this.declarationFile)));
        this.expectedAppJson = parser.parse(reader).toString();
    }

    @Test
    public void deserialize() throws Exception {
        JsonParser parser = new JsonParser();
        JsonReader reader = new JsonReader((Reader)new InputStreamReader(Thread.currentThread().getContextClassLoader().getResourceAsStream(this.declarationFileOld)));
        ArtifactDeclarationJsonSerializer jsonSerializer = ArtifactDeclarationJsonSerializer.getDefault((boolean)true);
        ArtifactDeclaration deserialized = jsonSerializer.deserialize(parser.parse(reader).toString());
        ArtifactDeclarationSerializerTestCase.compareXML(this.expectedAppXml, ArtifactDeclarationXmlSerializer.getDefault((DslResolvingContext)this.dslContext).serialize(deserialized));
    }

    @Test
    public void serialize() throws Exception {
        String serializationResult = ArtifactDeclarationXmlSerializer.getDefault((DslResolvingContext)this.dslContext).serialize(this.applicationDeclaration);
        ArtifactDeclarationSerializerTestCase.compareXML(this.expectedAppXml, serializationResult);
    }

    @Test
    public void loadCustomConfigParameters() {
        InputStream configIs = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.configFile);
        ArtifactDeclarationXmlSerializer serializer = ArtifactDeclarationXmlSerializer.getDefault((DslResolvingContext)this.dslContext);
        ArtifactDeclaration artifact = serializer.deserialize(configIs);
        List<String> expectedCustomParams = Arrays.asList("xmlns", "xmlns:xsi", "xsi:schemaLocation");
        List customParameters = artifact.getCustomConfigurationParameters();
        expectedCustomParams.forEach(custom -> MatcherAssert.assertThat((String)("Missing parameter: " + custom), (Object)customParameters.stream().anyMatch(p -> p.getName().equals(custom)), (Matcher)Matchers.is((Object)true)));
    }

    @Test
    public void loadAndSerialize() throws Exception {
        InputStream configIs = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.configFile);
        ArtifactDeclarationXmlSerializer serializer = ArtifactDeclarationXmlSerializer.getDefault((DslResolvingContext)this.dslContext);
        ArtifactDeclaration artifact = serializer.deserialize(configIs);
        String serializationResult = serializer.serialize(artifact);
        ArtifactDeclarationSerializerTestCase.compareXML(this.expectedAppXml, serializationResult);
    }

    @Test
    public void serializesToJson() throws URISyntaxException, IOException {
        InputStream configIs = Thread.currentThread().getContextClassLoader().getResourceAsStream(this.configFile);
        ArtifactDeclarationXmlSerializer serializer = ArtifactDeclarationXmlSerializer.getDefault((DslResolvingContext)this.dslContext);
        ArtifactDeclaration expectedDeclaration = serializer.deserialize(configIs);
        ArtifactDeclarationJsonSerializer jsonSerializer = ArtifactDeclarationJsonSerializer.getDefault((boolean)true);
        String actualAppJson = jsonSerializer.serialize(expectedDeclaration);
        try {
            JSONAssert.assertEquals((String)this.expectedAppJson, (String)actualAppJson, (JSONCompareMode)JSONCompareMode.NON_EXTENSIBLE);
        }
        catch (AssertionError e) {
            if (this.shouldUpdateExpectedFilesOnError()) {
                this.updateExpectedJson(actualAppJson);
            }
            System.out.println(actualAppJson);
            throw e;
        }
    }

    private void updateExpectedJson(String json) throws URISyntaxException, IOException {
        File root = new File(IOUtils.getResourceAsUrl((String)this.declarationFile, ((Object)((Object)this)).getClass()).toURI()).getParentFile().getParentFile().getParentFile();
        File testDir = new File(root, "src/test/resources");
        File target = new File(testDir, this.declarationFile);
        FileUtils.stringToFile((String)target.getAbsolutePath(), (String)json);
        System.out.println(this.declarationFile + " fixed");
    }

    protected String[] getConfigFiles() {
        return new String[0];
    }

    private static ArtifactDeclaration createMultiFlowArtifactDeclaration() {
        ElementDeclarer jms = ElementDeclarer.forExtension((String)"JMS");
        ElementDeclarer core = ElementDeclarer.forExtension((String)"mule");
        return (ArtifactDeclaration)ElementDeclarer.newArtifact().withGlobalElement((GlobalElementDeclaration)jms.newConfiguration("config").withRefName("config").withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)jms.newConnection("active-mq").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("cachingStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType(NoCachingConfiguration.class.getName()).build()).getDeclaration())).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("send-payload").withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)((OperationElementDeclarer)jms.newOperation("publish").withConfig("config")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("destination", ArtifactDeclarationSerializerTestCase.createStringParameter("#[initialDestination]")).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Message").withParameter("body", ArtifactDeclarationSerializerTestCase.createStringParameter("#[payload]")).withParameter("properties", ArtifactDeclarationSerializerTestCase.createStringParameter("#[{(initialProperty): propertyValue}]")).getDeclaration())).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("bridge").withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)jms.newOperation("consume").withConfig("config")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("destination", ArtifactDeclarationSerializerTestCase.createStringParameter("#[initialDestination]")).withParameter("maximumWait", ArtifactDeclarationSerializerTestCase.createNumberParameter("1000")).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)core.newOperation("foreach").withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)((OperationElementDeclarer)jms.newOperation("publish").withConfig("config")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("destination", ArtifactDeclarationSerializerTestCase.createStringParameter("#[finalDestination]")).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Message").withParameter("jmsxProperties", ArtifactDeclarationSerializerTestCase.createStringParameter("#[attributes.properties.jmsxProperties]")).withParameter("body", ArtifactDeclarationSerializerTestCase.createStringParameter("#[bridgePrefix ++ payload]")).withParameter("properties", ArtifactDeclarationSerializerTestCase.createStringParameter("#[attributes.properties.userProperties]")).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)core.newOperation("logger").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("message", ArtifactDeclarationSerializerTestCase.createStringParameter("Message Sent")).getDeclaration())).getDeclaration())).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("jmsListener").withParameterGroup(group -> group.withParameter("initialState", ArtifactDeclarationSerializerTestCase.createStringParameter("stopped")))).withComponent((ComponentElementDeclaration)((SourceElementDeclarer)((SourceElementDeclarer)jms.newSource("listener").withConfig("config")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("destination", "listen-queue").withParameter("transactionType", ArtifactDeclarationSerializerTestCase.createStringParameter("LOCAL")).withParameter("primaryNodeOnly", ArtifactDeclarationSerializerTestCase.createBooleanParameter("false")).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)jms.newOperation("consume").withConfig("config")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("destination", ArtifactDeclarationSerializerTestCase.createStringParameter("#[finalDestination]")).withParameter("maximumWait", ArtifactDeclarationSerializerTestCase.createNumberParameter("1000")).getDeclaration())).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("bridge-receiver").withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)jms.newOperation("consume").withConfig("config")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("destination", ArtifactDeclarationSerializerTestCase.createStringParameter("#[finalDestination]")).withParameter("maximumWait", ArtifactDeclarationSerializerTestCase.createNumberParameter("1000")).getDeclaration())).getDeclaration())).getDeclaration()).getDeclaration();
    }

    private static ArtifactDeclaration createFullArtifactDeclaration() {
        ElementDeclarer core = ElementDeclarer.forExtension((String)"mule");
        ElementDeclarer db = ElementDeclarer.forExtension((String)"Database");
        ElementDeclarer http = ElementDeclarer.forExtension((String)"HTTP");
        ElementDeclarer sockets = ElementDeclarer.forExtension((String)"Sockets");
        ElementDeclarer wsc = ElementDeclarer.forExtension((String)"Web Service Consumer");
        ElementDeclarer file = ElementDeclarer.forExtension((String)"File");
        ElementDeclarer os = ElementDeclarer.forExtension((String)"ObjectStore");
        return (ArtifactDeclaration)((ArtifactDeclarer)ElementDeclarer.newArtifact().withCustomParameter("xmlns:doc", "http://www.mulesoft.org/schema/mule/documentation")).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)core.newConstruct("configuration").withParameterGroup(group -> group.withParameter("defaultErrorHandler-ref", ArtifactDeclarationSerializerTestCase.createStringParameter("referableHandler")))).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("object").withRefName("myString").withParameterGroup(group -> group.withParameter("class", ArtifactDeclarationSerializerTestCase.createStringParameter("java.lang.String")))).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("property", (ParameterValue)ElementDeclarer.newObjectValue().ofType(BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType().with((TypeAnnotation)new ClassInformationAnnotation(Map.class, Arrays.asList(String.class, String.class))).openWith(MuleExtensionModelProvider.STRING_TYPE).build().toString()).build()).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)core.newConstruct("errorHandler").withRefName("referableHandler").withComponent((ComponentElementDeclaration)((RouteElementDeclarer)core.newRoute("onErrorContinue").withParameterGroup(group -> group.withParameter("type", ArtifactDeclarationSerializerTestCase.createStringParameter("MULE:SOURCE_RESPONSE")).withParameter("logException", ArtifactDeclarationSerializerTestCase.createBooleanParameter("false")).withParameter("enableNotifications", ArtifactDeclarationSerializerTestCase.createBooleanParameter("false")))).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)core.newOperation("logger").withParameterGroup(group -> group.withParameter("level", ArtifactDeclarationSerializerTestCase.createStringParameter("TRACE")))).getDeclaration()).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)os.newGlobalParameter("objectStore").withRefName("persistentStore").withValue(ElementDeclarer.newObjectValue().ofType("org.mule.extension.objectstore.api.TopLevelObjectStore").withParameter("entryTtl", ArtifactDeclarationSerializerTestCase.createNumberParameter("1")).withParameter("entryTtlUnit", ArtifactDeclarationSerializerTestCase.createStringParameter("HOURS")).withParameter("maxEntries", ArtifactDeclarationSerializerTestCase.createNumberParameter("10")).withParameter("persistent", ArtifactDeclarationSerializerTestCase.createBooleanParameter("true")).withParameter("expirationInterval", ArtifactDeclarationSerializerTestCase.createNumberParameter("2")).withParameter("expirationIntervalUnit", ArtifactDeclarationSerializerTestCase.createStringParameter("HOURS")).withParameter("config-ref", ArtifactDeclarationSerializerTestCase.createStringParameter("persistentConfig")).build()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)os.newConfiguration("config").withRefName("persistentConfig").getDeclaration()).withGlobalElement((GlobalElementDeclaration)db.newConfiguration("config").withRefName("dbConfig").withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)((ConnectionElementDeclarer)db.newConnection("derby").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("poolingProfile", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("maxPoolSize", ArtifactDeclarationSerializerTestCase.createNumberParameter("10")).build()).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Connection").withParameter("connectionProperties", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("first", ArtifactDeclarationSerializerTestCase.createStringParameter("propertyOne")).withParameter("second", ArtifactDeclarationSerializerTestCase.createStringParameter("propertyTwo")).build()).withParameter("database", ArtifactDeclarationSerializerTestCase.createStringParameter("target/muleEmbeddedDB")).withParameter("create", ArtifactDeclarationSerializerTestCase.createBooleanParameter("true")).getDeclaration())).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)file.newConfiguration("config").withRefName("fileConfig").withConnection((ConnectionElementDeclaration)file.newConnection("connection").getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConfigurationElementDeclarer)wsc.newConfiguration("config").withRefName("wscConfig").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("expirationPolicy", (ParameterValue)ElementDeclarer.newObjectValue().ofType(ExpirationPolicy.class.getName()).withParameter("maxIdleTime", ArtifactDeclarationSerializerTestCase.createNumberParameter("1")).withParameter("timeUnit", ArtifactDeclarationSerializerTestCase.createStringParameter(TimeUnit.MINUTES.name())).build()).getDeclaration())).withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)((ConnectionElementDeclarer)wsc.newConnection("connection").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("soapVersion", ArtifactDeclarationSerializerTestCase.createStringParameter("SOAP11")).withParameter("mtomEnabled", ArtifactDeclarationSerializerTestCase.createBooleanParameter("false")).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Connection").withParameter("wsdlLocation", ArtifactDeclarationSerializerTestCase.createStringParameter("http://www.webservicex.com/globalweather.asmx?WSDL")).withParameter("address", ArtifactDeclarationSerializerTestCase.createStringParameter("http://www.webservicex.com/globalweather.asmx")).withParameter("service", ArtifactDeclarationSerializerTestCase.createStringParameter("GlobalWeather")).withParameter("port", ArtifactDeclarationSerializerTestCase.createStringParameter("GlobalWeatherSoap")).getDeclaration())).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)db.newConfiguration("config").withRefName("dbConfig").withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)((ConnectionElementDeclarer)db.newConnection("derby").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("poolingProfile", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("maxPoolSize", ArtifactDeclarationSerializerTestCase.createNumberParameter("10")).build()).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Connection").withParameter("connectionProperties", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("first", ArtifactDeclarationSerializerTestCase.createStringParameter("propertyOne")).withParameter("second", ArtifactDeclarationSerializerTestCase.createStringParameter("propertyTwo")).build()).withParameter("reconnection", (ParameterValue)ElementDeclarer.newObjectValue().ofType("Reconnection").withParameter("failsDeployment", ArtifactDeclarationSerializerTestCase.createBooleanParameter("true")).withParameter("reconnectionStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("reconnect").withParameter("count", ArtifactDeclarationSerializerTestCase.createNumberParameter("1")).withParameter("frequency", ArtifactDeclarationSerializerTestCase.createNumberParameter("0")).build()).build()).withParameter("database", ArtifactDeclarationSerializerTestCase.createStringParameter("target/muleEmbeddedDB")).withParameter("create", ArtifactDeclarationSerializerTestCase.createBooleanParameter("true")).getDeclaration())).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConfigurationElementDeclarer)http.newConfiguration("listenerConfig").withRefName("httpListener").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("basePath", ArtifactDeclarationSerializerTestCase.createStringParameter("/")).getDeclaration())).withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)((ConnectionElementDeclarer)http.newConnection("listener").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("tlsContext", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("key-store", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("path", ArtifactDeclarationSerializerTestCase.createStringParameter("ssltest-keystore.jks")).withParameter("password", ArtifactDeclarationSerializerTestCase.createStringParameter("changeit")).withParameter("keyPassword", ArtifactDeclarationSerializerTestCase.createStringParameter("changeit")).build()).withParameter("trust-store", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("insecure", ArtifactDeclarationSerializerTestCase.createBooleanParameter("true")).build()).withParameter("revocation-check", (ParameterValue)ElementDeclarer.newObjectValue().ofType("standard-revocation-check").withParameter("onlyEndEntities", ArtifactDeclarationSerializerTestCase.createBooleanParameter("true")).build()).build()).getDeclaration())).withParameterGroup(group -> group.withName("Connection").withParameter("host", ArtifactDeclarationSerializerTestCase.createStringParameter("localhost")).withParameter("port", ArtifactDeclarationSerializerTestCase.createNumberParameter("${port}")).withParameter("protocol", ArtifactDeclarationSerializerTestCase.createStringParameter("HTTPS")))).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConfigurationElementDeclarer)http.newConfiguration("requestConfig").withRefName("httpRequester").withParameterGroup(group -> group.withName("Request Settings").withParameter("requestStreamingMode", ArtifactDeclarationSerializerTestCase.createStringParameter("ALWAYS")).withParameter("defaultHeaders", (ParameterValue)ElementDeclarer.newListValue().withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("key", ArtifactDeclarationSerializerTestCase.createStringParameter("testDefault")).withParameter("value", ArtifactDeclarationSerializerTestCase.createStringParameter("testDefaultValue")).build()).build()))).withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)((ConnectionElementDeclarer)http.newConnection("request").withParameterGroup(group -> group.withParameter("authentication", (ParameterValue)ElementDeclarer.newObjectValue().ofType("org.mule.extension.http.api.request.authentication.BasicAuthentication").withParameter("username", ArtifactDeclarationSerializerTestCase.createStringParameter("user")).withParameter("password", ArtifactDeclarationSerializerTestCase.createStringParameter("pass")).build()))).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Connection").withParameter("host", ArtifactDeclarationSerializerTestCase.createStringParameter("localhost")).withParameter("port", ArtifactDeclarationSerializerTestCase.createNumberParameter("${otherPort}")).withParameter("clientSocketProperties", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("connectionTimeout", ArtifactDeclarationSerializerTestCase.createNumberParameter("1000")).withParameter("keepAlive", ArtifactDeclarationSerializerTestCase.createBooleanParameter("true")).withParameter("receiveBufferSize", ArtifactDeclarationSerializerTestCase.createNumberParameter("1024")).withParameter("sendBufferSize", ArtifactDeclarationSerializerTestCase.createNumberParameter("1024")).withParameter("clientTimeout", ArtifactDeclarationSerializerTestCase.createNumberParameter("1000")).withParameter("linger", ArtifactDeclarationSerializerTestCase.createNumberParameter("1000")).build()).getDeclaration())).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("testFlow").withCustomParameter("doc:id", "docUUID")).withParameterGroup(group -> group.withParameter("initialState", ArtifactDeclarationSerializerTestCase.createStringParameter("stopped")))).withComponent((ComponentElementDeclaration)((SourceElementDeclarer)((SourceElementDeclarer)((SourceElementDeclarer)((SourceElementDeclarer)((SourceElementDeclarer)http.newSource("listener").withConfig("httpListener")).withCustomParameter("doc:id", "docUUID")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("path", ArtifactDeclarationSerializerTestCase.createStringParameter("testBuilder")).withParameter("redeliveryPolicy", (ParameterValue)ElementDeclarer.newObjectValue().withParameter("maxRedeliveryCount", ArtifactDeclarationSerializerTestCase.createNumberParameter("2")).withParameter("useSecureHash", ArtifactDeclarationSerializerTestCase.createBooleanParameter("true")).build()).getDeclaration())).withParameterGroup(group -> group.withName("Connection").withParameter("reconnectionStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("reconnect").withParameter("count", ArtifactDeclarationSerializerTestCase.createNumberParameter("1")).withParameter("frequency", ArtifactDeclarationSerializerTestCase.createNumberParameter("0")).build()))).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Response").withParameter("headers", ArtifactDeclarationSerializerTestCase.createStringCDataParameter("<![CDATA[#[{{'content-type' : 'text/plain'}}]]]>")).withParameter("body", ArtifactDeclarationSerializerTestCase.createStringCDataParameter("<![CDATA[#[\n                    %dw 2.0\n                    output application/json\n                    input payload application/xml\n                    var baseUrl=\"http://sample.cloudhub.io/api/v1.0/\"\n                    ---\n                    using (pageSize = payload.getItemsResponse.PageInfo.pageSize) {\n                         links: [\n                            {\n                                href: fullUrl,\n                                rel : \"self\"\n                            }\n                         ],\n                         collection: {\n                            size: pageSize,\n                            items: payload.getItemsResponse.*Item map {\n                                id: $.id,\n                                type: $.type,\n                                name: $.name\n                            }\n                         }\n                    }\n                ]]>")).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)core.newOperation("choice").withRoute((RouteElementDeclaration)((RouteElementDeclarer)core.newRoute("when").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("expression", ArtifactDeclarationSerializerTestCase.createStringParameter("#[true]")).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)db.newOperation("bulkInsert").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("transactionalAction", ArtifactDeclarationSerializerTestCase.createStringParameter("ALWAYS_JOIN")).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Query").withParameter("sql", ArtifactDeclarationSerializerTestCase.createStringParameter("INSERT INTO PLANET(POSITION, NAME) VALUES (:position, :name)")).withParameter("parameterTypes", (ParameterValue)ElementDeclarer.newListValue().withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("key", ArtifactDeclarationSerializerTestCase.createStringParameter("name")).withParameter("type", ArtifactDeclarationSerializerTestCase.createStringParameter("VARCHAR")).build()).withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("key", ArtifactDeclarationSerializerTestCase.createStringParameter("position")).withParameter("type", ArtifactDeclarationSerializerTestCase.createStringParameter("INTEGER")).build()).build()).getDeclaration())).getDeclaration()).getDeclaration())).withRoute((RouteElementDeclaration)core.newRoute("otherwise").withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)core.newOperation("foreach").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("collection", ArtifactDeclarationSerializerTestCase.createStringParameter("#[myCollection]")).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)core.newOperation("logger").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("message", ArtifactDeclarationSerializerTestCase.createStringParameter("#[payload]")).getDeclaration())).getDeclaration())).getDeclaration()).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)db.newOperation("bulkInsert").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"General").withParameter("bulkInputParameters", ArtifactDeclarationSerializerTestCase.createStringParameter("#[payload.changes]")).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Query").withParameter("sql", ArtifactDeclarationSerializerTestCase.createStringParameter("INSERT INTO PLANET(POSITION, NAME) VALUES (:position, :name)")).withParameter("parameterTypes", (ParameterValue)ElementDeclarer.newListValue().withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("key", ArtifactDeclarationSerializerTestCase.createStringParameter("name")).withParameter("type", ArtifactDeclarationSerializerTestCase.createStringParameter("VARCHAR")).build()).withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("key", ArtifactDeclarationSerializerTestCase.createStringParameter("position")).withParameter("type", ArtifactDeclarationSerializerTestCase.createStringParameter("INTEGER")).build()).build()).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)((OperationElementDeclarer)http.newOperation("request").withConfig("httpRequester")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"URI Settings").withParameter("path", ArtifactDeclarationSerializerTestCase.createStringParameter("/nested")).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("method", ArtifactDeclarationSerializerTestCase.createStringParameter("POST")).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)db.newOperation("insert").withConfig("dbConfig")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Query").withParameter("sql", ArtifactDeclarationSerializerTestCase.createStringParameter("INSERT INTO PLANET(POSITION, NAME, DESCRIPTION) VALUES (777, 'Pluto', :description)")).withParameter("parameterTypes", (ParameterValue)ElementDeclarer.newListValue().withValue((ParameterValue)ElementDeclarer.newObjectValue().withParameter("key", ArtifactDeclarationSerializerTestCase.createStringParameter("description")).withParameter("type", ArtifactDeclarationSerializerTestCase.createStringParameter("CLOB")).build()).build()).withParameter("inputParameters", ArtifactDeclarationSerializerTestCase.createStringParameter("#[{{'description' : payload}}]")).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)sockets.newOperation("sendAndReceive").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("streamingStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("repeatable-in-memory-stream").withParameter("bufferSizeIncrement", ArtifactDeclarationSerializerTestCase.createNumberParameter("8")).withParameter("bufferUnit", ArtifactDeclarationSerializerTestCase.createStringParameter("KB")).withParameter("initialBufferSize", ArtifactDeclarationSerializerTestCase.createNumberParameter("51")).withParameter("maxBufferSize", ArtifactDeclarationSerializerTestCase.createNumberParameter("1000")).build()).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Output").withParameter("target", ArtifactDeclarationSerializerTestCase.createStringParameter("myVar")).withParameter("targetValue", ArtifactDeclarationSerializerTestCase.createStringParameter("#[message]")).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)core.newOperation("flowRef").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("name", ArtifactDeclarationSerializerTestCase.createStringParameter("testSubFlow")).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)core.newOperation("try").withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)wsc.newOperation("consume").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("operation", ArtifactDeclarationSerializerTestCase.createStringParameter("GetCitiesByCountry")).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Message").withParameter("attachments", ArtifactDeclarationSerializerTestCase.createStringParameter("#[{}]")).withParameter("headers", ArtifactDeclarationSerializerTestCase.createStringParameter("#[{\"headers\": {con#headerIn: \"Header In Value\",con#headerInOut: \"Header In Out Value\"}]")).withParameter("body", ArtifactDeclarationSerializerTestCase.createStringParameter("#[payload]")).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("errorHandler").withComponent((ComponentElementDeclaration)((RouteElementDeclarer)core.newRoute("onErrorContinue").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("type", ArtifactDeclarationSerializerTestCase.createStringParameter("MULE:ANY")).getDeclaration())).withComponent((ComponentElementDeclaration)core.newOperation("logger").getDeclaration()).getDeclaration())).withComponent((ComponentElementDeclaration)((RouteElementDeclarer)core.newRoute("onErrorPropagate").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("type", ArtifactDeclarationSerializerTestCase.createStringParameter("WSC:CONNECTIVITY")).withParameter("when", ArtifactDeclarationSerializerTestCase.createStringParameter("#[e.cause == null]")).getDeclaration())).getDeclaration())).getDeclaration())).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("schedulerFlow").withComponent((ComponentElementDeclaration)((SourceElementDeclarer)core.newSource("scheduler").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("schedulingStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("org.mule.runtime.core.api.source.scheduler.FixedFrequencyScheduler").withParameter("frequency", ArtifactDeclarationSerializerTestCase.createNumberParameter("50")).withParameter("startDelay", ArtifactDeclarationSerializerTestCase.createNumberParameter("20")).withParameter("timeUnit", ArtifactDeclarationSerializerTestCase.createStringParameter("SECONDS")).build()).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)core.newOperation("logger").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("message", ArtifactDeclarationSerializerTestCase.createStringParameter("#[payload]")).getDeclaration())).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("cronSchedulerFlow").withComponent((ComponentElementDeclaration)((SourceElementDeclarer)core.newSource("scheduler").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("schedulingStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("org.mule.runtime.core.api.source.scheduler.CronScheduler").withParameter("expression", ArtifactDeclarationSerializerTestCase.createStringParameter("0/1 * * * * ?")).build()).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)core.newOperation("logger").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("message", ArtifactDeclarationSerializerTestCase.createStringParameter("#[payload]")).getDeclaration())).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("fileListenerToObjectStore").withComponent((ComponentElementDeclaration)((SourceElementDeclarer)((SourceElementDeclarer)file.newSource("listener").withConfig("fileConfig")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("schedulingStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("org.mule.runtime.core.api.source.scheduler.FixedFrequencyScheduler").withParameter("frequency", "1").withParameter("timeUnit", "MINUTES").build()).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)os.newOperation("store").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("key", ArtifactDeclarationSerializerTestCase.createStringParameter("key")).withParameter("failOnNullValue", ArtifactDeclarationSerializerTestCase.createBooleanParameter("#[vars.failOnNullValue]")).withParameter("objectStore", ArtifactDeclarationSerializerTestCase.createStringParameter("persistentStore")).withParameter("value", ArtifactDeclarationSerializerTestCase.createStringParameter("#[payload]")).getDeclaration())).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("fileListenerToObjectStoreCron").withComponent((ComponentElementDeclaration)((SourceElementDeclarer)((SourceElementDeclarer)file.newSource("listener").withConfig("fileConfig")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("schedulingStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("org.mule.runtime.core.api.source.scheduler.CronScheduler").withParameter("expression", ArtifactDeclarationSerializerTestCase.createStringParameter("0,4,25,26,53 0 0 ? * * *")).build()).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)os.newOperation("store").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("key", ArtifactDeclarationSerializerTestCase.createStringParameter("key")).withParameter("failOnNullValue", ArtifactDeclarationSerializerTestCase.createBooleanParameter("#[vars.failOnNullValue]")).withParameter("objectStore", ArtifactDeclarationSerializerTestCase.createStringParameter("persistentStore")).withParameter("value", ArtifactDeclarationSerializerTestCase.createStringParameter("#[payload]")).getDeclaration())).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("dbListenerToObjectStoreCron").withComponent((ComponentElementDeclaration)((SourceElementDeclarer)((SourceElementDeclarer)db.newSource("listener").withConfig("dbConfig")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("schedulingStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType("org.mule.runtime.core.api.source.scheduler.CronScheduler").withParameter("expression", ArtifactDeclarationSerializerTestCase.createStringParameter("0,4,25,26,51 0 0 ? * * *")).build()).withParameter("table", ArtifactDeclarationSerializerTestCase.createStringParameter("person")).withParameter("watermarkColumn", ArtifactDeclarationSerializerTestCase.createStringParameter("timestamp")).withParameter("idColumn", ArtifactDeclarationSerializerTestCase.createStringParameter("id")).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)os.newOperation("store").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("key", ArtifactDeclarationSerializerTestCase.createStringParameter("key")).withParameter("failOnNullValue", ArtifactDeclarationSerializerTestCase.createBooleanParameter("#[vars.failOnNullValue]")).withParameter("objectStore", ArtifactDeclarationSerializerTestCase.createStringParameter("persistentStore")).withParameter("value", ArtifactDeclarationSerializerTestCase.createStringParameter("#[payload]")).getDeclaration())).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("testSubFlow").withComponent((ComponentElementDeclaration)((OperationElementDeclarer)core.newOperation("logger").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("message", ArtifactDeclarationSerializerTestCase.createStringParameter("onTestSubFlow")).getDeclaration())).getDeclaration())).getDeclaration()).getDeclaration();
    }

    private static Object createNoMuleComponentsArtifactDeclaration() {
        ElementDeclarer core = ElementDeclarer.forExtension((String)"mule");
        ElementDeclarer jms = ElementDeclarer.forExtension((String)"JMS");
        ElementDeclarer http = ElementDeclarer.forExtension((String)"HTTP");
        return ElementDeclarer.newArtifact().withGlobalElement((GlobalElementDeclaration)jms.newConfiguration("config").withRefName("config").withConnection((ConnectionElementDeclaration)((ConnectionElementDeclarer)jms.newConnection("active-mq").withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("cachingStrategy", (ParameterValue)ElementDeclarer.newObjectValue().ofType(NoCachingConfiguration.class.getName()).build()).getDeclaration())).getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)http.newConfiguration("requestConfig").withRefName("httpRequester").withConnection((ConnectionElementDeclaration)http.newConnection("request").getDeclaration()).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("send-payload").withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)((OperationElementDeclarer)jms.newOperation("publish").withConfig("config")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("destination", ArtifactDeclarationSerializerTestCase.createStringParameter("#[initialDestination]")).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"Message").withParameter("body", ArtifactDeclarationSerializerTestCase.createStringParameter("#[payload]")).withParameter("properties", ArtifactDeclarationSerializerTestCase.createStringParameter("#[{(initialProperty): propertyValue}]")).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)((OperationElementDeclarer)http.newOperation("request").withConfig("httpRequester")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"URI Settings").withParameter("path", ArtifactDeclarationSerializerTestCase.createStringParameter("/nested")).getDeclaration())).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("method", ArtifactDeclarationSerializerTestCase.createStringParameter("POST")).getDeclaration())).getDeclaration())).getDeclaration()).withGlobalElement((GlobalElementDeclaration)((ConstructElementDeclarer)((ConstructElementDeclarer)core.newConstruct("flow").withRefName("bridge").withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)jms.newOperation("consume").withConfig("config")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup().withParameter("destination", ArtifactDeclarationSerializerTestCase.createStringParameter("#[initialDestination]")).withParameter("maximumWait", ArtifactDeclarationSerializerTestCase.createNumberParameter("1000")).getDeclaration())).getDeclaration())).withComponent((ComponentElementDeclaration)((OperationElementDeclarer)((OperationElementDeclarer)http.newOperation("request").withConfig("httpRequester")).withParameterGroup((ParameterGroupElementDeclaration)ElementDeclarer.newParameterGroup((String)"URI Settings").withParameter("path", ArtifactDeclarationSerializerTestCase.createStringParameter("/nested")).getDeclaration())).getDeclaration())).getDeclaration()).getDeclaration();
    }

    private static ParameterValue createNumberParameter(String value) {
        return ArtifactDeclarationSerializerTestCase.createParameter(value, SimpleValueType.NUMBER);
    }

    protected static ParameterValue createStringParameter(String value) {
        return ArtifactDeclarationSerializerTestCase.createParameter(value, SimpleValueType.STRING);
    }

    private static ParameterValue createBooleanParameter(String value) {
        return ArtifactDeclarationSerializerTestCase.createParameter(value, SimpleValueType.BOOLEAN);
    }

    private static ParameterValue createParameter(String value, SimpleValueType type) {
        return ParameterSimpleValue.plain((String)value, (SimpleValueType)type);
    }

    private static ParameterValue createStringCDataParameter(String value) {
        return ParameterSimpleValue.cdata((String)value, (SimpleValueType)SimpleValueType.STRING);
    }
}

