/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.config.parsers;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.exception.MuleException;
import org.mule.test.runner.ArtifactClassLoaderRunnerConfig;
import org.mule.tests.api.pojos.ElementWithAttributeAndChild;
import org.mule.tests.api.pojos.MyPojo;
import org.mule.tests.api.pojos.ParameterCollectionParser;
import org.mule.tests.api.pojos.SameChildTypeContainer;
import org.mule.tests.api.pojos.TextPojo;

@ArtifactClassLoaderRunnerConfig(applicationSharedRuntimeLibs={"org.mule.tests:mule-derby-all", "org.mule.tests:mule-activemq-broker"})
public class XmlDslProcessingTestCase
extends MuleArtifactFunctionalTestCase {
    protected String getConfigFile() {
        return "org/mule/test/config/parsers/xml-dsl-processing-config.xml";
    }

    @Test
    public void onlySimpleParametersInSingleAttribute() {
        ParameterCollectionParser parsersTestObject = (ParameterCollectionParser)this.registry.lookupByName("onlySimpleParametersObject").get();
        this.assertPabloChildParameters(parsersTestObject);
    }

    @Test
    public void firstComplexChildUsingWrapper() {
        ParameterCollectionParser parsersTestObject = (ParameterCollectionParser)this.registry.lookupByName("onlyComplexFirstChildParameterObject").get();
        this.assertPabloChildParameters(parsersTestObject.getFirstChild());
    }

    @Test
    public void secondComplexChildUsingWrapper() {
        ParameterCollectionParser parsersTestObject = (ParameterCollectionParser)this.registry.lookupByName("onlyComplexSecondChildParameterObject").get();
        this.assertMarianoChildParameters(parsersTestObject.getSecondChild());
    }

    @Test
    public void complexChildrenListUsingWrapper() {
        ParameterCollectionParser parsersTestObject = (ParameterCollectionParser)this.registry.lookupByName("onlyComplexChildrenListParameterObject").get();
        this.assertCollectionChildrenContent(parsersTestObject.getOtherChildren());
    }

    @Test
    public void completeParametersObject() {
        ParameterCollectionParser parsersTestObject = (ParameterCollectionParser)this.registry.lookupByName("completeParametersObject").get();
        this.assertPabloChildParameters(parsersTestObject);
        this.assertPabloChildParameters(parsersTestObject.getFirstChild());
        this.assertMarianoChildParameters(parsersTestObject.getSecondChild());
        this.assertCollectionChildrenContent(parsersTestObject.getOtherChildren());
    }

    @Test
    public void customCollectionTypeObject() {
        ParameterCollectionParser parsersTestObject = (ParameterCollectionParser)this.registry.lookupByName("customCollectionTypeObject").get();
        LinkedList collectionObject = parsersTestObject.getOtherChildrenCustomCollectionType();
        Assert.assertThat((Object)collectionObject, (Matcher)Matchers.instanceOf(LinkedList.class));
        this.assertCollectionChildrenContent(collectionObject);
    }

    @Test
    public void simpleTypeObject() {
        ParameterCollectionParser parsersTestObject = (ParameterCollectionParser)this.registry.lookupByName("simpleTypeObject").get();
        this.assertSimpleTypeCollectionValues(parsersTestObject.getSimpleTypeChildList());
        Assert.assertThat((Object)parsersTestObject.getSimpleTypeChildSet(), (Matcher)Matchers.instanceOf(Set.class));
        this.assertSimpleTypeCollectionValues(parsersTestObject.getSimpleTypeChildSet());
        this.assertSimpleTypeCollectionValues(parsersTestObject.getOtherSimpleTypeChildList());
    }

    @Test
    public void simpleTypeMapObject() {
        ParameterCollectionParser parsersTestObject = (ParameterCollectionParser)this.registry.lookupByName("simpleTypeMapObject").get();
        Map simpleTypeMap = parsersTestObject.getSimpleTypeEntry();
        Assert.assertThat((Object)simpleTypeMap.size(), (Matcher)Is.is((Object)2));
    }

    @Test
    public void simpleListTypeMapObject() throws MuleException {
        ParameterCollectionParser parsersTestObject = (ParameterCollectionParser)this.registry.lookupByName("simpleTypeCollectionMapObject").get();
        Map simpleListTypeMap = parsersTestObject.getSimpleListTypeEntry();
        Assert.assertThat((Object)simpleListTypeMap.size(), (Matcher)Is.is((Object)2));
        List firstCollection = (List)simpleListTypeMap.get("1");
        Assert.assertThat((Object)firstCollection, (Matcher)Matchers.hasItems((Object[])new String[]{"value1", "value2"}));
        List secondCollection = (List)simpleListTypeMap.get("2");
        Assert.assertThat((Object)secondCollection, (Matcher)Matchers.hasItems((Object[])new String[]{"some value"}));
    }

    @Test
    @Ignore(value="MULE-18586")
    public void complexTypeMapObject() {
        ParameterCollectionParser parsersTestObject = (ParameterCollectionParser)this.registry.lookupByName("complexTypeMapObject").get();
        Map simpleTypeMap = parsersTestObject.getComplexTypeEntry();
        Assert.assertThat((Object)simpleTypeMap.size(), (Matcher)Is.is((Object)2));
        this.assertPabloChildParameters((ParameterCollectionParser)simpleTypeMap.get(1L));
        this.assertMarianoChildParameters((ParameterCollectionParser)simpleTypeMap.get(2L));
    }

    @Test
    public void pojoWithDefaultValue() {
        ElementWithAttributeAndChild parameterAndChildElement = (ElementWithAttributeAndChild)this.registry.lookupByName("pojoWithDefaultValue").get();
        Assert.assertThat((Object)parameterAndChildElement.getMyPojo(), (Matcher)Is.is((Object)new MyPojo("jose")));
    }

    @Test
    public void pojoFromConfiguraitonParameter() {
        ElementWithAttributeAndChild parameterAndChildElement = (ElementWithAttributeAndChild)this.registry.lookupByName("pojoWithAttribute").get();
        Assert.assertThat((Object)parameterAndChildElement.getMyPojo(), (Matcher)Is.is((Object)new MyPojo("pepe")));
    }

    @Test
    public void pojoFromChildConfiguration() {
        ElementWithAttributeAndChild parameterAndChildElement = (ElementWithAttributeAndChild)this.registry.lookupByName("pojoWithChild").get();
        Assert.assertThat((Object)parameterAndChildElement.getMyPojo(), (Matcher)Is.is((Object)new MyPojo("pepe")));
    }

    @Test
    public void objectWithTwoChildrenOfSameTypeWithoutWrapper() {
        SameChildTypeContainer pojoWithSameTypeChildren = (SameChildTypeContainer)this.registry.lookupByName("sameChildTypesObject").get();
        this.assertPabloChildParameters(pojoWithSameTypeChildren.getElementTypeA());
        this.assertMarianoChildParameters(pojoWithSameTypeChildren.getAnotherElementTypeA());
    }

    @Test
    public void textPojo() {
        TextPojo pojo = (TextPojo)this.registry.lookupByName("textPojo").get();
        Assert.assertThat((Object)pojo, (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        Assert.assertThat((Object)pojo.getSomeParameter(), (Matcher)Is.is((Object)"select * from PLANET"));
    }

    private void assertSimpleTypeCollectionValues(Collection<String> simpleTypeCollectionValues) {
        Assert.assertThat((Object)simpleTypeCollectionValues.size(), (Matcher)Is.is((Object)2));
        Assert.assertThat(simpleTypeCollectionValues, (Matcher)Matchers.hasItems((Object[])new String[]{"value1", "value2"}));
    }

    private void assertCollectionChildrenContent(List<ParameterCollectionParser> collectionObjects) {
        this.assertPabloChildParameters(collectionObjects.get(0));
        this.assertMarianoChildParameters(collectionObjects.get(1));
    }

    private void assertPabloChildParameters(ParameterCollectionParser simpleParameters) {
        Assert.assertThat((Object)simpleParameters.getFirstname(), (Matcher)Is.is((Object)"Pablo"));
        Assert.assertThat((Object)simpleParameters.getLastname(), (Matcher)Is.is((Object)"La Greca"));
        Assert.assertThat((Object)simpleParameters.getAge(), (Matcher)Is.is((Object)32));
    }

    private void assertMarianoChildParameters(ParameterCollectionParser simpleParameters) {
        Assert.assertThat((Object)simpleParameters.getFirstname(), (Matcher)Is.is((Object)"Mariano"));
        Assert.assertThat((Object)simpleParameters.getLastname(), (Matcher)Is.is((Object)"Gonzalez"));
        Assert.assertThat((Object)simpleParameters.getAge(), (Matcher)Is.is((Object)31));
    }
}

