/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.integration.security;

import io.qameta.allure.Feature;
import jakarta.inject.Inject;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.After;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.IntegrationTestCaseRunnerConfig;
import org.mule.tests.api.TestQueueManager;

@Feature(value="HTTP Extension")
public class HttpListenerAuthenticationTestCase
extends MuleArtifactFunctionalTestCase
implements IntegrationTestCaseRunnerConfig {
    private static final String BASIC_REALM_MULE_REALM = "Basic realm=\"mule-realm\", charset=\"UTF-8\"";
    private static final String VALID_USER = "user";
    private static final String VALID_PASSWORD = "password";
    private static final String INVALID_PASSWORD = "invalidPassword";
    private static final String EXPECTED_PAYLOAD = "TestBasicAuthOk";
    CloseableHttpClient httpClient;
    CloseableHttpResponse httpResponse;
    @Inject
    private TestQueueManager queueManager;
    @Rule
    public DynamicPort listenPort = new DynamicPort("port");

    protected String getConfigFile() {
        return "org/mule/test/integration/security/http-listener-authentication-config.xml";
    }

    @After
    public void tearDown() {
        IOUtils.closeQuietly((Closeable)this.httpResponse);
        IOUtils.closeQuietly((Closeable)this.httpClient);
    }

    @Test
    public void invalidBasicAuthentication() throws Exception {
        CredentialsProvider credsProvider = this.getCredentialsProvider(VALID_USER, INVALID_PASSWORD);
        this.getHttpResponse(credsProvider);
        this.assertUnauthorised();
        MatcherAssert.assertThat((Object)this.queueManager.read("basicAuthentication", 5000L, TimeUnit.MILLISECONDS).getMessage(), (Matcher)Is.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void validBasicAuthentication() throws Exception {
        CredentialsProvider credsProvider = this.getCredentialsProvider(VALID_USER, VALID_PASSWORD);
        this.getHttpResponse(credsProvider);
        MatcherAssert.assertThat((Object)this.httpResponse.getStatusLine().getStatusCode(), (Matcher)Is.is((Object)HttpConstants.HttpStatus.OK.getStatusCode()));
        MatcherAssert.assertThat((Object)IOUtils.toString((InputStream)this.httpResponse.getEntity().getContent()), (Matcher)Is.is((Object)EXPECTED_PAYLOAD));
    }

    @Test
    public void noProvider() throws Exception {
        CredentialsProvider credsProvider = this.getCredentialsProvider(VALID_USER, VALID_PASSWORD);
        this.getHttpResponse(credsProvider, "zaraza");
        MatcherAssert.assertThat((Object)this.httpResponse.getStatusLine().getStatusCode(), (Matcher)Is.is((Object)HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getStatusCode()));
        MatcherAssert.assertThat((Object)this.httpResponse.getStatusLine().getReasonPhrase(), (Matcher)Is.is((Object)HttpConstants.HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase()));
        MatcherAssert.assertThat((Object)this.queueManager.read("basicAuthentication", 5000L, TimeUnit.MILLISECONDS).getMessage(), (Matcher)Is.is((Matcher)Matchers.notNullValue()));
    }

    @Test
    public void extendedEncodedHeader() throws Exception {
        HttpPost httpPost = new HttpPost(String.format("http://localhost:%s/basic?provider=%s", this.listenPort.getNumber(), "memory-provider"));
        httpPost.addHeader("Authorization", "Basic dXNlcjpwYXNzd29yZA==PEPE");
        this.httpClient = HttpClients.createDefault();
        this.httpResponse = this.httpClient.execute((HttpUriRequest)httpPost);
        this.assertResultForExtendedHeader();
    }

    protected void assertResultForExtendedHeader() {
        this.assertUnauthorised();
    }

    protected void assertUnauthorised() {
        MatcherAssert.assertThat((Object)this.httpResponse.getStatusLine().getStatusCode(), (Matcher)Is.is((Object)HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode()));
        Header authHeader = this.httpResponse.getFirstHeader("WWW-Authenticate");
        MatcherAssert.assertThat((Object)authHeader, (Matcher)Is.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)authHeader.getValue(), (Matcher)Is.is((Object)BASIC_REALM_MULE_REALM));
    }

    private void getHttpResponse(CredentialsProvider credsProvider) throws IOException {
        this.getHttpResponse(credsProvider, "memory-provider");
    }

    private void getHttpResponse(CredentialsProvider credsProvider, String provider) throws IOException {
        HttpPost httpPost = new HttpPost(String.format("http://localhost:%s/basic?provider=%s", this.listenPort.getNumber(), provider));
        this.httpClient = HttpClients.custom().setDefaultCredentialsProvider(credsProvider).build();
        this.httpResponse = this.httpClient.execute((HttpUriRequest)httpPost);
    }

    private CredentialsProvider getCredentialsProvider(String user, String password) {
        BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
        credsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(user, password));
        return credsProvider;
    }
}

