/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.spring.security;

import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.core.Is;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.IntegrationTestCaseRunnerConfig;

public class AuthorizationFilterTestCase
extends MuleArtifactFunctionalTestCase
implements IntegrationTestCaseRunnerConfig {
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");

    protected String getConfigFile() {
        return "org/mule/test/spring/security/http-module-filter-test.xml";
    }

    @Test
    public void testNotAuthenticated() throws Exception {
        this.doRequest("localhost", this.getUrl(), HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode());
    }

    @Test
    public void testAuthenticatedButNotAuthorized() throws Exception {
        String body = this.doRequest(null, "localhost", "anon", "anon", this.getUrl(), false, HttpConstants.HttpStatus.OK.getStatusCode());
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.equalTo((Object)"unauthorized"));
    }

    @Test
    public void testAuthorized() throws Exception {
        String body = this.doRequest(null, "localhost", "ross", "ross", this.getUrl(), false, HttpConstants.HttpStatus.OK.getStatusCode());
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.equalTo((Object)"authorized"));
    }

    @Test
    public void testAuthorizedInAnotherFlow() throws Exception {
        String body = this.doRequest(null, "localhost", "ross", "ross", this.getUrl(), false, HttpConstants.HttpStatus.OK.getStatusCode());
        MatcherAssert.assertThat((Object)body, (Matcher)Matchers.equalTo((Object)"authorized"));
    }

    protected String getUrl() {
        return "http://localhost:" + this.port1.getNumber() + "/authorize";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRequest(String host, String url, int result) throws Exception {
        HttpClient client = new HttpClient();
        GetMethod get = new GetMethod(url);
        try {
            int status = client.executeMethod((HttpMethod)get);
            MatcherAssert.assertThat((Object)result, (Matcher)Is.is((Object)status));
            MatcherAssert.assertThat((Object)get.getResponseHeader("WWW-Authenticate"), (Matcher)Matchers.not((Matcher)Matchers.nullValue()));
            MatcherAssert.assertThat((Object)get.getResponseHeader("WWW-Authenticate").getValue(), (Matcher)Matchers.containsString((String)"mule-realm"));
        }
        finally {
            get.releaseConnection();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doRequest(String realm, String host, String user, String pass, String url, boolean handshake, int result) throws Exception {
        String body;
        HttpClient client = new HttpClient();
        client.getParams().setAuthenticationPreemptive(true);
        client.getState().setCredentials(new AuthScope(host, -1, realm), (Credentials)new UsernamePasswordCredentials(user, pass));
        GetMethod get = new GetMethod(url);
        get.setDoAuthentication(handshake);
        try {
            int status = client.executeMethod((HttpMethod)get);
            if (status == HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode() && handshake && (status = client.executeMethod((HttpMethod)get)) == HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode() && handshake) {
                status = client.executeMethod((HttpMethod)get);
            }
            Assert.assertEquals((long)result, (long)status);
        }
        finally {
            body = get.getResponseBodyAsString();
            get.releaseConnection();
        }
        return body;
    }
}

