/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.spring.security;

import jakarta.inject.Inject;
import java.util.concurrent.TimeUnit;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.extension.http.api.HttpResponseAttributes;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.notification.SecurityNotification;
import org.mule.runtime.api.notification.SecurityNotificationListener;
import org.mule.runtime.api.util.concurrent.Latch;
import org.mule.runtime.http.api.HttpConstants;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.IntegrationTestCaseRunnerConfig;
import org.mule.tests.api.TestQueueManager;

public class SecureHttpPollingFunctionalTestCase
extends MuleArtifactFunctionalTestCase
implements IntegrationTestCaseRunnerConfig {
    @Inject
    private TestQueueManager queueManager;
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");

    protected String[] getConfigFiles() {
        return new String[]{"org/mule/test/spring/security/secure-http-polling-server-flow.xml", "org/mule/test/spring/security/secure-http-polling-client-flow.xml"};
    }

    @Test
    public void testPollingHttpConnectorSentCredentials() throws Exception {
        final Latch latch = new Latch();
        this.notificationListenerRegistry.registerListener((NotificationListener)new SecurityNotificationListener<SecurityNotification>(){

            public boolean isBlocking() {
                return false;
            }

            public void onNotification(SecurityNotification notification) {
                latch.countDown();
            }
        });
        Message result = this.queueManager.read("toclient", 5000L, TimeUnit.MILLISECONDS).getMessage();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)result.getPayload().getValue(), (Matcher)CoreMatchers.is((Object)"foo"));
        result = this.queueManager.read("toclient2", 5000L, TimeUnit.MILLISECONDS).getMessage();
        MatcherAssert.assertThat((Object)result, (Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue()));
        MatcherAssert.assertThat((Object)result.getAttributes().getValue(), (Matcher)CoreMatchers.instanceOf(HttpResponseAttributes.class));
        MatcherAssert.assertThat((Object)((HttpResponseAttributes)result.getAttributes().getValue()).getStatusCode(), (Matcher)CoreMatchers.is((Object)HttpConstants.HttpStatus.UNAUTHORIZED.getStatusCode()));
        MatcherAssert.assertThat((Object)latch.await(5000L, TimeUnit.MILLISECONDS), (Matcher)CoreMatchers.is((Object)true));
    }
}

