/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.spring.security;

import java.util.Collection;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.mule.extension.spring.api.security.SpringProviderAdapter;
import org.mule.extension.spring.api.security.UserAndPasswordAuthenticationProvider;
import org.mule.functional.junit4.MuleArtifactFunctionalTestCase;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.core.api.security.SecurityManager;
import org.mule.runtime.core.api.security.SecurityProvider;
import org.mule.tck.junit4.rule.DynamicPort;
import org.mule.test.IntegrationTestCaseRunnerConfig;

public class AuthenticationNamespaceHandlerFlowTestCase
extends MuleArtifactFunctionalTestCase
implements IntegrationTestCaseRunnerConfig {
    @Rule
    public DynamicPort port1 = new DynamicPort("port1");

    protected String getConfigFile() {
        return "org/mule/test/spring/security/authentication-config-flow.xml";
    }

    @Test
    public void testSecurityManagerConfigured() {
        SecurityManager securityManager = (SecurityManager)this.registry.lookupByName("_muleSecurityManager").get();
        Assert.assertNotNull((Object)securityManager);
        Collection providers = securityManager.getProviders();
        MatcherAssert.assertThat((Object)providers, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)this.containsSecurityProvider(providers, UserAndPasswordAuthenticationProvider.class), (Matcher)Matchers.is((Object)true));
    }

    private boolean containsSecurityProvider(Collection<SecurityProvider> providers, Class authenticationProviderClass) {
        for (SecurityProvider provider : providers) {
            MatcherAssert.assertThat((Object)provider, (Matcher)Matchers.instanceOf(SpringProviderAdapter.class));
            MatcherAssert.assertThat((Object)provider, (Matcher)Matchers.instanceOf(Component.class));
            if (!authenticationProviderClass.isAssignableFrom(((SpringProviderAdapter)provider).getAuthenticationProvider().getClass())) continue;
            return true;
        }
        return false;
    }
}

